/*
 *  HP 9000 Series 800 Linker, Copyright Hewlett-Packard Co. 1985-1999  
 *  Dense Set Routines
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/* routines for dense sets. */

#include <stdio.h>

#ifndef DEBUG
#define NDEBUG
#endif
#include <assert.h>

#include "std.h"
#if 0
#define BOOLEAN	Boolean
#endif
#include "bv_dense.h"
#include "util.h"

static unsigned char bit_count[256] = {
   0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,1,2,2,3,2,3,3,4,2,3,3,4,3,4,4,5,
   1,2,2,3,2,3,3,4,2,3,3,4,3,4,4,5,2,3,3,4,3,4,4,5,3,4,4,5,4,5,5,6,
   1,2,2,3,2,3,3,4,2,3,3,4,3,4,4,5,2,3,3,4,3,4,4,5,3,4,4,5,4,5,5,6,
   2,3,3,4,3,4,4,5,3,4,4,5,4,5,5,6,3,4,4,5,4,5,5,6,4,5,5,6,5,6,6,7,
   1,2,2,3,2,3,3,4,2,3,3,4,3,4,4,5,2,3,3,4,3,4,4,5,3,4,4,5,4,5,5,6,
   2,3,3,4,3,4,4,5,3,4,4,5,4,5,5,6,3,4,4,5,4,5,5,6,4,5,5,6,5,6,6,7,
   2,3,3,4,3,4,4,5,3,4,4,5,4,5,5,6,3,4,4,5,4,5,5,6,4,5,5,6,5,6,6,7,
   3,4,4,5,4,5,5,6,4,5,5,6,5,6,6,7,4,5,5,6,5,6,6,7,5,6,6,7,6,7,7,8
   };

#define COUNT_ONES(v)\
       (bit_count[(v) & 255] + bit_count[((v) >> 8) & 255]\
	+ bit_count[((v) >> 16) & 255] + bit_count[((v) >> 24) & 255])


#define WORD_OFFSET(pos)	((pos) >> 5)
#define BIT_OFFSET(pos)		((pos) & 31)

/* routine to count the number of set bits in a segment of a dense set */

unsigned int num_elements (set, start_pos, stop_pos)

register dense_set_type set;		/* dense set to count segment from */
unsigned int start_pos, stop_pos;	/* start and stop bit offsets in set */
{

    register unsigned int count;  /* running total */
    register unsigned int first_word;  /* first word of the bit vector */
    register unsigned int *pk, *p_end; /* word pointers within set */
    register unsigned int word;

    assert(start_pos <= stop_pos);
    assert(stop_pos <= set->size);

    /* if the segment is wholly contained in one word */
/*
	31				0 
	|       XXXXXXXXXXXXXXXXXXXXXXX  |
	\--------------------------------/
*/

    if (WORD_OFFSET(start_pos) == WORD_OFFSET(stop_pos)) {
        first_word = ( (set->data[WORD_OFFSET(stop_pos)] >> 
						BIT_OFFSET(start_pos) ) &
			    (((unsigned)(-1)) >> (31-(stop_pos-start_pos))));
	return (COUNT_ONES( first_word ));
	}


    /* the segment uses two or more words */
/*
	31				0   31				    0 
	|XXXXXXXXXXXXXXXX                |  |       XXXXXXXXXXXXXXXXXXXXXXXXX|
	\--------------------------------/  \--------------------------------/
*/

    pk    = & set->data[WORD_OFFSET(start_pos)];
    p_end = & set->data[WORD_OFFSET(stop_pos)];
    first_word = (*(pk++) & ((-1) << BIT_OFFSET(start_pos)));
    count = COUNT_ONES(first_word);
	/* count left-hand (high-order) end of first word */

    do {
	word = *pk++;

	if (pk > p_end) {
	    if (word == 0)
	        return (count);
	    word &= (((unsigned)(-1))>>(31-BIT_OFFSET(stop_pos)));
	    return (count + COUNT_ONES(word));
	    /* previous + bits on in right-hand (low order) part of word used */
	    }

	if (word == 0)
	    continue;		/* if whole word zero, can't contribute ones */

	count += COUNT_ONES(word);  /* entire word in segment, count all bits */
    } while (TRUE);
}

#ifdef DEAD_CODE
/* routine to allocate a dense set of size 'n' and return a pointer to it. */
dense_set_type get_dense_set (n)
{
    register dense_set_type set;
    register unsigned int array_size;

    array_size = (n + 31) >> 5; /* get size of the set in words. */
    set = (dense_set_type)
	   ecalloc(1, sizeof (struct dense_set_rec) + array_size * sizeof(int));
    set->size = n;
    set->end_ptr = & set->data[array_size];

    return set;
}
#endif

/* routine to reallocate a dense set of size 'n' and return a pointer to it. */
/* leaves newly allocated bits cleared */

dense_set_type realloc_dense_set (set, n)
register dense_set_type set;
unsigned int n;  /* count of elements in set */
{
    register unsigned int array_size;
    register unsigned *pk, *p;  /* temp ptrs for word-zeroing loop */

    array_size = (n + 31) >> 5; /* get size of the set in words. */

    if (set == NULL) {
	set = (dense_set_type)
		 ecalloc(1,sizeof(struct dense_set_rec) + array_size*sizeof(int));
	}
    else if (n > set->size) {
    	set = (dense_set_type)
	   erealloc((char *) set, 
		    sizeof(struct dense_set_rec) + array_size*sizeof(int));
        set->end_ptr = & set->data[((set->size + 31) >> 5)];
	    /* reset as pointer will be different if realloced to new memory */

    	/* zero trailing new words */
    	pk = & (set->data [array_size-1]); 
    	while (pk >= set->end_ptr) {
	    *pk-- = 0;  
	    }

	set->end_ptr[-1] &= (((unsigned)(-1)) >> (31 - (set->size & 31)));
	    /* clear new bits in last word */
	}

    set->size = n;
    set->end_ptr = & set->data[array_size];

    return set;
}

/* given the current element in the set 'n', this routine returns the
   next element in the set. If there are no more elements left it
   returns DENSE_NEXT_ITEM_END, i.e. -2. It is used by the macro
   FOR_EACH_DENSE_SET_ITEM.
*/
unsigned int next_dense_set_item (set, n)
    dense_set_type set;
    unsigned int n;
{
    register unsigned int ik;
    register unsigned int *pk, *pl;

    n++;
    if (n > set->size) return DENSE_NEXT_ITEM_END;

    pk = & ((set)->data [n >> 5]);
    ik = *pk++;
    ik = ik >> (n & 31);
    if (ik != 0) {
	do {
	    if (ik & 1) return n;
	    ik = ik >> 1;
	    n++;
	} while (TRUE);
    }

    n = (n + 32) & ~31; /* ?? */
    pl = set->end_ptr;
    for (; pk != pl; n = n + 32) {
	if (ik = *pk++) {
	    do {
		if (ik & 1) return n;
		ik = ik >> 1;
		n++;
	    } while (TRUE);
	}
    }
    return DENSE_NEXT_ITEM_END;
}

/* routine to print the contents of 'set_ptr'. */
void dump_dense_set (debug_file, set_ptr, label_str)
    FILE *debug_file;
    dense_set_type set_ptr;
    char *label_str;
{
    register int count;
    register unsigned int n;

    fprintf (debug_file, "%s", label_str);
    count = 0;
    FOR_EACH_DENSE_SET_ITEM (set_ptr, n)
    {
	fprintf (debug_file, " %d", n);
	if (count++ == 15) {
	    count = 0;
	    fprintf (debug_file, "\n");
	}
    }
    fprintf (debug_file, "\n");
}
