/*
 *  HP 9000 Series 800 Linker, Copyright Hewlett-Packard Co. 1985-1999  
 *  Linker information definitions in support of CONVEX development tools
 */

#ifdef CNX_TOOLS

#define CNX_OBJECT_DICTIONARY_REVNO 1

struct cnx_object_dictionary_header {
   unsigned int version;
   unsigned int entries; /* num of object dictionary records */
   unsigned int unused0; 
   unsigned int unused1;  
   unsigned int unused2;
   };

struct cnx_object_dictionary_record {
   unsigned int space;    /* space record index */
   unsigned int subspace; /* subspace record index */
   unsigned int object;   /* input object name (space strings offset) */
   unsigned int start;    /* resolved addr (loadable) or offset (unloadable) */
   unsigned int length;
   };

extern int CNX_SUBSPACE_MAP_subsp_index;
extern struct  cnx_object_dictionary_header *cnx_subspace_map_header;
extern struct  cnx_object_dictionary_record *cnx_subspace_map;
extern void    cnx_subspace_map_create(); 
extern void    cnx_subspace_map_add(); 


#define CNX_COMPILE_DICTIONARY_REVNO 1  

struct cnx_compile_dictionary_header {
   unsigned int version;
   unsigned int entries; /* num of compile dictionary records */
   unsigned int path;    /* link pathname (space strings offset) */
   unsigned int unused0; 
   unsigned int unused1;  
   };

struct cnx_compile_dictionary_record {
   unsigned int unit;      /* compilation unit record index */
   unsigned int object;    /* input object name (space strings offset) */
   };

extern int CNX_COMPILE_MAP_subsp_index;
extern struct  cnx_compile_dictionary_header *cnx_compile_map_header;
extern struct  cnx_compile_dictionary_record *cnx_compile_map;
extern void    cnx_compile_map_create(); 


extern void    cnx_set_link_info_opt(); 
extern void    cnx_build_link_info_subspaces(); 
extern Boolean generate_tools_spaces;

#endif /* CNX_TOOLS */

