/*
 *  HP 9000 Series 800 Linker, Copyright Hewlett-Packard Co. 1985-1999  
 *  Driver Routines
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#define _SVID_SOURCE /* tempnam, strdup --pschwan@thepuffingroup.com */
#include <stdio.h>
#include <string.h>
#undef _SVID_SOURCE

#include <errno.h> /* --pschwan@thepuffingroup.com */
#include "linuxutil.h" /* --pschwan@thepuffingroup.com */

#include <sys/types.h>
#include <sys/stat.h>

#include <signal.h>
#include <stdlib.h>

#include "filehdr.h"
#include "aouthdr.h"

#include "std.h"
#include "driver.h"
#include "embed.h"
#include "errors.h"
#include "fixups.h"
#include "ldlimits.h"
#include "ld_strings.h"
#include "linker.h"
#include "dl.h"
#include "shl.h"
#include "util.h"
#include "libraries.h"
#include "ldnls.h"
#ifdef ESOM
#include "cnx_aout.h"
#endif /* ESOM */

/* This is needed only for the -Fvm output at the end of main() */
#include <syms.h>
#include "symbols.h"

#include "dead_proc.h"

#ifdef WW_ANNOTATIONS
#include "annotate.h"
#endif /* WW_ANNOTATIONS */

/* doom support */
#include "ld_linkmap.h"

#pragma COPYRIGHT "Hewlett-Packard Co. "
#pragma COPYRIGHT_DATE "1985-1999"
/* #pragma VERSIONID PRODUCT_ID  *** now handled in version.h */

/* This allows internal options to be recognized as well as the TWG options */
#define INTERNALOPTIONS 1

#define	DEFAULT_ENTRY_NAME	"$START$"


/* Select OS-dependent defaults */

#define DEFAULT_HPE_DATA_OFFSET		(QUAD_1_BASE+2*WORDSIZE)
#define DEFAULT_HPE_DATA_ROUND		FALSE
#define DEFAULT_HPE_DEMAND_LOAD	        FALSE

#if 0
#define DEFAULT_OSF_DATA_OFFSET		-1
#define DEFAULT_OSF_DATA_ROUND		TRUE
#define DEFAULT_OSF_DEMAND_LOAD	        TRUE
#endif /* 0 */

/* For HPUX, Data Offset is 1 page in due to negative addressing off */
/* of $global$ and the fact that the intermediate result of an addil */
/* must be within the same space as the result!                      */
#define DEFAULT_HPUX_DATA_OFFSET	(QUAD_1_BASE+0x1000)
#define DEFAULT_HPUX_DATA_ROUND		FALSE
#define DEFAULT_HPUX_DEMAND_LOAD	FALSE

#ifdef ESOM
/*
 * For MPP OS all of the data spaces must follow the code space.
 */
#define DEFAULT_CNX_MPP_DATA_OFFSET     -1
#define DEFAULT_CNX_MPP_DATA_ROUND      TRUE
#define DEFAULT_CNX_MPP_DEMAND_LOAD     FALSE
#endif /* ESOM */

#if 0
#define	DEFAULT_OUTPUT_NAME	"a.out"
#define	DEFAULT_LIB_DIR1	"/lib/lib"
#define	DEFAULT_LIB_DIR2	"/usr/lib/lib"
#define DEFAULT_CODE_OFFSET	0x1000
#define	DEFAULT_ELABORATOR_NAME	"_ELABORATOR"
#define	DEFAULT_INITIALIZER_NAME "_INITIALIZER"
#define DEFAULT_DATA_OFFSET	DEFAULT_OSF_DATA_OFFSET
#define DEFAULT_DATA_ROUND      DEFAULT_OSF_DATA_ROUND
#define DEFAULT_DEMAND_LOAD     DEFAULT_OSF_DEMAND_LOAD
#define DEFAULT_OS		OS_HPOSF
#define DEFAULT_STUBS		FALSE
#define DEFAULT_MAPPED		FALSE
#endif /* 0 */

#define	DEFAULT_OUTPUT_NAME	"a.out"

# ifdef V4FS
#define	DEFAULT_LIB_DIR1	"/usr/lib"
#define	DEFAULT_LIB_DIR2	"/opt/langtools/lib"
#define	LIB_DLD_PATH		"/usr/lib/libdld.sl"
# else /* V4FS */
#define	DEFAULT_LIB_DIR1	"/lib"
#define	DEFAULT_LIB_DIR2	"/usr/lib"
#define	LIB_DLD_PATH		"/usr/lib/libdld.sl"
# endif /* V4FS */

#define DEFAULT_CODE_OFFSET	0x1000
#define	DEFAULT_ELABORATOR_NAME	"_ELABORATOR"
#define	DEFAULT_INITIALIZER_NAME "_INITIALIZER"
#define DEFAULT_DATA_OFFSET	DEFAULT_HPUX_DATA_OFFSET
#define DEFAULT_DATA_ROUND      DEFAULT_HPUX_DATA_ROUND
#define DEFAULT_DEMAND_LOAD     DEFAULT_HPUX_DEMAND_LOAD
#define DEFAULT_OS		OS_HPUX
#define DEFAULT_STUBS		FALSE
#define DEFAULT_MAPPED		FALSE

#define	BB_STRING_NAME	"_BB_STRING"
#define	BB_COUNT_NAME	"_BB_COUNT"
#define MB_CUR_MAX   1   /* this should allow the mb_* routines to be */
                         /* removed by the optimizer. They are not being */
                         /* as part of this distribution.                */
    
/* Globals */

extern void process_cmd_line_args();
extern void do_option_plus();
extern void do_option_minus();

extern void usage();
extern void som_list_add();
extern void trace_list_add();
extern void undef_list_add();
extern void hide_list_add();
extern void def_dir_list_add();
extern void promotion_list_add();
extern void dir_list_add();
extern void subprog_list_add();
extern void forget_list_add();
extern void absolute_list_add();
extern void catchint();
extern void env_get_args();
extern void show_command_line();
extern void initialize();
extern void set_fdp_file_names();

extern char *lib_name_build();
extern void set_str_parm();
extern void set_num_parm();
extern void init_parm();
extern void usage();
extern void som_list_add();
extern void trace_list_add();
extern void undef_list_add();
extern void hide_list_add();
extern void dir_list_add();
extern void subprog_list_add();
extern void forget_list_add();
extern void promotion_list_add();
extern void absolute_list_add();
extern void fil_get_args();
extern Boolean invoke_fastbind();
void	invoke_linker_online_help();

#ifndef NO_MULTIPLE_INITIALIZERS
static void initializer_list_add(char*);
#endif /* !NO_MULTIPLE_INITIALIZERS */

extern void add_shlib_name_pair (char *string);

static void expand_dash_l(char *cp, Boolean dash_l_reference);

jmp_buf		drive;
char		*progname = NULL;
struct som_info_type *som_info;
unsigned short  dl_header_flags = 0;    /* flags field in dl header        */
Boolean search_alldefs = FALSE;         /* search all defs for exports?    */
Boolean eliminating_addils = FALSE;     /* remove ADDILs near $global$     */
Boolean sort_stor_reqs = FALSE;         /* sort storage requests           */
Boolean		allow_code_unsats = FALSE;     /* are code unsats allowed in
						  incomplete a.outs?      */
Boolean         dyncall_external_off = FALSE;   /* flag to turn off
						   dyncall_external in -Fz */
Boolean         mixed_mode_off = FALSE;   /* flag to turn off
                                             mixed mode in +nomixedmode */


/* 
** Global hash table support in the linker
*/
int             gh_hash_table_size = SYMTAB_DEFAULT_SIZE;
int             gh_hash_buckets_per_entry = SYMTAB_DEFAULT_NBUCKETS;
int             no_dlheader_ext = FALSE;
int             gh_ext_opt_specified = FALSE;

char		**undef_list = NULL;
char		**trace_list = NULL;
char 		**subprog_list = NULL;
int 		subprog_list_size = 0;
char		**forget_list = NULL;
char            **promotion_list = NULL;
char 		**absolute_list	= NULL;
#ifndef NO_MULTIPLE_INITIALIZERS
char 		**initializer_list = NULL;
#endif /* !NO_MULTIPLE_INITIALIZERS */
unsigned int    *product_key = NULL;	/* product specific key field */

/* Global flags */

/*
** code_offset will now be the __text_start address and
** code_mmap_addr will be the address to which data is mapped.
** code_mmap_addr + unpad_after_header == code_offset
*/
int		code_mmap_addr = DEFAULT_CODE_OFFSET;
int		code_offset = DEFAULT_CODE_OFFSET;

/*
** data_offset will now be the presumed_dp address and
** data_mmap_addr will be the address to which data is mapped.
** data_mmap_addr + unpad_before_private == data_offset
*/
int		data_mmap_addr = DEFAULT_DATA_OFFSET;
int		data_offset = DEFAULT_DATA_OFFSET;
int             default_data_offset = DEFAULT_DATA_OFFSET;
unsigned int	fill_pattern = 0;
unsigned int	magic_number = SHARE_MAGIC;
unsigned int	verbose = V_CHANGE_WARN;

#ifdef ESOM
Boolean         Rflag = FALSE;
Boolean         Dflag = FALSE;
#endif /* ESOM */

int		O_S = DEFAULT_OS;
int		page_size = FOUR_KB;  
int		parmcheck = 3;
int		som_count = -1;
int		dup_symbols = 0;
int		parm_check_errs = 0;
/* 
** pad (in bytes) cutting short branch range to reduce long branch stub 
** addition passes. Experimentally- derived heuristic for UX7.0
*/

int 		lb_reach_pad = 3000;  
int 		product_key_size = 0; /* size of product key field in bytes */


char		*entry_name = DEFAULT_ENTRY_NAME;
char		*output_name = DEFAULT_OUTPUT_NAME;

char		*elaborator_name = DEFAULT_ELABORATOR_NAME;
char		*initializer_name = NULL;
int		clean_stack_size = DEFAULT_CLEAN_STACK;  
		/* stack area in bytes dld is to leave zeroed at startup */

Boolean		align_on_if_flag = FALSE;
Boolean		alloc_stubs_xl = DEFAULT_STUBS;
Boolean		alloc_stubs_ux = FALSE; /* HP-UX shared library globals */
Boolean		delay_aux = FALSE;
Boolean		delay_code = FALSE;
Boolean		delay_compunit = FALSE;
Boolean		delay_fixup = FALSE;
Boolean		delay_init = FALSE;
Boolean		delay_ldrfix = FALSE;
Boolean		delay_space = FALSE;
Boolean		delay_spstr = FALSE;
Boolean		delay_subsp = FALSE;
Boolean		delay_sym = FALSE;
Boolean		delay_symstr = FALSE;
Boolean		extern_plabels = DEFAULT_STUBS;
Boolean		force_common = FALSE;
Boolean		gen_ldr_fixups = DEFAULT_STUBS;
Boolean		hpe_som = FALSE;
Boolean		ipl = FALSE;
Boolean		locality_flag = DEFAULT_STUBS;
Boolean		map = FALSE;
Boolean		mapped = DEFAULT_MAPPED;
Boolean		no_arg_reloc = FALSE;
Boolean		no_promotion = FALSE;
Boolean		no_stub_unwind = FALSE;
Boolean		pri_prog_only = FALSE;
Boolean		relocatable = FALSE;
Boolean		save_data = FALSE;
Boolean		save_fixups = FALSE;
Boolean		strip_debug = FALSE;
Boolean		strip_fixups = TRUE;
Boolean		strip_local_symbols = FALSE;
Boolean		strip_symbols = FALSE;
Boolean		system_som = FALSE;
Boolean         force_ext_milli_syms = FALSE;
Boolean		trace_som = FALSE;
Boolean		trap_nil_ptrs = FALSE;
Boolean		two_pass = TRUE;
Boolean		bad_obj = FALSE;
Boolean		bad_fixups = FALSE;
Boolean		hash_qual = FALSE;
Boolean         relinkable = FALSE;
Boolean         thread_private = FALSE;
Boolean		dumpworthy = FALSE;
Boolean		building_shlib = FALSE;
Boolean		building_incomp_exec = FALSE;
Boolean         reset_secdef_syms = FALSE;
Boolean         ld_footprint_seen = FALSE;
Boolean         no_local_search = FALSE;
Boolean	        sharable = TRUE;
Boolean	        data_on_page_after_text = DEFAULT_DATA_ROUND;
Boolean		bypass_export_stubs = TRUE;
Boolean		keep_aout = TRUE;
Boolean		allow_shlib_unsats = TRUE;
Boolean		dont_allow_unsats = TRUE;
Boolean         comdat_strict_semantics = FALSE;

Boolean		suppress_unwind = FALSE;  
Boolean         inter_binding = FALSE;    /* -B symbolic for building shlib */
/*
** Seperate variables indicate whether we want to unpad before text, data,
** and unloadable spaces.  These are FALSE by default.
*/
Boolean         do_private_unpadding = FALSE;
Boolean         do_text_unpadding = FALSE;
Boolean		do_unloadable_unpadding = FALSE;
Boolean		data_origin_set = FALSE;


#ifdef ESOM
Boolean         esom_no_parallel_obj = FALSE;
Boolean         esom_no_parallel = TRUE;
Boolean         esom_is_parallel = FALSE;
Boolean         esom_is_oversubscribe = FALSE;
Boolean         esom_object = FALSE;
Boolean         esom_spinwait = FALSE;
Boolean         esom_onenode = FALSE;
int             esom_min_cpus = 0;
int             esom_max_cpus = 0;
int             esom_max_thr_node = 0;
int		esom_stack_type = -1;
int		esom_tstack_type = -1;
Boolean 	target_som = FALSE;
Boolean 	target_esom = FALSE;
Boolean         spp2000_target = FALSE;
#endif /* ESOM */

#ifdef CNX_TOOLS
Boolean         generate_tools_spaces = FALSE;
Boolean         force_pxdb = FALSE;
#endif /* CNX_TOOLS */

#ifdef OBS_FEATURES_WARN

/* To-be-changed warnings flags */
static Boolean  emit_dash_A_warn = FALSE;
static Boolean  emit_dash_C_warn = FALSE;
static Boolean  emit_dash_F_warn = FALSE;
static Boolean  emit_dash_H_warn = FALSE;

Boolean         found_change_warn = FALSE;

#endif

/* Support for disabling smart bind */

Boolean         smartbind_enabled = TRUE;

/* NO_DATA_COPY */
Boolean do_data_copy = FALSE;

Boolean         do_fdp_measure  = FALSE; /* Flag to mark instrumentation */
Boolean         do_fdp_position = FALSE; /* Flag to mark repositioning */
Boolean         fdp_verbose = FALSE;     /* Flag for more fdp information */
Boolean         do_procedure_fdp = FALSE; /* Flag for procedure level fdp  */
/* The link_order file passed in */
Boolean         fdp_link_order_supplied = FALSE;
/* Delete unless it is a user supplied link order file */
Boolean         fdp_delete_link_order = TRUE; 
Boolean         do_dbg_fdp      = FALSE; /* position fns even if debuggable */

#ifdef COUNT_LONG_BRANCHES
Boolean         count_long_branches = FALSE;
#endif

Boolean         count_calls = FALSE;

Boolean 	command_file_seen = FALSE;

/* Fastbind incomplete executable ? "+fb" option */

Boolean		is_fastbind = DEFAULT_FASTBIND;

/* Pass "-u" option to fastbind ? "+fbu" option */

Boolean		is_fastbind_unresolved = DEFAULT_FASTBIND_UNRESOLVED;

	/*   The following are for +Oipage= and +Odpage= : to
	** set the new variable size for code and data pages, for PCX-U */
int inst_page_size = 0;
int data_page_size = 0;

static struct {
   char *option;
   int value;
} valid_page_sizes[] = {
   { "d",    0 },        /* default is now "D (kernel choice)" */
   { "D",    0 },
   { "16k",  1 },
   { "16K",  1 },
   { "64k",  2 },
   { "64K",  2 },
   { "256k", 3 },
   { "256K", 3 },
   { "1m",   4 },
   { "1M",   4 },
   { "4m",   5 },
   { "4M",   5 },
   { "16m",  6 },
   { "16M",  6 },
   { "64m",  7 },
   { "64M",  7 },
   { "256m", 8 },
   { "256M", 8 },
   { "4k",   9 },       /*  4k changed from "0" to "9" */
   { "4K",   9 },
   { "l",   15 },
   { "L",   15 },
};

/* export these names with -I -b link */
static char * PBO_exports[] = {
   "_PBO_INITIALIZER",
   "_write_counts",
   "_PBO_register_shlib",
   "_PBO_call_shlib_clear_counters",
   "errno",
   0,
};

char *selectivepercent = '\0';    /* sets ucomp +Pa `n' option        */
char *selectivesize    = '\0';    /* sets ucomp +Pb `n' option        */
char *selectiveO3      = '\0';    /* sets ucomp +Pc option            */
char *selectivepercentarg = '\0';
char *selectivesizearg    = '\0';
char *reusedir = '\0';    /* sets ucomp +Oreusedir= option */

Boolean pcx_u_pa2_0 = FALSE;	/* PCX_U PA 2.0 Instruction Support   */
Boolean staticbranch = FALSE;	/* Branch hint for +Ostaticprediction */

				/* 
				** set use_sr7_import to FALSE because
				** some import stubs are not going to
				** a shared libary and code breaks.
				*/

Boolean use_sr7_import = FALSE;	/* Import stub goes through sr7 for   */
                                /* incomplete a.out.                  */
                                /* If +Ouse_sr7 option is on then     */
				/* the import stub will use LDSID to  */
				/* get the target space register.     */

Boolean allow_link_with_shlibs = TRUE; /* Allow shared libs to be linked */
                                       /* into the resultant executable */

static char *fdp_counter_file_string = "flow.data";

#define SCRT0_FILE_NAME_STRING "/opt/langtools/lib/scrt0.o"
#define SCRT0_INITIALIZER_STRING "_PBO_INITIALIZER"

/* The fdp_counter_file contains a list of execution counts,
 * path flow entries and subspace sizes. It is written at an application's 
 * run time. It is read in by the call graph tool during the repositioning 
 * phase.
 */
char *fdp_counter_file_name; /* Possible quallified path + name */
char *fdp_link_order_file_name='\0'; /* Possible quallified path + name */

FILE *fdp_link_order_file = NULL;

char *fdp_output_name; /* The applications name for writing to flow.data */

#if defined(DEBUG) || defined(PFA)	/* if module-test active */
Boolean module_test = FALSE; /* is runtime module-test active? */
#endif /* DEBUG || PFA */

int	argv_size = MAX_ARGC;
int	argc;
char	**argv;

int bind_mode = BIND_DEFERRED; /* default deferred binding for shared libs */
char *embedded_path = NULL;    /* shared library runtime path string       */ 
int   embedded_path_index = 0; /* shared library runtime path index        */ 

char *shlib_internal_name = NULL;     /* internal shared library name */

/* Removed ifdef PBO_IPO for the -Fu, -Fs code. */

/* 
** Revamped the implementation for emitting the
** pre-link symbol info for -Fu/-Fs.  Now have only 2 global Boolean values,
** and a couple of arrays of FILE pointers for the types of info files we're
** interested in. 
*/

Boolean list_unsats_only = FALSE;  /* -Fu* options set this to TRUE */
Boolean trace_syms_only  = FALSE;  /* -Fs* options set this to TRUE */

FILE *unsat_files     [FU_NUM_ENTRIES] = { 0 };
FILE *trace_sym_files [FS_NUM_ENTRIES] = { 0 };

Boolean unsat_found     = FALSE;

int     save_argc;	/* save the argument list for invoking*/
char    **save_argv;	/* the linker again when isoms existed*/
/* TRUE if the link is invoked after the isoms are compiled */
Boolean ld_after_be_process = FALSE; 
/*
** TRUE if want to keep the compiled isoms.  Default is FALSE, those files
** will be purged.
*/ 
Boolean keep_compiled_isoms = FALSE;   

/*
** if isoms exist, the process_id is used for getting unique file names
** for the temporarily compiled object files.
*/
char    *process_id;                   

char    *backend_command_fname;
FILE    *backend_command_file;
static  char *backend_process = NULL; 
static  Boolean specify_flow_data = FALSE;
static  Boolean specify_profile_pgm = FALSE;

/* initial value of the floating point status register */
unsigned int fp_status = 0;	

/* +symboltablesize */
int symbol_table_size = -1; 

/* Locals */

static char	*default_lib_dir1 = DEFAULT_LIB_DIR1;
static char	*default_lib_dir2 = DEFAULT_LIB_DIR2;
#ifndef ESOM
static int Rflag = 0;
#endif /* ESOM */

#ifdef V4FS_NO_MORE
static char	*default_lib_dir3 = DEFAULT_LIB_DIR3;
#endif /* V4FS */

static char	**def_dir_list = NULL;
static char	**dir_list = NULL;

static int	som_list_max = MAX_SOM_LIST;
static int	som_list_size = 0;

static Boolean	demand_load = DEFAULT_DEMAND_LOAD;
static Boolean  dash_A = FALSE;

static Boolean dont_elim_addils = FALSE; /* flag to turn off optimization */

static int library_search = DEFAULT_LIB_SEARCH;
static int archive_linear_search = FALSE;
static int archive_noloop_search = FALSE;

static int disable_dead_proc = FALSE;

/*  Don't hide initializers */
static int initializer_list_size = 0;

int main(pargc, pargv)
int pargc;
char **pargv;
{
    register char *cp, *cp2;
    register char *lpath;
    int status;
    int nargc;
    char **nargv;
    /* for loop index when copying argv strings to locals */
    int s_index;          

    int i;
    int init_cur_brk;

    char *bad_arg1;       /* for bad argument combinations */
    char *bad_arg2;

    argc = pargc;
    argv = pargv;

     /*
     ** copy the original command line argument list. This list is useful if
     ** isoms exist in the object file and the linker is invoked again after
     ** isoms are compiled by the backend.
     ** We must save what pargv points to by 
     ** doing string copies since the contents will change with 
     ** process_cmd_line_args().  It is not good enough to simply save the
     ** address of pargv (i.e save_argv = pargv).  

     ** where ucomp was only getting the first path in the +cdp path:path
     ** option!
     */
   save_argc = pargc;
   save_argv = (char **) emalloc ((save_argc + 1) * sizeof (char *));

   for (s_index=0; s_index < save_argc; s_index++) {
       save_argv[s_index] = (char *) emalloc (strlen(pargv[s_index]) + 1);
       strcpy (save_argv[s_index], pargv[s_index]);
   }
   save_argv[save_argc] = NULL;

    progname = argv[0];

    init_cur_brk = (int)sbrk(0);

    if (setjmp(drive)) {
        if (verbose & V_MALLOC) {
            printf(ld_gets(1, 1118, "Total data space malloc'ed = %d\n"),
		   (int)sbrk(0)-init_cur_brk);
        }
	cleanup();
	exit(1);
    }

#define CATCH(sig,rtn) if (signal(sig, SIG_IGN) != SIG_IGN) signal(sig, rtn)
    CATCH(SIGHUP, catchint);
    CATCH(SIGINT, catchint);
    CATCH(SIGTERM, catchint);

    init_locale();

    env_get_args();  /* get LDOPTS, if any, and update argc/argv */
    if (argc < 2)
        usage();

    /* 
    ** we first copy the result into local variable. Otherwise, we will
    ** mangle it and the second invocation of ld by ucomp will see the
    ** mangled value only 
    */

    if (cp = getenv("LPATH")) {
      lpath = (char *) emalloc(strlen(cp) + 1);
      strcpy(lpath,cp);
    } else
      lpath = NULL;

    if (lpath) {
	default_lib_dir1 = NULL;
	default_lib_dir2 = NULL;
#ifdef V4FS_NO_MORE
	default_lib_dir3 = NULL;
#endif /* V4FS */
	if (MB_CUR_MAX == 1) 
	    while (cp2 = strchr(lpath, ':')) {
		*cp2++ = '\0';
		def_dir_list_add(lpath);
		lpath = cp2;
        } else {
	    while (cp2 = mb_strchr(lpath, ':')) {
		*cp2++ = '\0';
		def_dir_list_add(lpath);
		lpath = cp2;
	    }
	    if (mb_errno != 0) {
		user_error(BAD_LPATH, 0);
	    }
	}
	def_dir_list_add(lpath);
	def_dir_list_add(NULL);
    } else if (cp = getenv("ST_LIBH")) {
        /* 
	** make a copy and only change that, so future invocations (by ucomp)
	** will see the same thing we saw this time 
	*/
	default_lib_dir1 = (char *) emalloc(strlen(cp) + 1);
	strcpy(default_lib_dir1, cp);
	cp = default_lib_dir1;
	if (cp = (MB_CUR_MAX == 1) ? strchr(cp,':') : mb_strchr(cp,':')) {
            *cp++ = 0;
            default_lib_dir2 = cp;
#ifdef V4FS_NOT_MORE
	    /*   Now look for third directory */
	    if (cp = (MB_CUR_MAX == 1) ? strchr(cp,':') : mb_strchr(cp,':')) {
            	*cp++ = NULL;
            	default_lib_dir3 = cp;
	    	/* throw out anything after the third colon */
	    	if (cp = (MB_CUR_MAX == 1) ? strchr(cp,':') 
		    : mb_strchr(cp,':'))
	            *cp = NULL;
	    } else {
            	default_lib_dir3 = NULL;
	    }
#else /* V4FS */
	    /* throw out anything after the second colon */
	    if (cp = (MB_CUR_MAX == 1) ? strchr(cp,':') : mb_strchr(cp,':'))
	        *cp = 0;
#endif /* V4FS */
        } else {
            default_lib_dir2 = NULL;
#ifdef V4FS_NO_MORE
            default_lib_dir3 = NULL;
#endif /* V4FS */
	}

	/*
	** strip off trailing /lib from default dir names so we have cleaner
	** logic in the library searching (-l) code.
	*/
	if (default_lib_dir1 &&
	    (cp = (MB_CUR_MAX == 1)
	     ? strrstr(default_lib_dir1, "/lib")
	     : mb_strrstr(default_lib_dir1, "/lib"))) {
	    *cp = '\0';
	}
	if (default_lib_dir2 &&
	    (cp = (MB_CUR_MAX == 1)
	     ? strrstr(default_lib_dir2, "/lib")
	     : mb_strrstr(default_lib_dir2, "/lib"))) {
	    *cp = '\0';
	}
#if V4FS_NO_MORE
	if (default_lib_dir3 &&
	    (cp = (MB_CUR_MAX == 1)
	     ? strrstr(default_lib_dir3, "/lib")
	     : mb_strrstr(default_lib_dir3, "/lib"))) {
	    *cp = '\0';
	}
#endif /* V4FS_NO_MORE */
    }

    /* 
    ** Initialize all data structures here so if a command file is seen 
    ** We can add structures to our hearts content 
    */
    initialize();

    /*
    ** save new argc and argv (modified by env_get_args()) to echo command 
    ** line.
    ** process_cmd_line_args() munges argv so we 
    ** must copy the argv strings instead of just saving the address of
    ** it (i.e. nargv = argv);  After process_cmd_line_args(), nargv was
    ** munged and the second path of +cdp path:path was dropped.  
    */
    nargc = argc;
    nargv = (char **) emalloc ((nargc +1) * sizeof (char *));

    for (s_index=0; s_index < nargc; s_index++) {
        nargv[s_index] = (char *) emalloc (strlen(argv[s_index]) + 1);
        strcpy (nargv[s_index], argv[s_index]);
    }
    nargv[nargc] = NULL;

    /* This affects the existing argc and argv variables */
    process_cmd_line_args();

    /* 
    ** show command line after options read since -L determines lib search 
    ** path 
    */

    if (verbose & V_WHY)
        show_command_line(nargc, nargv);

    finish_options();

    /* Now that we have the application name, save the base for FDP */
    /* This name is needed to write to the flow.data file */

    /* if user did not specify the output name with +pgm */
    if ((do_fdp_position || do_fdp_measure) && (!fdp_output_name)) {
       /*fdp_output_name = emalloc(strlen(output_name));*/
        if ((fdp_output_name = (MB_CUR_MAX == 1) 
		 		       ? strrchr(output_name,'/')
		 		       : mb_strrchr(output_name,'/')) != NULL)
       /* There is a fully qualified path, get the name after the last '/' */
            fdp_output_name++;
        else 
            fdp_output_name = output_name;
    }
    if ((do_fdp_position && !fdp_link_order_supplied) || do_fdp_measure) {
        /* Check for environment variable specifying path to data file, etc */
        set_fdp_file_names();
    }

    if (!relocatable) { /* not FRU */
	archive_linear_search = FALSE;
	archive_noloop_search = FALSE;
        if (cp = getenv("ST_LIBMILLI"))  /* override default milli.a */
	    som_list_add(cp, SEARCH_LIB, FALSE);
#ifdef V4FS
	else som_list_add("/usr/lib/milli.a", SEARCH_LIB, FALSE);
#else /* V4FS */
	else som_list_add("/lib/milli.a", SEARCH_LIB, FALSE);
#endif /* V4FS */
    }

    som_list_add(NULL, FORCE_LOAD, FALSE);

    if (trace_list) trace_list_add(NULL);
    if (undef_list) undef_list_add(NULL);
    if (dir_list) dir_list_add(NULL);
    if (subprog_list) subprog_list_add(NULL);
    if (forget_list) forget_list_add(NULL);
    if (promotion_list) promotion_list_add(NULL);
    if (absolute_list) absolute_list_add(NULL);
#ifndef NO_MULTIPLE_INITIALIZERS
    if (initializer_list) initializer_list_add(NULL);
#endif /* !NO_MULTIPLE_INITIALIZERS */
    /* pass a parameter, even though only used for FRU relink */
    status = linker(0);
    cleanup(status);

#ifdef OBS_FEATURES_WARN

    /*
    ** If some change warnings were found and the details of these warnings
    ** were not printed, show a generic change warning message.
    */

    if ((verbose & V_CHANGE_WARN) &&
        (found_change_warn) &&
        (!(verbose & V_DETAIL_CHANGE_WARN))) {

      warning( GENERIC_CHANGE_WARNING, 0 );

    }

#endif

    /*
    ** Remove #ifdef PBO for the -Fu, -Fs code since
    ** we can use this in a non PBO environment.
    */
	/* Revamped the implementation for these
	** options. */

    if (list_unsats_only || trace_syms_only) {  /* close the files and exit */
	int index;
	FILE *fp;

	for (index = 0; index < FU_NUM_ENTRIES; index++) {
	    if (fp = unsat_files [index]) {
		if (fp == stdout)
		    fflush (fp);
		else
		    fclose (fp);
	    }
	}

	for (index = 0; index < FS_NUM_ENTRIES; index++) {
	    if (fp = trace_sym_files [index]) {
		if (fp == stdout)
		    fflush (fp);
		else
		    fclose (fp);
	    }
	}
	/* generate a unique exit code if the error was due to unsat only */ 
        if (unsat_found)
            exit (99);
        else
            exit (status);
    } else if (isom_exist)
       backend_driver();

#ifdef INSTRUMENT_MALLOC
    dump_sites();
#endif /* INSTRUMENT_MALLOC */

    if (verbose & V_MALLOC) {
	int free_sym_count = 0;
	struct symbol_record *free_list_ptr = free_syms;

        printf(ld_gets(1, 
		       1119, 
		       "Total data space malloc'ed = %d\n"),
	       (int)sbrk(0)-init_cur_brk);
	
#ifdef DEBUG
	/* 
	** Put this under DEBUG tags.  I don't think we want customers 
	** to know how much memory we waste! :-) 
	** 
	** Print how much space is wasted on the free sym_record chain. 
	*/
	while (free_list_ptr != NULL) {
	    free_sym_count++;
	    free_list_ptr=(struct symbol_record *)free_list_ptr->misc.back_ptr;
	}
	printf(ld_gets(1, 
		       1120, 
		       "Total memory of free_syms list is %d\n"),
	       free_sym_count*sizeof(struct symbol_record));
#endif /* DEBUG */
    }

    if (status == 0 && is_fastbind) {
       /* Invoke fastbind if there are no errors and "+fb" is specified */

       status = invoke_fastbind();
    }

    if (status == 0 && !relocatable && base_file_name == NULL && 
#ifdef ESOM
	!esom_object &&
#endif /* ESOM */

#ifdef CNX_TOOLS
        (!generate_tools_spaces || force_pxdb) &&
#endif /* CNX_TOOLS */

	!strip_debug) {
	invoke_pxdb();
    }

#if defined(DEBUG) || defined(PFA)	/* if module-test active */
    purge_string_table(&sym_strings);
    purge_string_table(&tmp_strings);
    purge_string_table(&space_strings);
#endif /* module-test active */

    efree( nargv);
    efree( save_argv);

    exit (status);
    /*NOTREACHED*/
    return 0;
} /* end driver */

void catchint()
{
    unlink(output_name);
    longjmp(drive, 1);
}

void process_cmd_line_args()
{
    char *cp;
    Boolean is_past_opts;
    int s_index;
    int stop_search;

    is_past_opts = FALSE;

    /*
    **
    ** Check if -noshared is anywhere on the command line and
    ** instruct the linker to use archived libraries only.
    */
    stop_search = FALSE;
    for (s_index = 1; (s_index < argc) && (!stop_search) ; s_index++) {
	cp = argv[s_index];
	if (cp[0] == '-') {
	    if (!is_past_opts) {
		if (cp[1] == '-') {
		    stop_search = TRUE;
		} else if (strcmp("-noshared", cp) == 0) {
		    stop_search = TRUE;
		    library_search = ARCHIVE_LIB_ENABLED;
		}
	    }
	}
    }

    while (--argc > 0) {
        cp = *++argv;
	if (! is_past_opts && (*cp == '-' || *cp == '+')) {
	    if (*cp == '-') {
	      if ( *(cp + 1) == '-' && *(cp + 2) == '\0') {
		  is_past_opts = TRUE; 	/* "--" marks the end of options */
	      } else
		  do_option_minus(++cp);
	    } else {
		do_option_plus(++cp);
	    }
	} else {
            som_list_add(cp, SEARCH_LIB, FALSE);
	}  /* end else */
    }
} /* end process_cmd_line_args */

void do_option_minus(cp)
char *cp;
{

    /* 
    ** do all options that begin with a '-' as opposed to those options
    ** that begin with a '+' 
    */

    int Zopt, junk;
    FILE *f;                  /* temp file ptr */
    char *junkcp, *orig_cp;

    orig_cp = cp;
    while (*cp != '\0') {
	switch (*cp++) {

	    /* TWG core options */

	    case 'a':		/* select shared libs/archives.  Force
                                   users to type in full parm name */
		set_str_parm(&junkcp, cp);
                if (!strcmp(junkcp,"shared"))       /* Only Shlibs Allowed   */
                   library_search = SHARED_LIB_ENABLED; 
                else if (!strcmp(junkcp,"archive")) /* Only Archives Allowed */
                   library_search = ARCHIVE_LIB_ENABLED;
                else if (!strcmp(junkcp,"default")) /* 1st .sl, then .a      */
                   library_search = DEFAULT_LIB_SEARCH;
		   /* 1st .a then .sl */
                else if (!strcmp(junkcp,"archive_shared")) 
                   library_search = SHARED_LIB_ENABLED | ARCHIVE_LIB_ENABLED;
		   /* 1st .sl then .a */
                else if (!strcmp(junkcp,"shared_archive")) 
                   library_search = DEFAULT_LIB_SEARCH;
                else
                   warning(BAD_KEYWORD_ARG, *argv, --orig_cp, 0);
		return;
	    case 'b':		/* building a shared library */
		building_shlib = TRUE;
		building_incomp_exec = FALSE;
		alloc_stubs_ux = TRUE;
		gen_ldr_fixups = TRUE;
		extern_plabels = TRUE;
		break;
	    /*
	    ** commands in file - supposedly the OSF form thereof.  Same code
	    ** as -FF
	    */
	    case 'c':	
		set_str_parm(&junkcp, cp);
		fil_get_args(junkcp);
		return;
	    case 'd':		/* allocate common */

		/*
		**
		** If the option is -dynamic, the user wants to create
		** a dynamically bound executable.  Do nothing.
		*/
		if ((strcmp(cp, "ynamic") == 0) && (cp == (orig_cp + 1))) {
		    allow_link_with_shlibs = TRUE;
		    return;
		}
		/*
		** The rest is for the -d option.
		*/

		force_common = TRUE;
		break;
	    case 'e':		/* define entry point */
		set_str_parm(&entry_name, cp);
		return;
	    case 'f':		/* fill pattern */
		warning(UNSUPPORTED_ARG, *argv, 0);
		set_num_parm(&junk, cp, "%x");
		return;
	    case 'h':		/* hide symbol */
		set_str_parm(&junkcp, cp);
		hide_list_add(junkcp);
		return;
	    case 'k':		/* linker command file */
		set_str_parm(&junkcp, cp);
		process_command_file(AS_A_FILE, junkcp);
		command_file_seen = TRUE;
		return;
	    case 'l':		/* search library */
		expand_dash_l(cp, TRUE);
		return;
	    case 'm':		/* load map */
		map = TRUE;
		break;
	    case 'n':		/* sharable output */

		/*
		** If the option is -noshared, the user wants to create
		** a statically bound executable.  Act like -aarchive.
		*/
		if ((strcmp(cp, "oshared") == 0) && (cp == (orig_cp + 1))) {
		    allow_link_with_shlibs = FALSE;
		    library_search = ARCHIVE_LIB_ENABLED;
		    return;
		}
		/*
		** The rest is for the -n option.
		*/

		sharable = TRUE;
		break;
	    case 'o':		/* set output file name */
		set_str_parm(&output_name, cp);
		return;
	    case 'q':		/* demand-loadable output */
		demand_load = TRUE;
		break;
	    case 'r':		/* relocatable output file */
		relocatable = TRUE;
		break;
	    case 's':		/* strip symbols and debug info */
		strip_symbols = TRUE;
		strip_debug = TRUE;
		/* doom support */
		lm_options_strip_s();
		break;
	    case 't':		/* trace som ... */
		trace_som = TRUE;
		break;
	    case 'u':		/* enter undefined symbol */
		set_str_parm(&junkcp, cp);
		undef_list_add(junkcp);
		return;
	    case 'v':		/* verbose */
		verbose = V_WHY |
                          V_SOFT_UNSATS |
                          (verbose & V_CHANGE_WARN) |
                          (verbose & V_DETAIL_CHANGE_WARN);
		return;
	    case 'x':		/* strip local symbols */
		strip_local_symbols = TRUE;
		break;
	    case 'z':		/* no nil pointers */
		trap_nil_ptrs = TRUE;
		break;
	    case 'A':           /* dynamic loading base file */
#ifdef OBS_FEATURES_WARN
		/*************************************************************/
		/* Warning: -A will be obsoleted                             */
		/* -------                                                   */
		/*************************************************************/
                emit_dash_A_warn = TRUE;
#endif
		set_str_parm(&base_file_name, cp);
                dash_A = TRUE;
		return;
	    /*
	    ** select immediate/deferred binding to shared libraries */
	    case 'B':	
		set_str_parm(&junkcp, cp);
                if ((!strcmp(junkcp,"Symbolic")) ||
                    (!strcmp(junkcp,"symbolic")) ||
                    (!strcmp(junkcp,"SYMBOLIC"))) {
                    inter_binding = TRUE;
                }
                else if (!strcmp(junkcp,"deferred")) {  /* deferred binding */
                    bind_mode |= BIND_DEFERRED;
		    /* implies not immediate, clear "immediate" bit */
                    bind_mode &= (~BIND_IMMEDIATE); 
		} else if (!strcmp(junkcp,"immediate")) { 
		    /* immediate binding */
                    bind_mode |= BIND_IMMEDIATE;
                     /* implies not deferred, clear "deferred" bit */
                    bind_mode &= (~BIND_DEFERRED); 
     	        } else if (!strcmp(junkcp,"nonfatal")) { 
		    /* nonfatal modifier */
                    bind_mode |= BIND_NONFATAL;
		} else if (!strcmp(junkcp,"restricted")) { 
		    /* restricted binding*/
                    bind_mode |= BIND_RESTRICTED;
       	        } else if (!strcmp(junkcp,"verbose")) { /* verbose modifier */
                    /* 
		    **  Now can specify "verbose"
                    ** to modify diagnostics with "immediate nonfatal" 
		    */
                    bind_mode |= BIND_VERBOSE;
                } else
		   warning(BAD_KEYWORD_ARG, *argv, --orig_cp, 0);
		return;
	    case 'E':		/* incomp a.out 'full' export */
		search_alldefs = TRUE; /* search all defs for exports */
		break;
	    case 'K':		/* interpret string as a command file */
		set_str_parm(&junkcp, cp);
		process_command_file(AS_A_STRING, junkcp);
		return;
	    case 'L':		/* set library search path */
		set_str_parm(&junkcp, cp);
		dir_list_add(junkcp);
		return;
	    case 'N':		/* non-sharable text */
		sharable = FALSE;
		break;
	    case 'Q':		/* not demand loadable */
		demand_load = FALSE;
		break;
	    case 'R':		/* set text origin */
		Rflag = TRUE;
		set_num_parm(&code_mmap_addr, cp, "%x");
		code_offset = code_mmap_addr;
	        do_text_unpadding = FALSE;
		return;
	    case 'V':		/* version stamp */
		if (*cp == 'S') {
		    warning(UNSUPPORTED_ARG, *argv, 0);
		    cp++;
		    set_num_parm(&junk, cp, "%x");
		} else {
		   /*  version info will be printed by the
                    * dual path driver 
                    */
		    /* This is the same code as for -FV */
#ifndef ROSEVILLE
		    printf("%s: %s\n", progname, PRODUCT_ID+4); 
#endif
		}
		return;
	    case 'X':		/* symbol table size */
		/* 
		** This used to set the initial symbol table size, but with
		** the HP-UX 10.0 symbol table rewrite, this option is now
		** useless.  Recognize it and do nothing! 
		*/
		set_num_parm(&junk, cp, "%d");
		return;
	    case 'Z':		/* allow nil pointers */
		trap_nil_ptrs = FALSE;
		break;

	    /* s800-only options */

	    case 'y':		/* trace symbol */
		set_str_parm(&junkcp, cp);
		trace_list_add(junkcp);
		return;
	    case 'C':		/* type checking level */
#ifdef OBS_FEATURES_WARN
		/*************************************************************/
		/* Warning: -C type checking will be obsoleted               */
		/* -------                                                   */
		/*************************************************************/
                emit_dash_C_warn = TRUE;
#endif
		set_num_parm(&parmcheck, cp, "%d");
		return;
	    case 'D':		/* set data origin */
#ifdef ESOM
		Dflag = TRUE;
#endif /* ESOM */
		set_num_parm(&data_mmap_addr, cp, "%x");
		data_offset = data_mmap_addr;
		data_origin_set = TRUE;
		do_private_unpadding = FALSE;
		data_on_page_after_text = FALSE;
		return;
	    case 'G':		/* strip unloadable data */
		strip_debug = TRUE;
		/* doom support */
		lm_options_strip_G();
		break;
	    case 'O':		/* link-time code optimization */
	        if (!dont_elim_addils) {    /* if not turned off with -FNO */
		    eliminating_addils = TRUE;/* remove ADDILs near $global$ */
		    sort_stor_reqs = TRUE;  /* sort storage requests by size */
		}
		delete_dead_procs = TRUE;	
		break;
	    case 'S':		/* IPL aux header */
		ipl = TRUE;
		/* default is 'position independent' */
		if (!Rflag) {
			code_mmap_addr = 0;
			code_offset = code_mmap_addr;
		}
		break;
	    case 'T':		/* use temp file */
		save_data = TRUE;
		save_fixups = TRUE;
		two_pass = FALSE;
		break;

	    /*  */
	    /*  is using -HF.  Don't remove support for it.
	    ** .
	    */

	    case 'H':		/* misc HPE flags */
#ifdef OBS_FEATURES_WARN
		/*************************************************************/
		/* Warning: All -H options will be obsoleted                 */
		/* -------                                                   */
		/*************************************************************/
                emit_dash_H_warn = TRUE;
#endif
                /* always disable dead procedure elimination */
                disable_dead_proc = TRUE;
		while (*cp != '\0') {
		    switch (*cp++) {
			/* set HPE defaults */
			case 'D':  O_S = OS_HPE_NEW;
				   alloc_stubs_xl = TRUE;
				   strip_fixups = FALSE;
				   gen_ldr_fixups = TRUE;
				   pri_prog_only = FALSE;
				   hpe_som = FALSE;
				   align_on_if_flag = FALSE;
				   locality_flag = TRUE;
				   mapped = TRUE;
				   extern_plabels = TRUE;
				   no_arg_reloc = FALSE;
				   system_som = FALSE;
                                   force_ext_milli_syms = FALSE;
				   no_stub_unwind = FALSE;
				   no_promotion = FALSE;
				   delay_aux = FALSE;
				   delay_space = TRUE;
				   delay_subsp = FALSE;
				   delay_init = FALSE;
				   delay_ldrfix = FALSE;
				   delay_spstr = TRUE;
				   delay_sym = TRUE;
				   delay_fixup = TRUE;
				   delay_symstr = TRUE;
				   delay_compunit = TRUE;
				   delay_code = TRUE;
                                   page_size = FOUR_KB;
				   dumpworthy = FALSE;
				   reset_secdef_syms = FALSE;
				   break;
			case 'A':  O_S = OS_HPE_NEW; break;
			case 'e':  alloc_stubs_xl = FALSE; break;
			case 'E':  alloc_stubs_xl = TRUE; break;
			case 'c':  reset_secdef_syms = FALSE; break;
			case 'C':  reset_secdef_syms = TRUE; break;
			case 'f':  strip_fixups = TRUE; break;
				   /* is using -HF.  Don't
				   ** remove support for it.  Contact
				   ** .
				   */
			case 'F':  strip_fixups = FALSE; break;
			case 'g':  pri_prog_only = TRUE; break;
			case 'G':  pri_prog_only = FALSE; break;
			case 'h':  hpe_som = TRUE; break;
			case 'H':  hpe_som = FALSE; break;
			case 'i':  align_on_if_flag = FALSE; break;
			case 'I':  align_on_if_flag = TRUE; break;
			case 'j':  thread_private = FALSE; break;
			case 'J':  thread_private = TRUE; break;
			case 'k':  gen_ldr_fixups = FALSE; break;
			case 'K':  gen_ldr_fixups = TRUE; break;
			case 'l':  locality_flag = TRUE; break;
			case 'L':  locality_flag = FALSE; break;
			case 'm':  mapped = FALSE; break;
			case 'M':  mapped = TRUE; break;
                        case 'o':  set_str_parm(&junkcp, cp);
                                   promotion_list_add(junkcp);
                                   break;

			case 'p':  extern_plabels = FALSE; break;
			case 'P':  extern_plabels = TRUE; break;
			case 'q':  relinkable = TRUE; break;
			case 'r':  no_arg_reloc = TRUE; break;
   			case 'R':  no_arg_reloc = FALSE; break;
			case 's':  system_som = TRUE; break;
			case 'S':  system_som = FALSE; break;
		        case 't':  force_ext_milli_syms = TRUE; break;
			case 'u':  O_S = OS_HPUX; 
				   data_mmap_addr = DEFAULT_HPUX_DATA_OFFSET;
				   data_offset = data_mmap_addr;
		                   data_on_page_after_text = 
						 DEFAULT_HPUX_DATA_ROUND;
			           demand_load = DEFAULT_HPUX_DEMAND_LOAD;
				   break;
			case 'w':  no_stub_unwind = TRUE; break;
			case 'W':  no_stub_unwind = FALSE; break;
			case 'x':  no_promotion = TRUE; break;
			case 'X':  no_promotion = FALSE; break;
			case 'y':  dumpworthy = TRUE; break;
			case 'Y':  dumpworthy = FALSE; break;
			case 'Z':
			    set_num_parm(&Zopt, cp, "%d");
			    switch (Zopt) {
				case 1:  delay_aux = TRUE; break;
				case 2:  delay_space = TRUE; break;
				case 3:  delay_subsp = TRUE; break;
				case 4:  delay_init = TRUE; break;
				case 5:  delay_ldrfix = TRUE; break;
				case 6:  delay_spstr = TRUE; break;
				case 7:  delay_sym = TRUE; break;
				case 8:  delay_fixup = TRUE; break;
				case 9:  delay_symstr = TRUE; break;
				case 10: delay_compunit = TRUE; break;
				case 11: delay_code = TRUE; break;
                                default: user_error(BAD_NUM_ARG, *argv, 0);
                                         break;
			    }
			    return;
			case 'z':
			    set_num_parm(&Zopt, cp, "%d");
			    switch (Zopt) {
				case 1:  delay_aux = FALSE; break;
				case 2:  delay_space = FALSE; break;
				case 3:  delay_subsp = FALSE; break;
				case 4:  delay_init = FALSE; break;
				case 5:  delay_ldrfix = FALSE; break;
				case 6:  delay_spstr = FALSE; break;
				case 7:  delay_sym = FALSE; break;
				case 8:  delay_fixup = FALSE; break;
				case 9:  delay_symstr = FALSE; break;
				case 10: delay_compunit = FALSE; break;
				case 11: delay_code = FALSE; break;
                                default: user_error(BAD_NUM_ARG, *argv, 0);
                                         break;
			    }
			    return;
			default:   warning(BAD_FLAG, *argv, 0);
				   usage();
    		    }
		}
		return;
      case 'I':   /* count calls */
                  count_calls = TRUE;
                  do_fdp_measure  = TRUE;
#ifdef COUNT_LONG_BRANCHES
                  count_long_branches = FALSE;
#endif
                  return;

      case 'P':
                /* read subsp data on 2nd pass */
                two_pass = TRUE;
                save_data =  FALSE;
                do_fdp_position = TRUE;
		do_procedure_fdp = TRUE;

#ifdef INTERNALOPTIONS
                if (*cp != '\0') {
                   switch (*cp) {
                   case 'b':
		      /* Suppress procedure level FDP. */
                      do_procedure_fdp = FALSE;
		      break;
                   case 'p':
		      /* Suppress basic block level FDP. */
                      do_fdp_position = FALSE;
		      break;
		   case 'd':
		      /* Allow positioning of debuggable functions. */
		      do_dbg_fdp = TRUE;
		      break;
		   case 'V':
		      /* Internal fdp debugging option */
		      fdp_verbose = TRUE;
                      break;
	           case 'D':
                      /* 
		      ** This option leaves the link order in the user
                      ** specified file
                      */
                      fdp_delete_link_order = FALSE;
                      set_str_parm(&fdp_link_order_file_name, ++cp);
                      break;
 		   case 'F':
                      /* 
		      **Internal fdp debugging option, this is primarily
                      ** used to test that the linker is really ordering
                      ** the files in the order that was given by fdp. If
                      ** we don't have a test like this, one can't count on
                      ** the fact that files will be linked in increasing or
                      ** decreasing order.
                      */
                      fdp_link_order_supplied = TRUE;
                      fdp_delete_link_order = FALSE;
                      set_str_parm(&fdp_link_order_file_name, ++cp);
                      fdp_link_order_file = 
                         efopen(fdp_link_order_file_name, "r", CANT_OPEN);
                      break;
		    default:   warning(BAD_FLAG, *argv, 0);
                                   usage();
		 }
	     }
#endif /* INTERNALOPTIONS */
                 return;

#ifdef INTERNALOPTIONS
	    case 'F':		/* misc subflags */
#ifdef OBS_FEATURES_WARN
		/*************************************************************/
		/* Warning: All -F options will be obsoleted                 */
		/* -------                                                   */
		/*************************************************************/
                emit_dash_F_warn = TRUE;
#endif
		switch (*cp++) {
		    case 'a': 
			while (*cp != '\0') {
			    switch (*cp++) {
				case 's': 
			            /* 
				    ** add absolute symbol,   
				    ** "symbol_name=value" no spaces allowed.
			 	    **  Value is in hex.      
				    */
				    set_str_parm(&junkcp, cp);
				    absolute_list_add(junkcp);
				    return;
				default:  warning(BAD_FLAG, *argv , 0);
					  usage();
			    }
			}
			return;
#ifdef WW_ANNOTATIONS
		    case 'A':
			annotations_killed_at_startup=TRUE;
			do_ww_annotations = FALSE;
			return;
#endif /* WW_ANNOTATIONS */
                    case 'b':   /* specify the stand-alone ucode process */
                        set_str_parm(&backend_process,cp);
                        return;

                    /* NO_DATA_COPY */
                    case 'c':   /* Provide data copying */
			do_data_copy = TRUE;
			return;
		    case 'C':	
			/* 
			** turn on COBOL allow-code-unsats option that
			** leaves the a.out executable anyway 
			*/
			allow_code_unsats = TRUE;
			return;
		    case 'D':   
		        /* read subsp data on 2nd pass */
			two_pass = TRUE;
			save_data =  FALSE;
			return;
		    case 'd':	/* turn off two-pass option */
			two_pass = FALSE;
			return;
		    case 'e':	/* bypass export stubs in shlib on (default) */
		        bypass_export_stubs = TRUE;
			return;
		    case 'E':	/* bypass export stubs in shlib off */
		        bypass_export_stubs = FALSE;
			return;
		    case 'F':	/* commands in file */
			set_str_parm(&junkcp, cp);
			/* Get args till end of file */
			fil_get_args(junkcp);
			return;
		    case 'I':	/* initialization */
			init_parm(cp);
			return;
		    case 'l':	/* force load a library */
			set_str_parm(&junkcp, cp);
			som_list_add(junkcp, FORCE_LOAD, FALSE);
			return;
                    case 'k':  /* keep the internal compiled files for
                                  debugging */
                        keep_compiled_isoms = TRUE;
                        return;
                    case 'L':   /* count dynamic long branches */
#ifdef COUNT_LONG_BRANCHES
                        count_long_branches = TRUE;
#endif
                        count_calls = FALSE;
                        return;
#if defined(DEBUG) || defined(PFA)	/* if module-test active */
		    case 'M':   /* module test code */
			module_test = TRUE;
                        return;
#endif /* DEBUG || PFA */
		    case 'N':   /* turn options off */
			while (*cp != '\0') {
			    switch (*cp++) {
				case 'O': dont_elim_addils = TRUE; 
					  eliminating_addils = FALSE;
					  sort_stor_reqs = FALSE;
					  break;
				case 'o': sort_stor_reqs = FALSE; 
					  /* leave on ADDIL elim for test */
					  break;
				default:  warning(BAD_FLAG, *argv , 0);
					  usage();
				}
			    }
			return;
		    case 'P':   /* Set long branch pad predict value */
			set_num_parm(&lb_reach_pad, cp, "%d");
			return;
		    case 'p':
			set_num_parm(&Zopt, cp, "%d");
			if (Zopt <= 0) 
                            user_error(BAD_NUM_ARG, *argv, 0);
			page_size = Zopt * TWO_KB;
			break;
		    case 'Q':	/* hash on qualifiers */
			hash_qual = TRUE;
			return;
		    case 'S':   /* Set number of bytes for dld to zero  */
			set_num_parm(&clean_stack_size, cp, "%d");
			if (clean_stack_size < 0) 
                            user_error(BAD_NUM_ARG, *argv, 0);
			/* 
			** stack pointer must be double-word aligned, so round
			** up to an 8-byte boundary.  If the required alignment
			** changes in the future, so must this code. 
			*/
			clean_stack_size = round(clean_stack_size, DBLWORD);
			return;
                    /* 
                    ** -Fs options since we can use these outside the PBO
                    ** environment.
                    **  Added -Fss option to print sizes
                    ** for storage requests from shared libraries.
                    */

                    case 's':
                        /* =================================================
                           Internal pre-link option: -Fs, -Fsn, -Fse and -Fsr
			   the link will stop after symbol resolution and no
			   output file is generated. Output format is similar
			   to "nm -p".  Each symbol name is preceded by its 
			   value and type.
                             -Fs "filename" - Write to filename all the 
				 symbols seen in the link. include object
				 file names.
                             -Fsn "filename" - Write to filename all the 
				 symbols seen in the link. suppress object
				 file names.
                             -Fse "filename" - Write to filename all the 
				 externally visible symbols seen in the 
				 link. suppress object file names.
                             -Fss "filename" - Write to filename all the
                                 externally visible symbols seen in the link.
                                 Suppress object file names.  This is 
                                 identical to -Fse EXCEPT storage requests
                                 from shared libraries will have their 
                                 sizes print out instead of value.
			     -Fsr "filename" - Write to filename all the
				 resolved symbols seen in the link.
				 suppress object file names.
                           =================================================*/
			/*   Revamped the
			** implementation of these options. */

                        trace_syms_only = TRUE;

                        if (*cp != '\0') {
                            switch (*cp++) {
                                case 'e':
				    junk = FS_TRACE_EXPORTS;
                                    break;
                                case 'n':
				    junk = FS_TRACE_NO_FNAME;
                                    break;
                                case 'r':
				    junk = FS_TRACE_RESOLVES;
                                    break;
                                case 's':
				    junk = FS_TRACE_EXPORTS_STOR;
                                    break;
                                default : 
                                    warning (BAD_FLAG, *argv, 0);
                                    usage();
                             }
                        } else {
			    junk = FS_TRACE_ALL;
                        }
                        set_str_parm (&junkcp, cp);
                        trace_sym_files [junk] =
					stdoutfopen (junkcp, "w", CANT_OPEN);
                        return;

                    case 'T':
                        /* 
			** Internal option to indicate that this link was 
                        ** invoked after the isoms have been compiled into
                        ** object code 
			*/ 
                        ld_after_be_process = TRUE;
                        set_str_parm (&process_id, cp); /* get process id */
                        return;

                    case 'u':
                        /* =================================================
                           Internal pre-link option: -Fu, the link will stop 
                           after symbol resolution and no output file is 
                           generated. This option prints out a list of unsat
                           symbol names preceded with 'T' if text and 'D' if 
                           data.  
                           =================================================*/
			/*   Revamped the
			** implementation of these options. */

                        list_unsats_only = TRUE;

                        if (*cp != '\0') {
                            switch (*cp++) {
                                case 't': 
				    junk = FU_TEXT_UNSAT;
                                    break;
                                case 'd': 
				    junk = FU_DATA_UNSAT;
                                    break;
                                default : 
                                    warning (BAD_FLAG, *argv, 0);
                                    usage();
                             }
                        } else {
			    junk = FU_ALL_UNSAT;
                        }
                        set_str_parm (&junkcp, cp);
                        unsat_files [junk] =
					stdoutfopen (junkcp, "w", CANT_OPEN);
                        return;

		    case 'v':	/* verbose */
                        if (*cp == '\0')
                            verbose = (V_STUBS |
                                       V_TIMES |
                                       (verbose & V_CHANGE_WARN) |
                                       (verbose & V_DETAIL_CHANGE_WARN));
			while (*cp != '\0') {
			    switch (*cp++) {
				case '0': verbose = 0; break;
				case 'a': verbose = V_ALL; break;
#ifdef WW_ANNOTATIONS
				case 'A': verbose |= V_WW_ANNOTATIONS; break;
#endif /* WW_ANNOTATIONS */
				/* NO_DATA_COPY */
				case 'c': verbose |= V_NO_DATA_COPY; break;
				case 'e': verbose |= V_EMBED; break;
                                case 'p': verbose |= V_PBO; break; 
				case 'u': verbose |= V_STUBS; break;
				case 't': verbose |= V_TIMES; break;
#ifdef TSD /* TSD */
				case 'T': verbose |= V_TSD; break;
#endif /* TSD */
				case 'm': verbose |= V_MALLOC; break;
				case 's': verbose |= V_STATS; break;
				case 'S': verbose |= V_ALLSTATS; break;
				case 'd': verbose |= V_DEBUG; break;
				case 'D': verbose |= V_BIGDEBUG; break;
				case 'y': verbose |= (V_WHY | V_SOFT_UNSATS); 
					  break;
				case 'O': verbose |= V_OPT; break;
				case 'P': verbose |= V_OPT1; break;
				case 'C': verbose |= V_COMMONS; break;
                                case 'q': verbose |= V_DOOM; break;
				default:  warning(BAD_FLAG, *argv , 0);
					  usage();
			    }
			}
			return;
		    case 'V':	/* print version number */
			/*  version info will be printed by the
			 * dual path driver 
			 */
#ifndef ROSEVILLE
			printf("%s: %s\n",progname, PRODUCT_ID+4); 
#endif
			exit(0);
		    case 'w':   /* don't emit unwind tables */
			suppress_unwind = TRUE;  /* */
			break;

		    case 'X':   /* subprogram elimination */
			set_str_parm(&junkcp, cp);
			subprog_list_add(junkcp);
			break;
		    case 'x':   /* "external" subprogram elimination */
			set_str_parm(&junkcp, cp);
			forget_list_add(junkcp);
			break;
		    case 'z':   /*  */
			dyncall_external_off = TRUE;
			break;
		    default:
			warning(BAD_FLAG, *argv , 0);
			usage();
    		}
		break;
#endif /* INTERNALOPTIONS */

	    default:
		warning(BAD_FLAG, *argv , 0);
		usage();
	}
    }
} /* end do_option_minus */

void do_option_plus(cp)
char *cp;
{
    int val;

    /* 
    ** do all options that begin with a '+' as opposed to those options
    ** that begin with a '-' 

       It appears that we are breaking away from '-' behavior that does
       not allow multi-letter options. 

       This implies 
       1) users are not able to combine options under a single '+' symbol. 
       2) each option must have a unique prefix so that it can be parsed. 
       3) white-space between an option and the argument can not be 
	  relied on (this is because the compiler drivers actually 
	  require that no white-space be present, causes conflict
	  for shared compiler/linker options)

	  There seems to be two ways to parse multi-character options 
	  that may or may not have white-space between themselves 
	  and the argument. 

	  1) determine a specific length for each starting option letter.
	     For example, you could say that all +G options be a total
	     of 3 characters long. Once you see the +G, you know that
	     the next two characters are part of the option specification.

	  2) study the possible argument strings to know what values 
	     they could take. Allow subsets of multi-character options
	     to exist if they do not take arguments or if their arguments
	     could be distinguished from the longer option. 

	     For example, you could have the option +pgm. You could allow
	     the option +pg to exist if it did not take an argument or 
	     if the +pg option together with it's argument would not 
	     be mistaken for the longer +pgm option. 

	  Both stratagies can be used at the same time for different
	  options.
	    
    */

    char *junkcp;
    char savecp;
    int enable;
    int Oparm;
    int i;
    extern void usage();
    extern void set_num_parm();

    while (*cp != '\0') {
	switch (*cp++) {

	    /* TWG core options */

	    case 'e':		/* specify symbol to export    */
	    
	        /* +ee option: export the symbol but do not mess up the
		 * default visibility of other symbols 
		 *
		 * +e option: export the symbol and hide everything else 
		 */

	        if (*cp == 'e') {
		    set_str_parm(&junkcp, ++cp);
		    excl_export_list_add(junkcp);
		} else {
		    set_str_parm(&junkcp, cp);
		    shlib_export_list_add(junkcp);
		    search_alldefs = TRUE;   /* search all defs for export */
		}
		return;
	    case 'E':		/* specify elaborator function */
		set_str_parm(&elaborator_name, cp);
                return;
	    case 'I':		/* specify initializer function */
#ifndef NO_MULTIPLE_INITIALIZERS
		set_str_parm(&junkcp, cp);
		initializer_list_add(junkcp);
#endif /* !NO_MULTIPLE_INITIALIZERS */
                return;

	    /* s800-only options */

	    case 'a':		/* Specify archive lib searching algorithms */
		/*
		** +allowunsats is not supported.
		*/
	        if (strcmp(cp,"llowunsats") == 0) {
		    /* +allowunsats */
		    warning (UNSUPPORTED_OPT_PA32, *argv, 0);
		    return;
		}

		set_str_parm(&junkcp, cp);
		if (!strcmp(junkcp,"aegis")) {      /* Only Shlibs Allowed   */
		    archive_noloop_search = TRUE;
		    archive_linear_search = TRUE;
 	        } else if (!strcmp(junkcp,"hpux")) {
		    archive_noloop_search = FALSE;
		    archive_linear_search = FALSE;
		} else if (!strcmp(junkcp,"loop"))
		    archive_noloop_search = FALSE;
		else if (!strcmp(junkcp,"noloop"))
		    archive_noloop_search = TRUE;
		else if (!strcmp(junkcp,"linear"))
		    archive_linear_search = TRUE;
		else if (!strcmp(junkcp,"nonlinear"))
		    archive_linear_search = FALSE;
		else
		    warning(BAD_KEYWORD_ARG, *argv, "+a", 0);
	        return;

	    case 'b':		/* specify embedded path */
		if (!(dl_header_flags & EMBED_PATH_ENABLE)) {
		    dl_header_flags |= EMBED_PATH_ENABLE;
		    set_str_parm(&embedded_path, cp);
		} else /* burn off argument */
		    set_str_parm(&junkcp, cp);
		return;

	    case 'c':
		switch (*cp++) {
		    case 'g': 
		        /* 
			** specify the stand-alone ucode process same
			** functionality as internal -Fb
			*/
		        set_str_parm(&backend_process, cp);
			return;

		    case 'o': 
		        /*
			** Set linker mode to +compat.
			** This is the default for the 32-bit linker so do
			** nothing.
			*/
			if (strcmp(cp, "mpat") == 0) {
			    return;
			} else if (strcmp(cp, "pyobjdebug") == 0) {
			    /* doom support */
			    lm_options_copyobjdebug();
                            return;
                        }
				/* **     +cdp <path1>:<path2> */
		    case 'd':
			if (*cp++ == 'p') {
			    set_str_parm (&junkcp, cp);
			    add_shlib_name_pair (junkcp);
			    return;
			}

			/* vvv Else fall through vvv */
		    }
		warning(BAD_FLAG, *argv, 0);
		usage();

	    case 'd':
		switch (*cp++) {
		    case 'f':
                        /* +df specified, PBO */
                        set_str_parm (&fdp_counter_file_string, cp);
                        specify_flow_data = TRUE;
			return;
                    case 'p':
			/* dead procedure elimination */
			switch (*cp++) { 
			    case 'v':
				verbose |= V_DEAD_PROC;
				return;
			    default:
		                warning(BAD_FLAG, *argv, 0);
		                usage();
			} 
		    default:
		        warning(BAD_FLAG, *argv, 0);
		        usage();
		     }
		

            /* 
            ** Introducing +gst option to turn on the global hash table
            ** mechanism.  By default, this value is 0 (no hash table).
            ** Since we do not know whether we are creating a shared lib
            ** or an executable, we will turn the flag on right now, and
            ** then will turn it off (if necessary), when writing flags out.
            */
            case 'g':   
                if (strncmp(cp, "stsize", 6) == 0) {
                   cp += 6;
                   set_num_parm(&val, cp, "%d");
                   if ((val < 1) || (val > MAXINT))  {
                      user_error(BAD_NUM_ARG, *argv, 0);
                      return;
                   } else {
                      gh_hash_table_size = val;
                      gh_ext_opt_specified = TRUE;
                   }
                } else if (strncmp(cp, "stbuckets", 9) == 0) {
                    cp += 9;
                    set_num_parm(&val, cp, "%d");
                    if ((val < 1) || (val > MAXINT)) { 
                       user_error(BAD_NUM_ARG, *argv, 0);
                       return;
                    } else {
                       gh_hash_buckets_per_entry = val;
                       gh_ext_opt_specified = TRUE;
                    }
                } else if (strncmp(cp, "st", 2) == 0) {
                   cp += 2;
                   dl_header_flags |= GLOBAL_HASH_TABLE;
                } else {
                   warning(BAD_FLAG, *argv, 0);
                   usage();
                }
                return;

            /*
            ** .
            ** Get the shared library internal name when building a
            ** shared library so we can insert it into the library list
            ** of the shared library and into any incomplete executable
            ** that links with it.  If +h was called already, we emit a
	    ** warning message and use the first internal name.
	    ** Let users specify a path if they wish
	    ** Added #ifdef V4_NAMEONLY because this will be compiled for
            ** everthing *except* build_env, which will still strip the path
            ** path out (for now).
	    ** Starbase folks want ld +h to work
            ** the same in the BE as well as the GS.  Removing the #ifdef
            ** V4_NAMEONLY.
            */
            case 'h': 
		if (strcmp(cp, "elp") == 0) {
		   /* +help option */

		   invoke_linker_online_help();
		}
		else if (strcmp(cp, "ideallsymbols") == 0) {
		    /*
		    **
		    ** +hideallsymbols is not supported.
		    */
		    /* +hideallsymbols option */
		    warning (UNSUPPORTED_OPT_PA32, *argv, 0);
		    return;
		}
		else  {
	        /* get shared library internal name */
	        dl_header_flags |= SHLIB_INTERNAL_NAME;
                set_str_parm (&junkcp, cp);
#if 0 /* V4_NAMEONLY 08/18/95 */
		if (shlib_internal_name == NULL) {
		    /* strip path, if specified */
		    if (MB_CUR_MAX == 1)
                        shlib_internal_name = strrchr (junkcp, '/');
                    else
                        shlib_internal_name = 
                              mb_strrchr (junkcp, '/');

                    if (shlib_internal_name == NULL) /* if no path */
		        shlib_internal_name = junkcp;
		    else
		        shlib_internal_name++;  /* skip over slash */
		} else
#endif /* 0 */
                if (shlib_internal_name == NULL) 
                    shlib_internal_name = junkcp;
                else
		    warning (PLUS_H_SEEN_TWICE, shlib_internal_name, 0);
		}
                return;

	    case 'i': /* +interp */
		/*
		** +interp is not supported.
		*/
	        if (strcmp(cp,"nterp") == 0) {
		    /* +interp */
		    warning (UNSUPPORTED_OPT_PA32, *argv, 0);
		    set_str_parm (&junkcp, cp + 5);
		    return;
		} else {
		    warning(BAD_FLAG, *argv, 0);
		    usage();
		}

	    case 'k': /* keep a.out even if errors found */
		keep_aout = FALSE;
		return;

	    case 'l': 
	        if (strcmp(cp, "inkmap") == 0) {
		    /* doom support */
		    lm_options_linkmap();
		    return;
		} else {
		    /* search library */
		    expand_dash_l(cp, FALSE);
		    return;
		}

#ifdef ESOM
	    case 'm': /* min/max options */
		if ( strncmp(cp-1,"min",3) == 0 ) {
		    cp += 2;
		    set_num_parm(&esom_min_cpus, cp, "%d");
		    if ( esom_max_cpus == 0 )
			esom_max_cpus = esom_min_cpus;
		    if ( esom_max_cpus < esom_min_cpus ) {
		    	user_error(BAD_MIN_MAX, *argv, 0);
		    }
		} else if ( strncmp(cp-1, "max",3) == 0 ) {
		    cp += 2;
		    set_num_parm(&esom_max_cpus, cp, "%d");
		    if ( esom_min_cpus == 0 )
			esom_min_cpus = esom_max_cpus;
		    if ( esom_max_cpus < esom_min_cpus ) {
		    	user_error(BAD_MIN_MAX, *argv, 0);
		    }
		} else {
		    warning(BAD_FLAG, *argv, 0);
		    usage();
		}
		esom_object = TRUE;
		esom_is_parallel = TRUE;
		esom_no_parallel = FALSE;

		if ( !Rflag )
		    code_offset = DEFAULT_CODE_OFFSET;
		if ( !Dflag ) {
		    data_offset = DEFAULT_CNX_MPP_DATA_OFFSET;
		    data_on_page_after_text = DEFAULT_CNX_MPP_DATA_ROUND;
		}
		return;
#endif /* ESOM */

	    case 'n':		/* No local search of libraries */

                if (strcmp(cp, "o_dlheader_ext") == 0) {
                   no_dlheader_ext = TRUE;
		   return;
		} 

		/*  Option to disable "smart" bind */

		if (strcmp(cp, "osmartbind") == 0) {
		    smartbind_enabled = FALSE;
		    return;
		}

                /*
                ** +noobjdebug
                */
                if (strcmp(cp,"oobjdebug") == 0) {
		    /* doom support */
		    lm_options_noobjdebug();
                    return;
                }

		if (strcmp(cp, "ocopyobjdebug") == 0) {
		   /* doom support */
		   lm_options_nocopyobjdebug();
		   return;
		}

		if (strcmp(cp, "olinkmap") == 0) {
		   /* doom support */
		   lm_options_nolinkmap();
		   return;
		}

                /*
                ** +nomixedmode
                */
                if (strcmp(cp,"omixedmode") == 0) {
                    /* +nomixedmode */
                    mixed_mode_off = TRUE;
                    return;
                }

		/*
		** +noforceload is not supported.
		*/
	        if (strcmp(cp,"oforceload") == 0) {
		    /* +noforceload */
		    warning (UNSUPPORTED_OPT_PA32, *argv, 0);
		    return;
		}

		/*
		** +noallowunsats is not supported.
		*/
	        if (strcmp(cp,"oallowunsats") == 0) {
		    /* +noallowunsats */
		    warning (UNSUPPORTED_OPT_PA32, *argv, 0);
		    return;
		}

		/*
		** +nodefaultmap is not supported.
		*/
	        if (strcmp(cp,"odefaultmap") == 0) {
		    /* +nodefaultmap */
		    warning (UNSUPPORTED_OPT_PA32, *argv, 0);
		    return;
		}

		/*
		** +noenvvar is not supported.
		*/
	        if (strcmp(cp,"oenvvar") == 0) {
		    /* +noenvvar */
		    warning (UNSUPPORTED_OPT_PA32, *argv, 0);
		    return;
		}

		/*
		** The rest is for the +n option.
		*/

#ifdef ESOM
		if ( strncmp(cp-1, "noparallel", 10 ) == 0 )
		    esom_no_parallel_obj = TRUE;
		else
#endif /* ESOM */ 
		    no_local_search = TRUE;

		return;

#ifdef ESOM
	    case 'o':		/* turn on oversubscription for parallel prg */
		if ( strcmp(cp-1, "over") == 0 ) {
		    esom_object = TRUE;
		    esom_is_parallel = TRUE;
		    esom_is_oversubscribe = TRUE;
		    esom_no_parallel = FALSE;

		    if ( !Rflag )
			code_offset = DEFAULT_CODE_OFFSET;
		    if ( !Dflag ) {
		    	data_offset = DEFAULT_CNX_MPP_DATA_OFFSET;
		    	data_on_page_after_text = DEFAULT_CNX_MPP_DATA_ROUND;
		    }
		} else if ( strcmp(cp-1, "onenode") == 0 ) {
		    /*
		     * build a esom parallel executable that will run only
		     * on one spp hypernode.
		     */
		    esom_object = TRUE;
		    esom_is_parallel = TRUE;
		    esom_onenode = TRUE;
		    esom_no_parallel = FALSE;

		    if ( !Rflag )
			code_offset = DEFAULT_CODE_OFFSET;
		    if ( !Dflag ) {
			data_offset = DEFAULT_CNX_MPP_DATA_OFFSET;
			data_on_page_after_text = DEFAULT_CNX_MPP_DATA_ROUND;
		    }
		} else {
		    warning(BAD_FLAG, *argv, 0);
		    usage();
		}
		return;
#endif /* ESOM */

#ifdef UNPAD_SL
	    /* 
	    ** If +mindisk specified, set the variables to tun on unpadding.
	    */
	    case 'm':
	        if (strcmp(cp,"indisk") == 0) {
		    /* +mindisk */
		    do_unloadable_unpadding = TRUE;
		    do_text_unpadding = TRUE;
		    do_private_unpadding = TRUE;
		    if (Rflag) {
			do_text_unpadding = FALSE;
		    }
		    dl_header_flags |= UNPAD_UNLOADABLE;
		} else {
		    warning(BAD_FLAG, *argv, 0);
		    usage();
		}
                return;
#endif

            case 'p':

#ifdef CNX_TOOLS
                if (strcmp(cp-1, "pxdb") == 0) {
                   cp += 3;
                   force_pxdb = TRUE;
                   return;
                } else
#endif /* CNX_TOOLS */

#ifdef ESOM
		if (strcmp(cp-1, "parallel") == 0 || strcmp(cp-1, "par") == 0){
		    esom_object = TRUE;
		    esom_is_parallel = TRUE;
		    esom_no_parallel = FALSE;

		    if ( !Dflag ) {
		    	data_offset = DEFAULT_CNX_MPP_DATA_OFFSET;
		    	data_on_page_after_text = DEFAULT_CNX_MPP_DATA_ROUND;
		    }
		    return;
		} else
#endif /* ESOM */
		switch (*cp++) {
		    case 'g':
			if (*cp++ == 'm') { 
			    /* +pgm option, PBO */
                            set_str_parm (&fdp_output_name, cp);
                            specify_profile_pgm = TRUE;
			    return;
                            }
                        else {
			    warning(BAD_FLAG, *argv, 0);
			    usage();
			    }
		    /*   New options for setting the
		    ** instruction and data page sizes for PA2.0
		    ** +pi size and +pd size, where size is a string
		    ** appearing in the valid_page_sizes array.
                    ** Previously implemented as +O[id]page=size,
                    ** Changed to match corresponding chatr options. */
		    case 'i':
		    case 'd':
                        savecp = *(cp - 1);
                        set_str_parm (&junkcp, cp);
			for (i = 0;
			     i < sizeof valid_page_sizes /
				 sizeof valid_page_sizes[0];
			     i++) {
			    if (strcmp(junkcp, valid_page_sizes[i].option)
								    == 0) {
				if (savecp == 'i') {
				    inst_page_size =
					valid_page_sizes[i].value;
				} else {
				    data_page_size =
					valid_page_sizes[i].value;
				}
				return;
			    }
			}
			warning(BAD_FLAG, *argv , 0);
			usage();
                    case 'l':
                        if (strcmp(cp, "abel_cache") == 0) {
                            dl_header_flags |= PLABEL_CACHE;
                            gh_ext_opt_specified = TRUE;
                            return;
                        } else {
                            warning(BAD_FLAG, *argv, 0);
                            usage();
                        }
		    default:
                        warning(BAD_FLAG, *argv, 0);
			usage();
		    }

            case 's':
 		if (strcmp(cp, "trictcomdat") == 0) {
		    comdat_strict_semantics = TRUE;
		} else if (strcmp(cp, "td") == 0) {
		   /*
		   ** If the option is +std, the user wants +std mode.
		   ** This mode is not supported in the 32-bit linker so
		   ** give a warning.
		   **
		   ** Also do +stripunwind (same as -Fw)
		   */

		    warning(UNSUPPORTED_STD_MODE_PA32, *argv, 0);
		    return;
		} else if (strcmp(cp, "tripunwind") == 0) {
		    suppress_unwind = TRUE;  /* Dangerous w/ shlibs? */
		    return;
#ifdef ESOM
		} else if ( strcmp(cp-1, "spin") == 0 ) {
		    /*
		     * +spin - set the default cps idle thread to spin wait.
		     */
		    esom_object = TRUE;
		    esom_is_parallel = TRUE;
		    esom_no_parallel = FALSE;
		    esom_spinwait = TRUE;
		    
		    if ( !Dflag ) {
		        data_offset = DEFAULT_CNX_MPP_DATA_OFFSET;
		        data_on_page_after_text = DEFAULT_CNX_MPP_DATA_ROUND;
		    }
		    return;
		} else if ( strncmp(cp-1, "stack", 5) == 0 ) {
		    /*
		     * get main stack memory type
		     */
		    cp += 4;
		    set_str_parm(&junkcp, cp);
		    
		    if ( (esom_stack_type = is_esom_memory(junkcp)) == -1 ) {
			warning(BAD_FLAG, *argv, 0);
			usage();
		    }
		    
		    esom_object = TRUE;
		    return;
#endif /* ESOM */
		} else if (strcmp(cp-1, "symboltablesize") == 0) {
		  set_num_parm(&symbol_table_size, cp, "%d");
		  return;
		} else {
		    /*
		    ** The rest is for the +s option.
		    */
		    
		    /* enable searching of SHLIB_PATH at runtime */
		    if (!(dl_header_flags & SHLIB_PATH_ENABLE)) {
			dl_header_flags |= SHLIB_PATH_ENABLE;
			if (!(dl_header_flags & EMBED_PATH_ENABLE)) 
			  dl_header_flags |= SHLIB_PATH_FIRST;
		    }
		}
		return;

	    case 'v':
		/*
		** +noenvvar is not supported.
		*/
	        if (strcmp(cp,"type") == 0) {
		    /* +vtype */
		    warning (UNSUPPORTED_OPT_PA32, *argv, 0);
		    set_str_parm (&junkcp, cp + 4);
		    return;
		}

		/* +v verbose sub-options:
		**	[no]shlibunsats
		**	[no]compatwarnings
		*/
	        enable = TRUE;

	        /*
		** look for a preceding "no" to determine the value.
		*/
		if (*cp == 'n' && *(cp + 1) == 'o') {
		    enable = FALSE;
		    cp += 2;
		}
		switch (*cp) {
		    case 's':
			if (strncmp(cp,"shlibunsats",11) == 0) {
	        	    if (enable) {
				verbose |= V_SOFT_UNSATS;
                            } else {
				verbose &= (~V_SOFT_UNSATS);
			    }
			} else {
                            warning(BAD_FLAG, *argv, 0);
                            usage();  /* usage does not return */
			}
			break;

		    case 'c':
			if (strcmp(cp,"compatwarnings") == 0) {
	        	    if (enable) {
				verbose |= V_CHANGE_WARN;
                            } else {
				verbose &= (~V_CHANGE_WARN);
			    }
			} else {
                            warning(BAD_FLAG, *argv, 0);
                            usage();  /* usage does not return */
			}
			break;

		    case 'a':
			if (strcmp(cp,"allcompatwarnings") == 0) {
	        	    if (enable) {
				verbose |= V_DETAIL_CHANGE_WARN;
                            } else {
				verbose &= (~V_DETAIL_CHANGE_WARN);
			    }
			} else {
                            warning(BAD_FLAG, *argv, 0);
                            usage();  /* usage does not return */
			}
			break;

		    default:
                        warning(BAD_FLAG, *argv , 0);
                        usage();  /* usage does not return */
		}
		return;

#ifdef ESOM
	    case 't': /* object format type */
		if ( strncmp(cp-1, "tnode",5) == 0 ) {
		    cp += 4;
		    set_num_parm(&esom_max_thr_node, cp, "%d");
		    if ( esom_max_thr_node < 1 ) {
		    	user_error(BAD_MIN_MAX, *argv, 0);
			}
		    esom_object = TRUE;
		    esom_is_parallel = TRUE;
		    esom_no_parallel = FALSE;

		    if ( !Rflag )
		    	code_offset = DEFAULT_CODE_OFFSET;
		    if ( !Dflag ) {
		    	data_offset = DEFAULT_CNX_MPP_DATA_OFFSET;
		    	data_on_page_after_text = DEFAULT_CNX_MPP_DATA_ROUND;
		    }
		    return;
		    }
		else if ( strncmp(cp-1, "tstack", 6) == 0 ) {
		    /*
		     * get thread stack memory type
		     */
		    cp += 5;
		    set_str_parm(&junkcp, cp);
		    if ( (esom_tstack_type = is_esom_memory(junkcp)) == -1 ) {
                        warning(BAD_FLAG, *argv, 0);
			usage();
		    }

		    esom_object = TRUE;
		    return;
		}

#ifdef CNX_TOOLS
                else if (strncmp(cp-1, "tools", 5) == 0) {
                   cp+=4;
                   generate_tools_spaces = TRUE;
		   /* doom support */
		   lm_options_tools();
                   return;
                }

#endif /* CNX_TOOLS */

		else if ( strncmp(cp-1, "tm", 2) != 0 ) {
		    warning(BAD_FLAG, *argv, 0);
		    usage();
		}

		++cp;
		set_str_parm(&junkcp, cp);
		if (strcmp(junkcp, "hpux") == 0 && 
		    !(target_som || target_esom)) {
		    esom_no_parallel = TRUE;
		    esom_object = FALSE;
		    target_som = TRUE;
		    /*
		     * Only change the text and data orginals if -R or -D
		     * flags have not been specified.
		     */
		    if ( !Rflag ) 
		    	code_offset = 0x1000;
		    if ( !Dflag ) {
		    	data_offset = DEFAULT_HPUX_DATA_OFFSET;
		    	data_on_page_after_text = DEFAULT_HPUX_DATA_ROUND;
		    }
		}
		else if (is_spp_target(junkcp) && 
			 !(target_som || target_esom)) {
		    O_S = OS_MPPOS;
		    esom_object = TRUE;
		    target_esom = TRUE;
		    esom_no_parallel = FALSE;
		    if ( !Rflag )
		    	code_offset = DEFAULT_CODE_OFFSET;
		    if ( !Dflag ) {
		    	data_offset = DEFAULT_CNX_MPP_DATA_OFFSET;
		    	data_on_page_after_text = DEFAULT_CNX_MPP_DATA_ROUND;
		    }
		}
		else if ( !(target_som || target_esom) ) {
		   warning(BAD_KEYWORD_ARG, *argv, "+tm", 0);
		}
		return;
#else
#ifdef CNX_TOOLS
        case 't':
          if (strncmp(cp-1, "tools", 5) == 0) {                  
	      cp+=4;
	      generate_tools_spaces = TRUE;
	      return;
	  }
#endif /* CNX_TOOLS */
#endif /* ESOM */

	    case 'F':		 
	        if (*cp == 'P') { 
		    /* specify floating pt. status reg init value */
                    set_str_parm(&junkcp, ++cp);
		    if (set_fp_status(&fp_status, junkcp) != 0) 
		        warning(BAD_KEYWORD_ARG, *argv, "+FP", 0);
		    return;
		} else {
		    warning(BAD_FLAG, *argv, 0);
		    usage();
 	        }
	    case 'O':		/* link-time code optimization */
	        enable = TRUE;	
	        /*
		** look for a preceding "no" to determine the value.
		*/
		if (*cp == 'n' && *(cp + 1) == 'o') {
		    enable = FALSE;
		    cp += 2;
		}
		switch (*cp) {
		    case 'f':
			if (strncmp(cp,"fastaccess",10) == 0) {
	        	    if (enable && !dont_elim_addils) {      
			        /* 
				** if not turned off with -FNO
 			        ** remove ADDILs near $global$
			        ** sort storage requests by size.
				*/
		    	        eliminating_addils = TRUE; 
		                sort_stor_reqs = TRUE;   
                            } else {
		    	        eliminating_addils = FALSE; 
		                sort_stor_reqs = FALSE;   
				dont_elim_addils = TRUE;
			    }
			} else {
                            warning(BAD_FLAG, *argv , 0);
                            usage();
			}
			break;
		    case 'p':
			if (strncmp(cp,"procelim",8) == 0) {
			    if (enable) {
				delete_dead_procs = TRUE;
			    } else {
				disable_dead_proc = TRUE;
			    }
			} else {
                            warning(BAD_FLAG, *argv , 0);
                            usage();
			}
			break;
                        /*  Changed option names to
                        ** match those of chatr (+pd size and +pi size).
                        ** For now, continue to accept older options.
                        ** To disallow older (+O[id]page=size) options
                        ** undefine OLD_PAGESIZE_SET. */
#define OLD_PAGESIZE_SET
#ifdef OLD_PAGESIZE_SET
			/* .  New options for setting the
			** instruction and data page sizes for PA2.0
			** +Oipage=X and +Odpage=X, where X is a string
			** appearing in the valid_page_sizes array */
		    case 'i':
		    case 'd':
			junkcp = cp;   /* save off character */
			if (strncmp(++cp, "page=", 5) == 0) {
			    int i;
			    cp += 5;  /* advance cp to the value X */
			    for (i = 0;
				 i < sizeof valid_page_sizes /
				     sizeof valid_page_sizes[0];
				 i++) {
				if (strcmp(cp, valid_page_sizes[i].option)
				                                        == 0) {
				    if (*junkcp == 'i') {
					inst_page_size =
					    valid_page_sizes[i].value;
				    } else {
					data_page_size =
					    valid_page_sizes[i].value;
				    }
				    break;
				}
			    }
			    if (i == sizeof valid_page_sizes /
				     sizeof valid_page_sizes[0]) {
				/* error; didn't find */
                        	warning(BAD_FLAG, *argv , 0);
                        	usage();
			    }
			} else {
			    /* error */
                            warning(BAD_FLAG, *argv , 0);
                            usage();
			}
			break;
#endif
		    case 'r':
			if (strncmp(cp,"reusedir=",9) == 0) {
			   reusedir = strdup(*argv);
			} else {
                            warning(BAD_FLAG, *argv , 0);
                            usage();
			} 
			break;

		    case 's':
			if (strncmp(cp,"staticprediction",16) == 0) {
			   staticbranch = TRUE;
			} else 
			if (strncmp(cp,"selectivepercent", 16) == 0) {
                           cp += 16;
                           set_str_parm(&junkcp, cp);
                           selectivepercent    = emalloc(5);
                           selectivepercentarg = emalloc(1 + strlen(junkcp));
                           strcpy(selectivepercent, "+Pa");
                           strcpy(selectivepercentarg, junkcp);
			} else
			if (strncmp(cp,"selectivesize", 13) == 0) {
                           cp += 13;
                           set_str_parm(&junkcp, cp);
                           selectivesize    = emalloc(5);
                           selectivesizearg = emalloc(1 + strlen(junkcp));
                           strcpy(selectivesize, "+Pb");
                           strcpy(selectivesizearg, junkcp);
			} else
			if (strncmp(cp,"selectiveO3",11) == 0) {
                           selectiveO3 = emalloc(4);
                           strcpy(selectiveO3, "+Pc");
			} else {
                            warning(BAD_FLAG, *argv , 0);
                            usage();
			}
			break;
		    case 'u':
                        /* If +Ouse_sr7 option is on then     */
			/* the import stub will use LDSID to  */
			/* get the target space register.     */
			if (strncmp(cp,"use_sr7",7) == 0) {
			   use_sr7_import = FALSE;
			} else if (strncmp(cp,"unsats_ok",9) == 0) {
                            if (enable) {
                                dont_allow_unsats = FALSE;
                            } else {
				allow_shlib_unsats = FALSE;
				keep_aout = FALSE;
				verbose |= V_SOFT_UNSATS;
                            }
			} else {
                            warning(BAD_FLAG, *argv , 0);
                            usage();
			}
			break;
		    default:
                        warning(BAD_FLAG, *argv , 0);
                        usage();
		     }
		return;
#if 0
	        set_num_parm(&Oparm, cp, "%d");
	        switch (Oparm) {
                    case 1:
	        	if (!dont_elim_addils) {      
			    /* if not turned off with -FNO */
 			    /* remove ADDILs near $global$ */
			    /* sort storage requests by size */
		    	    eliminating_addils = TRUE; 
		            sort_stor_reqs = TRUE;   
		    	    }
			break;
		     default:
                        warning(BAD_FLAG, *argv , 0);
                        usage();
		     }
		return;
#endif /* old code */
               case 'f' : {

		  if (*cp == '\0') {
		     /* +f : shared vtable support 981007 loreena*/
		     if (!(dl_header_flags & SHLIB_FIXED_ENABLE)) {
			dl_header_flags |= SHLIB_FIXED_ENABLE;
		     }
		     return;
                  }

		  /*
		  ** +forceload is not supported.
		  */
		  if (strcmp(cp,"orceload") == 0) {
		     /* +forceload */
		     warning (UNSUPPORTED_OPT_PA32, *argv, 0);
		     return;
		  }

                  /* Fastbind options */

                  if (*cp++ == 'b') {
                     /* "+fb" : Fastbind executable */

                     is_fastbind = TRUE;

                     if (*cp == 'u') {
                        is_fastbind_unresolved = TRUE;
                     }
                     else if (*cp != '\0' && ! isspace(*cp)) {
                        warning(BAD_FLAG, *argv, 0);
                        usage();
                     }
		     return;
                  }
		  warning(BAD_FLAG, *argv, 0);
		  usage();
		  return;
               }
		
	      default:
		warning(BAD_FLAG, *argv , 0);
		usage();
	     }
    }
} /* end do_option_plus */

/******************************************************************************
* FUNCTION :            expand_dash_l    
*
* ARGUMENTS:		
*	cp - current command argument pointer
*	dash_l_reference - TRUE if the library is to be subject 
*	                   to runtime dynamic path lookup. 
*       
* RETURN VALUE:
*       None
*
* PURPOSE:
*	This routine interprets the arguments given to the -l command, 
*       including interpretation of -l: which allows the user to 
*	specify the .a or .sl extension regardless of the current
*	state of the -a toggle. 
*
* NOTES:
*	-l: used to require that the name following the colon had the
*	prefix "lib" and a suffix that was either ".a" or ".sl". The
*	later restriction has been relaxed since now shared libraries
*	might have version suffixes (.0, .1, etc.). The "lib" restriction
*	was relaxed because it seemed unncessary.
*
*	Note that the library searching code is no longer:
*	   ***                     implemented in a very rigid way that
*	   *** requires "lib" be the prefix (ST_LIBH environment variable
*	   *** can directly modify the default search directories 
*	   *** default_lib_dir* and must have the "lib" incorporated
*	   *** in the directory path). 

******************************************************************************/

static void expand_dash_l(char *cp, Boolean dash_l_reference)
{

    char *junkcp, *lbn, *lib_buf;
    int lib_search_type;
    int junklen;
    Boolean colon_seen = FALSE;
    Boolean space_seen = FALSE;

    if (! *cp) {
        /* 
	** for proper error reporting we want to record if there was 
	** a space between the -l and the argument 	             
	*/
	space_seen = TRUE;
    } else if (*cp == ':') { 
        /* 
	** special case that indicates that the user has specified the       
        ** library extension .a or .sl to be used 
	*/
        colon_seen = TRUE;
	++cp;
    }

    set_str_parm(&junkcp, cp);
    junklen = strlen(junkcp);
    lib_buf = emalloc(junklen +2); /* one for \0, one for space or : */

    strcpy(lib_buf, junkcp);

    lib_search_type = colon_seen ? EXACT_LIB_MATCH : library_search;

    if (lbn = lib_name_build(lib_buf,lib_search_type)) 
        som_list_add(lbn, SEARCH_LIB, dash_l_reference);
    else {
	lbn = lib_buf;
	if (colon_seen) 
	    *lbn++ = ':';
        if (space_seen) 
	    *lbn++ = ' ';
	*lbn = '\0';
	strcat(lib_buf,junkcp); 
        user_error(CANT_OP_LIB, lib_buf, 0);
    }

    efree(lib_buf);
} /* end expand_dash_l */

/******************************************************************************
* FUNCTION :            set_fp_status    
*
* ARGUMENTS:		
*	destination - bit field to set/clear	
*       src - string of bit position descriptors
*       
* RETURN VALUE:
*       0 if no error, else -1
*
* PURPOSE:
*	This routine interprets the bit position descriptors in "src"
*	and uses them to set and clear bits in "destination". The bit
*	descriptors describe bit positions in the floation pt. status 
*	register fr0
*
* ALGORITHM:
*
******************************************************************************/

set_fp_status(destination, src)
unsigned int *destination;
char *src;
{
    int position, set;
    unsigned int temp = 0;

    while (*src) {
	switch (*src) {
	    case 'i': /* Trap on float pt ops that produce inexact results */
	    case 'I':
		position = 0;
		set = (*src == 'i') ? 0 : 1;
		break;
	    case 'u': /* Trap on floating pt underflow */
	    case 'U':
		position = 1;
		set = (*src == 'u') ? 0 : 1;
		break;
	    case 'o': /* Trap on floating pt overflow */
	    case 'O':
		position = 2;
		set = (*src == 'o') ? 0 : 1;
		break;
	    case 'z': /* Trap on divide by zero */
	    case 'Z':
		position = 3;
		set = (*src == 'z') ? 0 : 1;
		break;
	    case 'v': /* Trap on invalid floating pt ops */
	    case 'V':
		position = 4;
		set = (*src == 'v') ? 0 : 1;
		break;
	    case 'd': /* Enable sudden underflow of denormalized values */
	    case 'D':
		position = 5;
		set = (*src == 'd') ? 0 : 1;
		break;
	    default:
		return(-1);
	}

	if (set) 
	    temp = temp | (1 << position);
	else 
	    temp = temp & ~(1 << position);
	++src;
    }
    
    *destination = temp;
    return(0);
} /* end set_fp_status */

/*
 * set_str_parm -- get the parameter from a string-valued option.
 * The parameter may follow the option letter immediately, or may
 * be in a separate argument.
 */

void set_str_parm(var, cp)
char **var;		/* variable to set */
char *cp;		/* pointer to char following option */
{
    char *arg;

    arg = *argv;
    if (*cp == '\0') {		    /* parameter is in next argument */
	cp = *++argv;
	if (--argc <= 0) {
    	    user_error(MISSING_ARG, arg, 0);
	    return;
	}
    }
    *var = cp;
} /* end set_str_parm *.

/*
 * set_num_parm -- get the parameter from a numeric option.
 * The parameter may follow the option letter immediately, or may
 * be in a separate argument.
 */

void set_num_parm(var, cp, fmt)
int *var;		/* variable to set */
char *cp;		/* pointer to char following option */
char *fmt;		/* conversion format ("%d", "%x", ...) */
{
    char *arg;
    char nextc[2], fmtbuf[80];

    arg = *argv;
    if (*cp == '\0') {		    /* parameter is in next argument */
	cp = *++argv;
	if (--argc <= 0) {
	    user_error(MISSING_ARG, arg, 0);
	    return;
	}
    }
    if (cp[0] == '0' && (cp[1] == 'x' || cp[1] == 'X')) {
	strcpy(fmtbuf, "%x");
	cp += 2;
    } else if (cp[0] == '0') {
	strcpy(fmtbuf, "%o");
    } else
	strcpy(fmtbuf, fmt);
    strcat(fmtbuf, "%1s");
    if (sscanf(cp, fmtbuf, var, nextc) != 1)
	user_error(BAD_NUM_ARG, arg, 0);
} /* end set_num_parm */

void init_parm(cp)
char *cp;
{
    int *var;
#ifdef VARIABLE_SIZES
    int *var_log = NULL;
    int *var_mask;
    int i;
#endif /* VARIABLE_SIZES */
    extern int stub_area_max;
    extern int node_max;
    extern int lib_area_max;
    extern int space_array_size;
    extern int subsp_data_area_max;
    extern int subsp_fixup_area_max;
    extern void set_num_parm();

    switch (*cp++) {
#ifdef VARIABLE_SIZES
	case 'y':
            var = &sym_dict_max;
            var_log = &log_sym_dict_max;
            var_mask = &mask_sym_dict_max;
            break;
	case 's':
            var = &subsp_dict_max;
            var_log = &log_subsp_dict_max;
            var_mask = &mask_subsp_dict_max;
            break;
	case 'u':
            var = &stubs_max;
            var_log = &log_stubs_max;
            var_mask = &mask_stubs_max;
            break;
#endif /* VARIABLE_SIZES */
	case 'U': var = &stub_area_max; break;
	case 'n': var = &node_max; break;
	case 'l': var = &lib_area_max; break;
	case 'c': var = &space_array_size; break;
	case 'a': var = &argv_size; break;
	case 'S': var = &som_list_max; break;
	case 'd': var = &subsp_data_area_max; break;
	case 'X': var = &subsp_fixup_area_max;break;
	default:
	    user_error(BAD_FLAG, *argv, 0);
	    return;
	}
    set_num_parm(var, cp, "%d");
#ifdef VARIABLE_SIZES
    if (var_log != NULL) {
        /* round to next power of two; find log and mask */
        *var_log = 0;
        for (i = 1; i < *var; i <<= 1)
            *var_log++;
        *var = i;
        *var_mask = i-1;
        }
#endif /* VARIABLE_SIZES */
} /* end init_parm */

void usage()
{
    user_error(USAGE, progname, 0);
}

void som_list_add(fn, offset, dash_l_reference)
char *fn;
int offset;
Boolean dash_l_reference;      /* Was this shlib referenced by -l? */
{
    if (som_list_size == 0) {
	som_info = (struct som_info_type *) ecalloc
	  (som_list_max,sizeof(struct som_info_type));
    } else if (som_list_size >= som_list_max) {
	som_list_max += MAX_SOM_LIST;
    	som_info = (struct som_info_type *)erealloc((char *) som_info,
        		    som_list_max * sizeof(struct som_info_type));
    }

    som_info[som_list_size].som = fn;
    som_info[som_list_size].offset = offset;

    /* Clear all flags.  This gives init values to IS_ISOM and IS_LIBRARY */
    som_info[som_list_size].flags = 0;	/* Clear all flags first */
    som_info[som_list_size].flags |= dash_l_reference ? IS_DASH_L_REF : 0;
    som_info[som_list_size].flags |= archive_linear_search ? LINEAR : 0;
    som_info[som_list_size].flags |= archive_noloop_search ? NOLOOP : 0;
    som_list_size++;	/* Bump the counter */
} /* end som_list_add */

/* add a SOM at the front of the som_list, instead of the end */
void som_list_add_at_front(fn, offset, dash_l_reference)
char *fn;
int offset;
Boolean dash_l_reference;      /* Was this shlib referenced by -l? */
{
   struct som_info_type new_som;  /* temp copy of entry for SOM being added */
   int i;  /* loop counter */

   /* use normal insertion routine to add it to the end of the list */
   som_list_add(fn, offset, dash_l_reference);

   /* 
   ** save entry just made (from the end of the list).  It will be moved later
   ** to the front of the list 
   */
   new_som = som_info[som_list_size-1];

   /* copy each entry in the list down one to make room for the new entry */
   for (i = som_list_size-2; i >= 0; i--) {
      som_info[i+1] = som_info[i];
    }

   /* insert new entry at the front of the list */
   som_info[0] = new_som;
} /* end som_list_add_at_front */

void trace_list_add(symname)
char *symname;
{
    static int trace_list_size = 0;
    static int trace_list_max = MAX_TRACE_LIST;

    if (trace_list_size == 0) {
	trace_list = (char **)ecalloc(trace_list_max,sizeof(int *));
    } else if (trace_list_size >= trace_list_max) {
	trace_list_max += MAX_TRACE_LIST;
	trace_list = (char **) erealloc ((char *) trace_list,
				trace_list_max * sizeof(int *));
    }
    trace_list[trace_list_size++] = symname;
} /* end trace_list_add */

void undef_list_add(symname)
char *symname;
{
    static int undef_list_size = 0;
    static int undef_list_max = MAX_UNDEF_LIST;

    if (undef_list_size == 0) {
	undef_list = (char **)ecalloc(undef_list_max,sizeof(int *));
    } else if (undef_list_size == undef_list_max) {
	undef_list_max += MAX_UNDEF_LIST;
	undef_list = (char **) erealloc((char *) undef_list,
				undef_list_max * sizeof(int *));
    }
    undef_list[undef_list_size++] = symname;
} /* end undef_list_add */

void promotion_list_add(symname)
char *symname;
{
    static int promotion_list_size = 0;
    static int promotion_list_max = MAX_PROMOTION_LIST;

    if (promotion_list_size == 0) {
        promotion_list = (char **)ecalloc(promotion_list_max,sizeof(int *));
    } else if (promotion_list_size >= promotion_list_max) {
        promotion_list_max += MAX_PROMOTION_LIST;
        promotion_list = (char **) erealloc((char *) promotion_list,
                            promotion_list_max * sizeof(int *));
    }
    promotion_list[promotion_list_size++] = symname;
} /* end promotion_list_add */

void absolute_list_add(abs_symbol)
char *abs_symbol;
{
    static int absolute_list_size = 0;
    static int absolute_list_max = MAX_ABSOLUTE_LIST;

    if (absolute_list_size == 0) {
        absolute_list = (char **)ecalloc(absolute_list_max,sizeof(int *));
    } else if (absolute_list_size >= absolute_list_max) {
        absolute_list_max += MAX_ABSOLUTE_LIST;
        absolute_list = (char **)erealloc((char *) absolute_list,
                                          absolute_list_max * sizeof(int *));
    }
    absolute_list[absolute_list_size++] = abs_symbol;
} /* end absolute_list_add */

void def_dir_list_add(dirname)
char *dirname;
{
    static int def_dir_list_size = 0;
    static int def_dir_list_max = MAX_DIR_LIST;

    if (dirname != NULL && *dirname == '\0')
	/* do not add zero length directories to list */
	return;

    if (def_dir_list_size == 0) {
	def_dir_list = (char **)ecalloc(def_dir_list_max,sizeof(int *));
    } else if (def_dir_list_size == def_dir_list_max) {
	def_dir_list_max += MAX_DIR_LIST;
	def_dir_list = (char **) erealloc((char *) def_dir_list,
				 def_dir_list_max * sizeof(int *));
    }
    def_dir_list[def_dir_list_size++] = dirname;
} /* end def_dir_list_add */

void dir_list_add(dirname)
char *dirname;
{
    static int dir_list_size = 0;
    static int dir_list_max = MAX_DIR_LIST;

    if (dir_list_size == 0) {
	dir_list = (char **)ecalloc(dir_list_max,sizeof(int *));
    } else if (dir_list_size == dir_list_max-1) {
	dir_list_max += MAX_DIR_LIST;
	dir_list = (char **)erealloc((char *) dir_list,
				dir_list_max * sizeof(int *));
    }
    dir_list[dir_list_size++] = dirname;
    dir_list[dir_list_size] = NULL;
} /* end dir_list_add */

void subprog_list_add(symname)
char *symname;
{
    static int subprog_list_max = MAX_SUBPROG_LIST;
#ifdef NO_PROC_ELIM
    static int subprog_list_size = 0;
#endif

    if (subprog_list_size == 0) {
	subprog_list = (char **)ecalloc(subprog_list_max,sizeof(int *));
    } else if (subprog_list_size >= subprog_list_max) {
	subprog_list_max += MAX_SUBPROG_LIST;
	subprog_list = (char **)erealloc((char *) subprog_list,
				subprog_list_max * sizeof(int *));
    }
    subprog_list[subprog_list_size++] = symname;
} /* end subprog_list_add */

void forget_list_add(symname)
char *symname;
{
    static int forget_list_size = 0;
    static int forget_list_max = MAX_FORGET_LIST;

    if (forget_list_size == 0) {
        forget_list = (char **)ecalloc(forget_list_max,sizeof(int *));
    } else if (forget_list_size >= forget_list_max) {
        forget_list_max += MAX_FORGET_LIST;
        forget_list = (char **)erealloc((char *) forget_list,
                                forget_list_max * sizeof(int *));
    }
    forget_list[forget_list_size++] = symname;
} /* end forget_list_add */

#ifndef NO_MULTIPLE_INITIALIZERS
static void initializer_list_add(char *symname)
{
    static int initializer_list_max = MAX_INITIALIZER_LIST;

    if (initializer_list_size == 0) {
	initializer_list = 
	    (char **)ecalloc(initializer_list_max,sizeof(int *));
    } else if (initializer_list_size >= initializer_list_max) {
	initializer_list_max += MAX_INITIALIZER_LIST;
	initializer_list = 
	    (char **)erealloc((char *) initializer_list,
	                      initializer_list_max * sizeof(int *));
    }
    initializer_list[initializer_list_size++] = symname;
}
#endif /* !NO_MULTIPLE_INITIALIZERS */

static char *lib_exists(char *s1, char *s2, char *s3, char *s4)
{
    char *fullname;
    struct stat st;

    if (s1 == NULL)
        return (NULL);
    fullname = emalloc(strlen(s1)+strlen(s2)+strlen(s3)+strlen(s4)+1);
    sprintf(fullname, "%s%s%s%s", s1, s2, s3, s4);
    if (stat(fullname, &st) != -1)
        return (fullname);
    else {
       ANALYZE_LARGE_FILE_ERROR(fullname);
    }

    efree(fullname);
    return (NULL);
} /* end lib_exists */

/*
 * Search directory for prefix + base + suffix where prefix and suffix are
 * determined by search flags.
 */
static char *lib_directory_search(char *directory,
				  char *base,
				  int search)
{
    char *fullname;

    /*  "don't restrict name after -l:" */
    if (search == EXACT_LIB_MATCH) {
	if (fullname = lib_exists(directory, "/", base, "")) {
	    return (fullname);
	}
    } else {

	if (search & SHARED_LIB_ENABLED && search & SHARED_LIB_FIRST) {
	    if (fullname = lib_exists(directory, "/lib", base, ".sl")) {
		return (fullname);
	    }
	}
	
	if (search & ARCHIVE_LIB_ENABLED) {
	    if (fullname = lib_exists(directory, "/lib", base, ".a")) {
		if ((verbose & V_WHY) && building_shlib && search == DEFAULT_LIB_SEARCH)
		    warning(ARCHIVE_LOADED_IN_SHLIB, fullname, base, 0);
		return (fullname);
	    }
	}
	
	if (search & SHARED_LIB_ENABLED && !(search & SHARED_LIB_FIRST)) {
	    if (fullname = lib_exists(directory, "/lib", base, ".sl")) {
		return (fullname);
	    }
	}
    }
    return(NULL);
} /* end lib_directory_search */

/*
 * This routine is for HPUX only, HPE has it's own copy in hpe_driver.c 
 * The purpose of this routine is to iterate over all directories in the
 * effective library search path, passing on the base and selection flags.
 */
char *lib_name_build(char *base, int lib_select)
{
    char **dir, *fullname;

    if (dir_list) 
        for (dir = dir_list; *dir != NULL; dir++) {
	    if (fullname = lib_directory_search(*dir, base, lib_select))
	        return (fullname);
	}

    if (def_dir_list) 
        for (dir = def_dir_list; *dir != NULL; dir++) {
	    if (fullname = lib_directory_search(*dir, base, lib_select))
	        return (fullname);
	}

    if (default_lib_dir1) {
        if (fullname = lib_directory_search(default_lib_dir1, 
					    base, 
					    lib_select))
	    return (fullname);
    }

    if (default_lib_dir2) {
        if (fullname = lib_directory_search(default_lib_dir2, 
					    base, 
					    lib_select))
	    return (fullname);
    }

#ifdef V4FS_NO_MORE
    if (default_lib_dir3) {
        if (fullname = lib_directory_search(default_lib_dir3, 
					    base, 
					    lib_select))
	    return (fullname);
    }
#endif /* V4FS */

    return (NULL);
} /* end lib_name_build */

/******************************************************************************
* FUNCTION:            build_embedded_path    
*
* ARGUMENTS:		
*	None
*       
* RETURN VALUE:
*       None
*
* PURPOSE:
*	This routine modifies the global variable "embedded_path" 
*	to point to a string of directories separated by ':' The
*       directories are all the directories specified with the -L
*	option and the LPATH environment variable. This directory 
*       list will be searched by the shared library loader at 
*       runtime to find shared library files.
*
* NOTES:
*
* ALGORITHM:
*
******************************************************************************/

#define EMBEDDED_STRING_INC 256

build_embedded_path()
{
    int path_list_max = EMBEDDED_STRING_INC;
    int path_list_len = 0;
    int sub_len;
    char **dir;

    embedded_path = emalloc(path_list_max);
    embedded_path[0] = '\0';        /* for initial strcat() */

    if (dir_list != NULL) {
        for (dir = dir_list; *dir != NULL; dir++) {
	    sub_len = strlen(*dir) + 2; /* ':' and final '\0' */
	    path_list_len += sub_len;
	    if (path_list_len >= path_list_max) {
		path_list_max += (sub_len + EMBEDDED_STRING_INC);
		embedded_path = erealloc((char *) embedded_path, 
					 path_list_max);
	    }
	    strcat(embedded_path, ":");
	    strcat(embedded_path, *dir);
	}
    }

    if (def_dir_list != NULL) {
 	for (dir = def_dir_list; *dir != NULL; dir++) {
            sub_len = strlen(*dir) + 2; /* ':' and final '\0' */
            path_list_len += sub_len;
            if (path_list_len >= path_list_max) {
                path_list_max += (sub_len + EMBEDDED_STRING_INC);
                embedded_path = erealloc((char *) embedded_path, 
					 path_list_max);
            }
            strcat(embedded_path, ":");
            strcat(embedded_path, *dir);
        }
    }

    if (!path_list_len) {
        efree(embedded_path);
	embedded_path = NULL;
    }
} /* end build_embedded_path */

void fil_get_args(fn)
char *fn;
{
    FILE *f;
    char buf[1024];      /* the argument buffer */

    char **nargv;
    int nargc = 0;

    extern Boolean fgetword();

    f = efopen(fn,"r",CANT_OPEN);

    nargv = (char **)emalloc(argv_size * sizeof(char *));
    nargv[0] = NULL;

    /* f is a pointer to a file opened before this routine was called */

    while (fgetword(f, buf, EOF)) {

        if (++nargc >= argv_size) {
	    argv_size += MAX_ARGC;
	    nargv = (char **)erealloc((char *) nargv, 
				      argv_size * sizeof(char *));
        }
    
        /* copy arguments from buffer */
        nargv[nargc] = (char *)emalloc(strlen(buf) + 1);
        strcpy(nargv[nargc],buf);
    }

    /* copy remaining arguments from command line (or previous file) */
    while (--argc > 0) {
	if (++nargc >= argv_size) {
	    argv_size += MAX_ARGC;
	    nargv = (char **)erealloc((char *) nargv,
				argv_size * sizeof(char *));
	}
	nargv[nargc] = *++argv;
    }

    argv = nargv;
    argc = nargc + 1;
} /* end fil_get_args */

void env_get_args()
{

/* 
** set run string Option pointer (argc, argv) to correct character
** Option list which is (argc, argv) if LDOPTS is null, or LDOPTS
** then (argc, argv) otherwise. 
*/

   char *ldopts, **p;

   char **argxv; /* temp copies of argc/argv */
   int  argxc;

   int  slen, i;
   extern char *getenv(), *strtok();

   /* 
   ** if there is an LDOPTS environment variable, tokenize it with
   ** strtok, then construct a new argument list by creating the
   ** space with malloc and moving the LDOPTS arg pointers, then
   ** the main prog argc/v arg pointers over.  Point to this whole
   ** mess with argxv.  The malloc area is made larger than it will
   ** ever need to be : (argc+slen) pointer elements.  Assign the local
   ** copies back to the global argc/argv 
   */

   argxc = argc;                      /* default */
   if ((ldopts=getenv("LDOPTS")) && (slen=strlen(ldopts))) {

      /* 
      ** Make a copy of the environment variable string because the
      ** calls below to strtok() will modify the contents of that environment
      ** variable string.  This is bad because we sometimes have to look at
      ** it again later (when the linker is re-invoked by ucomp).
      */
      char * ld_opts = (char *) emalloc( (slen+1) * sizeof(char) );
      strcpy( ld_opts, ldopts );
#ifdef INSTRUMENT_MALLOC
      p=(char **)emalloc ((argc+slen) * sizeof(ldopts));
      if (argxv=p) {
#else
      if (argxv=p=(char **)emalloc ((argc+slen) * sizeof(ldopts))) {
#endif /* INSTRUMENT_MALLOC */
	 *p++ = *argv;  /* copy program name "argv[0]" ahead of LDOPTS */
         if (*p++ = ((MB_CUR_MAX ==1) 
			 ? strtok(ld_opts," \t")
			 : mb_strtok(ld_opts," \t"))) { 
	   /* 1st call gives string */
            argxc++;
            while (*p++ = ((MB_CUR_MAX ==1) 
			       ? strtok(0," \t") 
			       : mb_strtok(0," \t"))) { /* use same string */
               argxc++;
            }
            p--;   /* backstep */
            for (i=1; i<argc; i++) *p++ = argv[i]; /* now copy others */
            argc = argxc;             /* copy temps back to globals */
            argv = argxv;             
         }
#ifdef INSTRUMENT_MALLOC
      }
#else
      }
#endif /* INSTRUMENT_MALLOC */
   }
} /* end env_get_args */

/* displays command line options and environment variables */ 
void show_command_line(argc, argv)
int argc;
char **argv;
{
#ifdef V4FS_NO_MORE
#  define NUM_LIBS 3
#else /* V4FS */
#  define NUM_LIBS 2
#endif /* V4FS */

    char **dir;
    char *ptr[NUM_LIBS];
    register int count;
    register char *cp1, *cp2;
    int prefix = FALSE;

    for (count=0; count<argc; count++)
	printf("%s ", argv[count]);

    printf(ld_gets(1, 1121, "\nLPATH is : "));

    ptr[0] = default_lib_dir1;
    ptr[1] = default_lib_dir2;
#ifdef V4FS_NO_MORE
    ptr[2] = default_lib_dir3;
#endif /* V4FS */

    if (def_dir_list) {
        for (dir = def_dir_list; *dir != NULL; dir++) {
	    if (prefix)
		printf(":");
	    else
		prefix = TRUE;
	    printf("%s",*dir);
	}
    } else {
	for (count = 0; count < NUM_LIBS; count++) {
	    cp1 = ptr[count];
	    if (cp1) {
		if (prefix)
		    printf(":");
		else
		    prefix = TRUE;
		printf("%s",cp1);
	    }
	}
    }

    printf("\n");
#undef NUM_LIBS
} /* end show_command_line */

void set_fdp_file_names()
{
    int slen;
    char * flow_data;
    
    if (specify_flow_data)
       fdp_counter_file_name = fdp_counter_file_string;
    else {
       /* 
       ** Check for environment variable specifying directory path to 
       ** data file 
       */
       flow_data = getenv ("FLOW_DATA");

       if (flow_data == NULL || flow_data[0] == 0)
          fdp_counter_file_name = fdp_counter_file_string;
       else
          fdp_counter_file_name = flow_data;
    }

    /* if -b and -I on, pick up the instrumentation support code in scrt0.o */
    if ( do_fdp_measure && building_shlib )
    {
       char *scrt0_file_name = getenv( "ST_SCRT" );
       char **export = PBO_exports; 
       if (scrt0_file_name == NULL)
	  scrt0_file_name = SCRT0_FILE_NAME_STRING;
       som_list_add_at_front(scrt0_file_name, FORCE_LOAD, FALSE);

       /* add the initializer name provided by scrt0.o */
       initializer_list_add(SCRT0_INITIALIZER_STRING);

       while (*export) {
	   if (!on_shlib_export_list(*export)) {
	       shlib_export_list_add(*export);
	   }
	   *export++;
       }

    }

    if ( do_fdp_position && !ld_after_be_process &&
         getenv( "FLOW_DATA_DIR" ) != NULL )
       warning( FLOW_DATA_DIR_OBSOLETE, NULL );

    /* Set the link order file name, unless it is user supplied with '-PD' */
    if (do_fdp_position && fdp_delete_link_order) {
       /* 
       ** Get a temporary file in the appropriate directory (P_tempdir)
       ** beginning with the 3 character sequence "FDP"
       */
       fdp_link_order_file_name = tempnam ("","FDP");
    }
} /* End procedure set_fdp_file_names */

/******************************************************************************
* FUNCTION :            backend_driver    
*
* ARGUMENTS:
*       
*       
* RETURN VALUE:
*       ret_val - TRUE is the has_intermediate_code is set in the space
*                 dictionary record of any spaces. Otherwise, return FALSE.
*
* PURPOSE:
*       This routine sets up the work to invoke the backend. If no error
*       returned from the backend process, then the current link process 
*       (the pre-link process) is replaced with a new link process. This
*       new link process has the exact same command line argument as the
*       pre-link process except that an internal flag is set to indicate that 
*       all the pre-link work is done for this new link process. 
*
*       Here is the logic for choosing which ucomp to invoke.
*       1. A front end will always pass a -Fb option to the linker even if
*          files to be linked were not ISOMs. This is because a driver cannot
*          know if the .o files are ISOMs or SOMs hence it always have to 
*          pass it "just in case". 
*       2. If more than one -Fb options were passed (it can happen if the 
*          user is passing -WL,-Fb options to the linker), the last one wins.
*       3. If the user sets ST_SABE, it overrides the -Fb settings. 
*       4. If none of the above, then the linker chooses standard ucomp path.
* NOTES:
*
* ALGORITHM:
*
******************************************************************************/

backend_driver()
#include <unistd.h>
{
    int  ucomp_argc;
    char **ucomp_argv;
    int  ucomp_max_arguments = 20; 
    int  temp_argc = 0;
    char *cp;

    if (cp = getenv("ST_SABE")) {
      backend_process = (char *) emalloc(strlen(cp) + 1);
      strcpy(backend_process,cp);
    }
    
    if (backend_process == NULL) 
#ifdef V4FS
#if 0 /* pre IC3 location */
        backend_process = "/usr/ccs/lbin/ucomp";
#endif /* 0 */
        backend_process = "/opt/langtools/lbin/ucomp";
#else
        backend_process = "/usr/lib/ucomp";
#endif /* V4FS */

    /* check if the backend can be executed */
    if (access(backend_process, X_OK) != 0) {
        remove (backend_command_fname); /* purge the ucomp command file */
        user_error (CANNOT_EXECUTE_BE, backend_process, 0); 
    }
    ucomp_argc = 0;
    ucomp_argv = (char **)emalloc(ucomp_max_arguments * sizeof(char *));

    ucomp_argv[ucomp_argc++] = backend_process;

    if (verbose & V_PBO) {
       ucomp_argv[ucomp_argc++] = "-v";
    }

    if (do_fdp_measure) {
       ucomp_argv[ucomp_argc++] = "+Pi";
    }

    if (selectivepercent) {
       ucomp_argv[ucomp_argc++] = selectivepercent;
       ucomp_argv[ucomp_argc++] = selectivepercentarg;
    }
    if (selectivesize) {
       ucomp_argv[ucomp_argc++] = selectivesize;
       ucomp_argv[ucomp_argc++] = selectivesizearg;
    }
    if (selectiveO3) {
       ucomp_argv[ucomp_argc++] = selectiveO3;
    }
    /* Pass +Oreusedir=pathname to ucomp */
    if (reusedir) {
       ucomp_argv[ucomp_argc++] = reusedir;
    }

    /* tell ucomp one of:
       building complete executable
       building incomplete executable
       building shared library
       building relocatable object file
       (Only one of these flags should be set)
    */
    if (building_incomp_exec) {
       ucomp_argv[ucomp_argc++] = "+OLi";
    }
    else if (building_shlib) {
       ucomp_argv[ucomp_argc++] = "+OLs";
    }
    else if (relocatable) {
       ucomp_argv[ucomp_argc++] = "+OLr";
    }
    else {    /* building fully archive program file */
       ucomp_argv[ucomp_argc++] = "+OLc";
    }

    if (do_fdp_position) {
	/* Specify +DA2 for PA 2.0 to ucomp. */
	if (pcx_u_pa2_0) {
	   ucomp_argv[ucomp_argc++] = "+DA2.0N";
	}
	ucomp_argv[ucomp_argc++] = "+Pr";
	/* +df and +pgm are only meaningful for re-positioning code */
	if (specify_flow_data) {
	    ucomp_argv[ucomp_argc++] = "+Pf";
	    ucomp_argv[ucomp_argc++] = fdp_counter_file_string; 
	}
	ucomp_argv[ucomp_argc++] = "+Pg";
	if (specify_profile_pgm)
	   ucomp_argv[ucomp_argc++] = fdp_output_name;
	else {
	   char *base;
	   if (MB_CUR_MAX == 1)
	       base = strrchr( output_name, '/' );
	   else
	       base = mb_strrchr( output_name, '/' );
	   ucomp_argv[ucomp_argc++] = ((base == NULL) ? output_name : ++base);
        }
    }

    ucomp_argv[ucomp_argc++] = backend_command_fname;
    ucomp_argv[ucomp_argc++] = NULL;                 
    temp_argc = 0;

    fprintf(backend_command_file,"\n");  /* a blank to indicate that the  
                                            following info is the link
                                            command line arguments */

    fprintf(backend_command_file,"%s\n%s\n%s\n",save_argv[temp_argc++], 
            "+vnocompatwarnings\n-FT", process_id);

    while (temp_argc < save_argc) {
#if 0
	/* This line does nothing.  Why? --pschwan@thepuffingroup.com */
        save_argv[temp_argc];
#endif
        fprintf(backend_command_file,"%s\n",save_argv[temp_argc]);
        temp_argc++;
    }
    fclose(backend_command_file);
    chmod(backend_command_fname,0440);  /* set r by owner and by group,
                                           to make sure the file is not
                                           isoms */
   
    if (verbose & V_WHY) {
       info_message( INVOKE_UCOMP, ucomp_argv[0], backend_command_fname, 0 );
    }

    if (verbose & V_PBO) {
        temp_argc = 0;
        while (temp_argc < ucomp_argc) {
            printf ("%s ",ucomp_argv[temp_argc]);
            temp_argc++; 
        }
	printf("\n");
    }

    /* replace the current link process with the ucomp process */
#ifdef PFA
    /* dump counters before the exec causes them to be lost */
    pfa_dump();
#endif

    if (execvp(ucomp_argv[0],ucomp_argv)) 
       /* Only reached if an error */
       remove (backend_command_fname); /* purge the ucomp command file */
       user_error (CANNOT_EXECUTE_BE, backend_process, 0);
} /* end backend_driver */

finish_options()
{
    char*	initializer;
    int  	initializer_idx;

    /* 
    ** Check for invalid parameter combinations and issue warnings, errors,
    ** or ignore. Also make final flag adjustments. 
    */

#ifdef OBS_FEATURES_WARN

    /* Emit To-be-changed warnings */

    if (verbose & V_CHANGE_WARN) {

      if (verbose & V_DETAIL_CHANGE_WARN) {
        if (emit_dash_A_warn)
          warning( OPTION_BEING_NUKED, "-A", 0 );

        if (emit_dash_C_warn)
          warning( OPTION_BEING_NUKED, "-C", 0 );

        if (emit_dash_F_warn)
          warning( OPTION_BEING_NUKED, "-F", 0 );

        if (emit_dash_H_warn)
          warning( OPTION_BEING_NUKED, "-H", 0 );
      }

      found_change_warn = found_change_warn ||
                          emit_dash_A_warn ||
                          emit_dash_C_warn || 
                          emit_dash_F_warn || 
                          emit_dash_H_warn;

    }

#endif

    /*
    **
    ** If -noshared and creating shlib, options are incompatible.
    */
    if ((!allow_link_with_shlibs) && (building_shlib)) {
	external_error(BUILD_SHLIB_IN_NOSHARED, 0);
    }

    /* 
    ** If not building a shared library, then don't unpad the $PRIVATE$
    ** or unloadable spaces.  If a command file was seen, then don't
    ** do unpadding.
    */
    if (!building_shlib) {
	do_unloadable_unpadding = FALSE;
	do_private_unpadding = FALSE;
    }
    if (command_file_seen) {
	do_unloadable_unpadding = FALSE;
	do_private_unpadding = FALSE;
	do_text_unpadding = FALSE;
    }
    if (!sharable) {
       do_private_unpadding = FALSE;
    }
    if (data_origin_set) {
       do_private_unpadding = FALSE;
    }
    if (do_unloadable_unpadding) {
	dl_header_flags |= UNPAD_UNLOADABLE;
    } else {
	dl_header_flags &= ~UNPAD_UNLOADABLE;
    }


    /* verify that we have input files to link */
    if (som_list_size == 0)
	usage();

    if (do_fdp_measure) {  /* -I */
	/*  turn off addil_elimination if -I is on */
        if (eliminating_addils) {
	    eliminating_addils = FALSE; /* issue warning, turn Opt. off */
	    sort_stor_reqs = FALSE;     /* don't sort storage requests */
	    /*  only give warning if -v specified */
	    if (verbose & V_WHY) {
	        warning(BAD_ARG_COMBO, "+O or -O", "-I", 0);
	    }
	}

    	if (do_fdp_position) { 
	    /* issue warning, turn fdp positioning off */
            do_fdp_position = FALSE;
	    do_procedure_fdp = FALSE;
	    /*  only give warning if -v specified */
	    if (verbose & V_WHY) {
	        warning(BAD_ARG_COMBO, "-P", "-I", 0);
	    }
        }

        if (dash_A) { 
	    /* issue warning, turn dash_a off */
            dash_A = FALSE;
	    base_file_name = NULL;
	    warning(BAD_ARG_COMBO, "-A", "-I", 0);
        }

        if (building_shlib)  {
	    /* building an instrumented shlib */

	    /* hide symbols from scrt0.o that should not be exported */
	    hide_list_add(branch_counter_string);
	    hide_list_add(BB_STRING_NAME);
	    hide_list_add(BB_COUNT_NAME);
	    hide_list_add(branch_name_string);
	    hide_list_add(branch_name_string_end);
#ifdef DEBUG
            som_list_add(lib_name_build("dld", 
					SHARED_LIB_ENABLED),
			 SEARCH_LIB, TRUE);
#else
            som_list_add(lib_name_build("dld", 
					SHARED_LIB_ENABLED),
			 SEARCH_LIB, FALSE);
#endif /* DEBUG */
        }
    }

    if (do_fdp_position) {  /* -P */ 
        if (dash_A) { 
	    /* issue warning, turn dash_a off */
            dash_A = FALSE;
	    base_file_name = NULL;
	    warning(BAD_ARG_COMBO, "-A", "-P", 0);
        }
    }

    if (!alloc_stubs_xl && !alloc_stubs_ux)
	extern_plabels = FALSE;

    if (relocatable) {
        magic_number = RELOC_MAGIC;

	/*  the +f option for shared vtable support is
           incompatible with a relocatable link. issue a warning and turn
           off shared vtable support. */

	if (dl_header_flags & SHLIB_FIXED_ENABLE) {
	   dl_header_flags &= ~SHLIB_FIXED_ENABLE;
	   warning(BAD_ARG_COMBO, "+f", "-r", 0);
	}
	   
        /*
        ** the strip options, -x , and -s are incompatible with a 
        ** relocatable link.  symbol information can not be removed
        ** until fixups have been applied because the symbol index is
        ** encoded within the fixup.  therefore, issue a warning
        ** and disable strip options when performing a relocatable link.
        */

        if (strip_symbols) {                             
	    strip_symbols = FALSE;
	    strip_debug = FALSE;
            warning(BAD_ARG_COMBO, "-s", "-r", 0);
        }

        if (strip_local_symbols) {
            strip_local_symbols = FALSE; 
            warning(BAD_ARG_COMBO, "-x", "-r", 0);
        }

        if (building_shlib)  {           /* bad combination.  We ignore -b,
                                            issue a warning, and do the -r */
            building_shlib = FALSE;      /* reset shared lib flags */
            building_incomp_exec = FALSE; 
            alloc_stubs_ux = FALSE;
            gen_ldr_fixups = FALSE;
            extern_plabels = FALSE;
            warning(BAD_ARG_COMBO, "-b", "-r", 0);
        } else if (eliminating_addils) { /* issue warning, turn optimize off */
            eliminating_addils = FALSE;
	    sort_stor_reqs = FALSE;      /* don't sort storage requests */
            warning(BAD_ARG_COMBO, "-O", "-r", 0);
	}
    } else if (building_shlib) {
        magic_number = SHL_MAGIC;
	search_alldefs = TRUE;
        if (eliminating_addils) {   /* issue warning, turn optimize off */
            eliminating_addils = FALSE;
	    sort_stor_reqs = FALSE;     /* don't sort storage requests */
            warning(BAD_ARG_COMBO, "-O", "-b", 0);
        }
    } else if (sharable) {
#ifdef ESOM
	if ( esom_object && O_S == OS_MPPOS ) {
	    magic_number = CNX_SHARE_MAGIC;
	    O_S = OS_HPUX;
	} else
#endif /* ESOM */
	    magic_number = (demand_load? DEMAND_MAGIC : SHARE_MAGIC);
    } else {
#ifdef ESOM
	if ( esom_object && O_S == OS_MPPOS ) {
	    magic_number = CNX_SHARE_MAGIC;
	    warning(EXEC_MAGIC_INVALID, 0);
	    O_S = OS_HPUX;
	} else
#endif /* ESOM */
	    magic_number = EXEC_MAGIC;
	data_mmap_addr = -1;
	/* if -N is specified, data is placed on the page following 
	   text reguardless of -D or default data origin. */
	data_on_page_after_text = TRUE;
    }

    if (eliminating_addils) {  /* -O */ 
        if (dash_A) { 
	    /* issue warning, turn optimize off */
            eliminating_addils = FALSE;
            sort_stor_reqs = FALSE;     /* don't sort storage requests */
            warning(BAD_ARG_COMBO, "-O", "-A", 0);
            dash_A = FALSE;
        }

        if (relinkable) { 
	    /* issue warning, turn Opt. off */
            eliminating_addils = FALSE;
            sort_stor_reqs = FALSE;     /* don't sort storage requests */
            warning(BAD_ARG_COMBO, "-O", "fru", 0);
            relinkable = FALSE;
        }
    }

    /* 
    ** Dont support dead procedure elimination with FRU, -A option, or
    ** relocatable links. 
    */
    if (delete_dead_procs && 
	(disable_dead_proc || relocatable || dash_A || relinkable)) {
        delete_dead_procs = FALSE;
    }

#ifdef WW_ANNOTATIONS
    /* If doing any of these funky options, turn off annotations */
    if (relocatable || dash_A || relinkable) {
      annotations_killed_at_startup=TRUE;
      do_ww_annotations = FALSE;
    }
#endif /* WW_ANNOTATIONS */

    /* .  Don't hide initializers */
    if (building_shlib && initializer_list) {
	for (initializer_idx = 0;
	     initializer_idx < initializer_list_size;
	     initializer_idx++) {

	    initializer = initializer_list[initializer_idx];
	    remove_from_hide_list(initializer);
	    if (!on_shlib_export_list(initializer)) {
		shlib_export_list_add(initializer);
	    }
	}
    }

    /* doom support */
    lm_finish_options();
} /* end finish_options */

#ifdef ESOM
int
is_spp_target(target)
char *target;
{
	static char *targets[] = {
		"sppux",
		"spp1",
		"spp2",
		"spp1000",
		"spp1200",
		"spp1600",
		NULL
	};

	static char *spp2000_targets[] = {
		"spp2000",
		"s2000",
		"x2000",
		"S2000",
		"X2000",
		NULL
	};
	
	int i;

	for( i = 0; targets[i] != NULL; i++ )
	  if ( strcmp(target, targets[i]) == 0 )
	    return 1;

	for( i = 0; spp2000_targets[i] != NULL; i++ )
	  if ( strcmp(target, spp2000_targets[i]) == 0 ) {
	    spp2000_target = TRUE;
	    return 1;
	  }

	return 0;
}

int
is_esom_memory(type)
char *type;
{
	static struct memory {
		char *name;
		int   value;
	} esom_memory_types[] = {
		"near", CNX_INIT_NEAR,
		"near_shared", CNX_INIT_NEAR,
		"far", CNX_INIT_FAR,
		"far_shared", CNX_INIT_FAR,
		"node", CNX_INIT_NODE,
		"node_private", CNX_INIT_NODE,
		0,0
	};

	int i;

	for ( i = 0; esom_memory_types[i].name != 0; i++ )
		if ( strcmp(type, esom_memory_types[i].name) == 0 )
			return esom_memory_types[i].value;

	return -1;
}
#endif /* ESOM */


/**
 **   Invoke linker online help.
 **/

void
invoke_linker_online_help()
{
   if (fork() == 0) {
      /* Invoke linker on-line help */

#ifdef PFA
     pfa_dump();
#endif
      if (execl(HELPVIEW_PATH, HELPVIEW_PATH, "-helpVolume",
         LINKER_HELPVIEW_VOLUME_NAME, 0) != 0) {
         /* Cannot invoke helpview */

         system_error(CANT_EXEC_HELPVIEW, HELPVIEW_PATH, 0);
      }
   }

   if (argc == 1) {
      /* "ld +help" - terminate ld command */

#ifdef PFA
     pfa_dump();
#endif
      exit(0);
   }
}
