/*
 *  HP 9000 Series 800 Linker, Copyright Hewlett-Packard Co. 1985-1999  
 *  External Definitions for Driver Routines
 *
 */

#include <setjmp.h>

#include "sys/magic.h"

/* Globals */

extern char  *PRODUCT_ID; /* from version.[ch] */
extern Boolean pcx_u_pa2_0;	/* PCX-U PA 2.0 new instructions */
extern Boolean staticbranch;	/* PCX-U PA 2.0 new option */
extern Boolean use_sr7_import;	/* Import stub goes through sr7 only  */
extern Boolean allow_link_with_shlibs; /* Allow shared libs to be linked */

#ifdef OBS_FEATURES_WARN

/*
  This flag is set if any situation is encountered that could indicate a
  change/migration warning.
*/

extern Boolean found_change_warn;

#endif

extern jmp_buf		drive;
extern char		*progname;
struct som_info_type {
	char *som;
	int offset;
	int flags;
};
#define IS_ISOM 	0x01
#define IS_LIBRARY	0x02
#define IS_DASH_L_REF	0x04
#define LINEAR		0x08
#define NOLOOP		0x10
extern struct som_info_type *som_info;
extern unsigned short   dl_header_flags;

extern Boolean isom_exist;
extern Boolean ld_after_be_process; 
extern char    *process_id;
extern char    *backend_command_fname;
extern FILE    *backend_command_file;
extern Boolean keep_compiled_isoms;


#define FU_DATA_UNSAT   0    /* -Fud */
#define FU_TEXT_UNSAT   1    /* -Fut */
#define FU_ALL_UNSAT    2    /* -Fu  */
#define FU_NUM_ENTRIES  3

#define FS_TRACE_ALL           0   /* -Fs  */
#define FS_TRACE_NO_FNAME      1   /* -Fsn */
#define FS_TRACE_EXPORTS       2   /* -Fse */
#define FS_TRACE_EXPORTS_STOR  3   /* -Fss */
#define FS_TRACE_RESOLVES      4   /* -Fsr */
#define FS_NUM_ENTRIES         5

extern Boolean list_unsats_only;
extern Boolean trace_syms_only;

extern FILE *unsat_files     [];
extern FILE *trace_sym_files [];

extern Boolean unsat_found;

extern int 		bind_mode;   /* value of last -B option read        */
extern char   *embedded_path;        /* shared library runtime path string  */
extern int     embedded_path_index;  /* shared library runtime path index   */
extern Boolean search_alldefs; 	     /* search all defs for exports ?       */
extern Boolean eliminating_addils;   /* remove ADDILs near $global$         */
extern Boolean sort_stor_reqs;       /* sort storage requests by size       */
extern Boolean allow_code_unsats;    /* are code unsats allowed in          */
				     /* incomplete a.outs?                  */
extern int     clean_stack_size;     /* size of stack area in bytes dld.sl is 
				        to leave zeroed (clean) at startup */

extern char		**undef_list;
extern char		**trace_list;
extern char 		**subprog_list;
extern int              subprog_list_size;
extern int              subprog_list_max;
extern char 		**forget_list;
extern char             **promotion_list;
extern char             **absolute_list;
#ifndef NO_MULTIPLE_INITIALIZERS
extern char             **initializer_list;
#endif /* !NO_MULTIPLE_INITIALIZERS */
extern unsigned int     *product_key;    

/* Global flags */
/* LIBC_COMPAT */
extern char             *shlib_internal_name;

/*
** code_offset will now be the __text_start address and
** code_mmap_addr will be the address to which data is mapped.
** code_mmap_addr + unpad_after_header == code_offset
*/
extern int		code_mmap_addr;
extern int		code_offset;

/* 
** data_offset will now be the presumed_dp address and
** data_mmap_addr will be the address to which data is mapped.
** data_mmap_addr + unpad_before_private == data_offset
*/
extern int		data_mmap_addr;
extern int		data_offset;
extern int              default_data_offset;
extern Boolean		data_on_page_after_text;

extern unsigned int	fill_pattern;
extern unsigned int	magic_number;
extern unsigned int	verbose;

extern int		O_S;
extern int		page_size;
extern int		parmcheck;
extern int		som_count;
extern int		dup_symbols;
extern int		parm_check_errs;
extern int              product_key_size; 

extern char             *cur_file_name;
extern char		*entry_name;
extern char		*output_name;

extern Boolean		align_on_if_flag;
extern Boolean		alloc_stubs_xl;
extern Boolean		alloc_stubs_ux;
extern Boolean		building_shlib;		/* shared library */
extern Boolean	        building_incomp_exec;	/* incomplete executable? */
#define compat		FALSE	/* was global flag always FALSE  */
extern Boolean		delay_aux;
extern Boolean		delay_code;
extern Boolean		delay_compunit;
extern Boolean		delay_fixup;
extern Boolean		delay_init;
extern Boolean		delay_ldrfix;
extern Boolean		delay_space;
extern Boolean		delay_spstr;
extern Boolean		delay_subsp;
extern Boolean		delay_sym;
extern Boolean		delay_symstr;
extern Boolean		dumpworthy;
extern Boolean		extern_plabels;
extern Boolean		force_common;
extern Boolean		gen_ldr_fixups;
extern Boolean		hpe_som;
extern Boolean		ipl;
extern Boolean		locality_flag;
extern Boolean		map;
extern Boolean		mapped;
extern Boolean		no_arg_reloc;
extern Boolean		no_promotion;
extern Boolean		no_stub_unwind;
extern Boolean		pri_prog_only;
extern Boolean		relocatable;
extern Boolean		save_data;
extern Boolean		save_fixups;
extern Boolean		strip_debug;
extern Boolean		strip_fixups;
extern Boolean		strip_ipl;
extern Boolean		strip_local_symbols;
extern Boolean		strip_symbols;
extern Boolean		system_som;
extern Boolean          force_ext_milli_syms;
extern Boolean          thread_private;
extern Boolean		trace_som;
extern Boolean		trap_nil_ptrs;
extern Boolean          two_pass;
extern Boolean		bad_obj;
extern Boolean		bad_fixups;
extern Boolean		relinkable;
extern Boolean		hash_qual;
extern Boolean		reset_secdef_syms;
extern Boolean 		ld_footprint_seen;
extern Boolean		no_local_search;
extern Boolean 		sharable;
extern Boolean		bypass_export_stubs;
extern Boolean          suppress_unwind;
extern Boolean          inter_binding;
extern Boolean          keep_aout;
extern Boolean          allow_shlib_unsats;
extern Boolean          dont_allow_unsats;
extern Boolean          do_private_unpadding;
extern Boolean          do_text_unpadding;
extern Boolean		do_unloadable_unpadding;

/* NO_DATA_COPY */
extern Boolean        do_data_copy;

extern Boolean          do_fdp_measure;  /* Flag to mark instrumentation */
extern Boolean          do_fdp_position; /* Flag to mark repositioning */
extern Boolean          fdp_verbose;     /* Flag for verbose fdp messages */
/* Delete unless it is a user supplied link order file */
extern Boolean          fdp_delete_link_order;

extern Boolean          count_long_branches;
extern Boolean          count_calls;
extern FILE             *fdp_link_order_file;
extern char *fdp_link_order_file_name; /* Possible quallified path + name */
extern char *fdp_output_name; /* The applications name to write to flow.data */

extern unsigned int fp_status;  /* initial value of the floating point   */
				/* status register.                      */

extern Boolean          command_file_seen;

#if defined(DEBUG) || defined(PFA)      /* if module-test active */
extern Boolean module_test; /* is runtime module-test active? */
#endif /* DEBUG || PFA */

extern int inst_page_size;    /* +Oipage= */
extern int data_page_size;    /* +Odpage= */

/* Symbol table size */
extern int symbol_table_size; /* +symboltablesize */

/* Line table version number */
#define LINE_TABLE_VERSION 1

/* Values for the O_S flag (to determine operating system aux header) */

#define	OS_HPUX		0
#define	OS_HPE		1
#define	OS_HPE_NEW	2
#if 0
#define	OS_HPOSF	3
#endif /* 0 */
#ifdef ESOM
#define OS_MPPOS        4
#endif

#ifndef _PA_RISC_ID
/* _PA_RISC_ID is defined by including magic.h, which relies on unstd.h.
*/
#define _PA_RISC_ID(__m_num)            \
     (((__m_num) == 0x20b) ||           \
      ((__m_num) >= 0x210 && (__m_num) <= _PA_RISC_MAXID))
#endif /* !_PA_RISC_ID */

/* Values for the verbose flag (bits can be individually set) */

#define V_STUBS		0x0001
#define V_TIMES		0x0002
#define V_MALLOC	0x0004
#define V_STATS		0x0008
#define V_BIGSTATS	0x0010
#define V_DEBUG		0x0020
#define V_BIGDEBUG	0x0040
#define V_WHY		0x0080
#define V_OPT		0x0100
#define V_OPT1		0x0200
#define V_EMBED		0x0400
#define V_PBO           0x0800
/* NO_DATA_COPY */
#  define V_NO_DATA_COPY   0x1000

#define V_DEAD_PROC	0x2000
#define V_SOFT_UNSATS	0x4000

#ifdef WW_ANNOTATIONS
#define V_WW_ANNOTATIONS 0x8000
#endif /* WW_ANNOTATIONS */
#ifdef TSD /* TSD */
#define V_TSD		0x10000
#endif /* TSD */
#define V_CHANGE_WARN	0x20000
#define V_DETAIL_CHANGE_WARN 0x40000
#define V_COMMONS	0x80000
#define V_DOOM          0x100000
#define V_ALL		0xffffffff
#define V_ALLSTATS	(V_STATS|V_BIGSTATS)
#define V_ALLDEBUG	(V_DEBUG|V_BIGDEBUG)

/*  Meanings of som_offset: */
/*    >= 0:  Load exactly one som at the given offset */
/*    -1:    Force load the entire file (even if a lib) */
#define FORCE_LOAD	-1

/*    -2:    Search the library */
#define SEARCH_LIB	-2

/*    -3:    Force load, but allow file equates */
/*           (for built-in files like NRT0.LIB.SYS) */
#define FORCE_LOAD_WITH_FEQ	-3

/*    -4:    Search the library, but allow file equates */
/*           (for built-in libraries like LIBCL.LIB.SYS) */
#define SEARCH_LIB_WITH_FEQ	-4

/* Absolute path for the default version of pxdb */

#ifdef V4FS
#define PXDB_PATH       "/opt/langtools/bin/pxdb"
#else /* V4FS */
#define PXDB_PATH       "/usr/bin/pxdb"
#endif /* V4FS */

/* Absolute path for the default version of FDP call graph tool */

# ifdef V4FS
#  define FDP_CALL_GRAPH_TOOL_PATH  "/usr/ccs/bin/fdp"
   /* no measure.o on 10.0+ */
# else /* V4FS */
#  define FDP_CALL_GRAPH_TOOL_PATH  "/bin/fdp"
#  define FDP_MEASUREMENT_ROUTINE_OBJECT_PATH  "/lib/measure.o"
# endif /* V4FS */

/* Directory for temporary files */
#ifdef V4FS
#define DEFAULT_TEMP_DIR	"/var/tmp"
#else /* V4FS */
#define DEFAULT_TEMP_DIR	"/tmp"
#endif /* V4FS */

/* Absolute symbol generated by linker to define PA version of executable */

#define SYSTEM_ID "__SYSTEM_ID"

/* Absolute symbol generated by linker to load into floating pt. status reg */

#define FP_STATUS "_fp_status"

/* Value of code and data_mmap_addr when they should not take the default */

#define UNSET_OFFSET  -1

/* Default value generated by linker to specify clean stack size of a.out */

#define DEFAULT_CLEAN_STACK	8192  /* 8Kbytes zero stack unless -FS used */


/* Defines for searching for libraries. */

#define EXACT_LIB_MATCH		0x0
#define SHARED_LIB_ENABLED	0x1
#define ARCHIVE_LIB_ENABLED	0x2
#define SHARED_LIB_FIRST	0x4
#define DEFAULT_LIB_SEARCH      (SHARED_LIB_ENABLED  | \
				 ARCHIVE_LIB_ENABLED | \
				 SHARED_LIB_FIRST)

#define DEFAULT_FASTBIND FALSE
#define DEFAULT_FASTBIND_UNRESOLVED FALSE
#define DEFAULT_FASTBIND_PATH "/usr/ccs/bin/fastbind"
#define HELPVIEW_PATH "/usr/dt/bin/dthelpview"
#define LINKER_HELPVIEW_VOLUME_NAME "linker"

extern Boolean	is_fastbind;
extern Boolean	is_fastbind_unresolved;

/************************* FUNCTION PROTOTYPES ****************************/

extern char *lib_name_build(char *s, int lib_select);





