/* $Header: /home/cvs/cvsroot/linker/hpux/sys/unistd.h,v 1.1 1999/10/18 22:29:44 pschwan Exp $ */


#ifndef _SYS_UNISTD_INCLUDED /* allows multiple inclusion */
#define _SYS_UNISTD_INCLUDED

/* This include is seriously abridged--we just need the CPU version
 * definitions --pschwan@thepuffingroup.com */

/*
 * unistd.h
 *
 *  HP 9000 Series 800 Linker, Copyright Hewlett-Packard Co. 1985-1999  
 *
 * Symbolic constants, structures, and function declarations
 * not belonging in any other more appropriate header.
 *
 * These support the /usr/group standard, the IEEE POSIX standards,
 * the X/Open Portability Guide, HP-UX, and other standards.
 */

#ifdef _INCLUDE_HPUX_SOURCE

/* Symbolic constants for the passwd file and group file */

#  define GF_PATH	"/etc/group"	/* Path name of the "group" file */
#  define PF_PATH	"/etc/passwd"	/* Path name of the "passwd" file */
#  define IN_PATH	"/usr/include"	/* Path name for <...> files */


/* Path on which all POSIX.2 utilities can be found */

#  define CS_PATH	  \
   "/usr/bin:/usr/ccs/bin:/opt/ansic/bin:/opt/langtools/bin:/opt/fortran/bin"

#  define CS_XBS5_ILP32_OFF32_CFLAGS		""
#  define CS_XBS5_ILP32_OFF32_LDFLAGS		""
#  define CS_XBS5_ILP32_OFF32_LIBS		""
#  define CS_XBS5_ILP32_OFF32_LINTFLAGS		""
#  define CS_XBS5_ILP32_OFFBIG_CFLAGS		"-D_FILE_OFFSET_BITS=64"
#  define CS_XBS5_ILP32_OFFBIG_LDFLAGS		""
#  define CS_XBS5_ILP32_OFFBIG_LIBS		""
#  define CS_XBS5_ILP32_OFFBIG_LINTFLAGS	"-D_FILE_OFFSET_BITS=64"
#  define CS_XBS5_LP64_OFF64_CFLAGS		"+DA2.0W"
#  define CS_XBS5_LP64_OFF64_LDFLAGS		""
#  define CS_XBS5_LP64_OFF64_LIBS		""
#  define CS_XBS5_LP64_OFF64_LINTFLAGS		""
#  define CS_XBS5_LPBIG_OFFBIG_CFLAGS		"+DA2.0W"
#  define CS_XBS5_LPBIG_OFFBIG_LDFLAGS		""
#  define CS_XBS5_LPBIG_OFFBIG_LIBS		""
#  define CS_XBS5_LPBIG_OFFBIG_LINTFLAGS	""


/* Symbolic constants for values of sysconf(_SC_SECURITY_LEVEL) */

#  define SEC_CLASS_NONE	0  /* default secure system */
#  define SEC_CLASS_C2		1  /* C2 level security */
#  define SEC_CLASS_B1		2  /* B1 level security */

/* Symbolic constants for values of sysconf(_SC_IO_TYPE) */

#  define IO_TYPE_WSIO    01
#  define IO_TYPE_SIO     02
#  define IO_TYPE_CDIO    03

/* Symbolic constants for values of sysconf(_SC_CPU_KEYBITS1) */

#define HARITH     0x00000010   /* Halfword parallel add, subtract, average */
#define HSHIFTADD  0x00000020   /* Halfword parallel shift-and-add          */

/* Symbolic constants for values of sysconf(_SC_CPU_VERSION) */
/* These are the same as the magic numbers defined in <sys/magic.h> */
/* Symbolic constants for values of sysconf(_SC_CPU_VERSION)
   do not have to be monotonic.  
   Values from 0x0210 through 0x02ff have been reserved for 
   revisions of PA-RISC */

#  define CPU_HP_MC68020  0x20C /* Motorola MC68020 */
#  define CPU_HP_MC68030  0x20D /* Motorola MC68030 */
#  define CPU_HP_MC68040  0x20E /* Motorola MC68040 */
#  define CPU_PA_RISC1_0  0x20B /* HP PA-RISC1.0 */
#  define CPU_PA_RISC1_1  0x210 /* HP PA-RISC1.1 */
#  define CPU_PA_RISC1_2  0x211 /* HP PA-RISC1.2 */
#  define CPU_PA_RISC2_0  0x214 /* HP PA-RISC2.0 */
#  define CPU_PA_RISC_MAX 0x2FF	/* Maximum value for HP PA-RISC systems */

/* Macro for detecting whether a given CPU version is an HP PA-RISC machine */

#  define CPU_IS_PA_RISC(__x)           \
       ((__x) == CPU_PA_RISC1_0 ||      \
        ((__x) >= CPU_PA_RISC1_1 && (__x) <= CPU_PA_RISC_MAX))

/* Macro for detecting whether a given CPU version is an HP MC680x0 machine */

#  define CPU_IS_HP_MC68K(__x)          \
        ((__x) == CPU_HP_MC68020 ||     \
         (__x) == CPU_HP_MC68030 ||     \
         (__x) == CPU_HP_MC68040)

#endif /* _INCLUDE_HPUX_SOURCE */

#endif /* ! _SYS_UNISTD_INCLUDED */
