/*
 *  HP 9000 Series 800 Linker, Copyright Hewlett-Packard Co. 1985-1999  
 *  Definitions for Main Program
 *
 */

#include "som/filehdr.h" /* struct header --pschwan@thepuffingroup.com */

/* A header_node is used to link aux headers and comp unit records together */

struct header_node {
	struct header_node *next;
	int size;
#ifdef CNX_TOOLS
        char  *obj_fname;           /* object file name as: library(som) */
#endif /* CNX_TOOLS */
};

extern char     	*base_file_name;
extern char		*cur_name;
extern char		*f_name;
extern char		*module_name;
extern int		cur_fildes;
extern int              cur_ofs;
extern unsigned int	som_index_this_file;  /* how many SOMs preceeded this 
						 one in the current file? */
extern int              aux_area_count;
extern int              aux_area_size;
extern int              compiler_dict_total;
extern struct header	cur_header;
extern struct header_node *aux_header_head, *aux_header_tail;
extern struct header_node *compiler_head, *compiler_tail;
extern int              dynamic_load_subsp_count;
extern int              fru_subsp_count;
extern struct stat out_file_stat;

extern int              module_seq_num;

#ifdef TSD /* TSD */
extern int		tbss_size;
#endif /* TSD */

/* HP-UX shared libraries */
extern int             shlib_version;
extern int             max_shlib_version;

extern int		linker();
extern void		som_file_add();
extern void		som_add();

extern FILE            *fdp_link_order_file;

extern int              last_subsp;           /* index of last subspace */
extern int              bss_subsp;            /* index of BSS subspace */
extern int              text_subsp;            /* index of text subspace */
extern int              data_subsp;            /* index of data subspace */

/* Values for Subspace Definitions */

#define SORT_FIRST	     0  /* sort this subspace in first slot	     */
#define SORT_DLT   	     6  /* sort at start of data to get page aligned.*/ 
#define SORT_PLT   	     7  /* sort immediately after DLT                */ 
				/* Note: room must be left for the DLDJMP    */
				/*       subspace for dld.sl                 */
#define SORT_WITH_EXEC_DATA 16  /* sort with data that appears in a.out      */
#define SORT_BSS 	    82  /* sort with data that appears in a.out      */
#define SORT_TBSS 	    40  /* sort with data that appears in a.out      */

#define CODE_QUADRANT	0
#define DATA_QUADRANT	1

#define TEXT_SORTKEY	8
#define PRIVATE_SORTKEY 16
#define DEBUG_SORTKEY	80
#define TSPECIFIC_SORTKEY 32

#define WILDCARD_ACCESS  0      /* This access rights will match all others */

/* Values for FDP symbols Definitions */

#define branch_name_string      "_LB_BRANCH_STRINGS"
#define branch_name_string_end  "_LB_BRANCH_STRINGS_END"

/* Values for special linker defined symbols */
#define S_S_ETEXT  0x0001
#define S_S_EDATA  0x0002
#define S_S_END    0x0004

extern unsigned int special_syms_added;  /* To record if syms were added */
                                         /* Uses the S_S_* macros defined
                                            above */
