/*
 *  HP 9000 Series 800 Linker, Copyright Hewlett-Packard Co. 1985-1999  
 *  Fixup Manipulation Routines
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  $Header: /home/cvs/cvsroot/linker/o2n_driver.c,v 1.1.1.1 1999/10/18 19:53:03 pschwan Exp $
 */

#include <stdio.h>
#ifdef Old2New
#include <assert.h>
#endif

#include "filehdr.h"
#include "spacehdr.h"
#include "scnhdr.h"
#include "reloc.h"
#include "syms.h"

#include "std.h"
#include "ldlimits.h"
#include "fixups.h"
#include "symbols.h"
#include "o2n_tally.h"

#ifdef Old2New

extern FILE *cur_fildes;
extern FILE *tmp;
extern int branch_table_counter;

struct space_dictionary_record    *spaces;
struct subspace_dictionary_record *subspaces;
struct symbol_dictionary_record   *symbols;
char *cur_space_strings;
char *cur_sym_strings;
int  *map_subspace;
int fixup_subsp;

#define diagnose_fixup(a,b,c)   fprintf(stderr, "%s\n", a)
#define BAD_UNWIND              ld_gets(1, 1142 "Bad unwind descriptor")
#define BAD_RECOVER             ld_gets(1, 1143, "Bad recover descriptor")
#define UNUSED_FIXUP            ld_gets(1, 1144, "Unused fixup")
#define ILLEGAL_SYM_IDX         ld_gets(1, 1145, "Illegal Symbol Index")
#define BAD_EXPR_SELECTOR       ld_gets(1, 1146, "Bad expression selector")
#define MISMATCHED_SELECTORS    ld_gets(1, 1147, "Mismatched Selectors")
#define BAD_FIELD_SELECTOR      ld_gets(1, 1148, "Bad Field Selector")
#define BAD_FMT_SELECTOR        ld_gets(1, 1149, "Bad Format Selector")

#else

#include "linker.h"
#include "ld_strings.h"
#include "spaces.h"
#include "subspaces.h"
#include "util.h"
#include "errors.h"

#define error(x)        external_error(x, NULL, NULL, NULL, NULL)

#endif

struct fixup_request_record *fixups;
extern struct header cur_header;

#ifdef Old2New

#define cur_ofs         0

/* FETCH allocates memory for a table, then reads the table */
#define FETCH(table, loc, count) { \
    table = emalloc(count * sizeof(*table)); \
    if (table == NULL) error(ld_gets(1, 1150, "no memory for table")); \
    ffetch(cur_fildes, loc, table, sizeof(*table), count);     }

#else

#define tally_with_fixup(a,b,c)         Tally_with_fixup(b,c)

/* the linker uses lseek and read */
#define fseek(f,l,o)                    lseek(f,l,o)
#define fread(d,s,n,f)                  read(f,d,(s)*(n))

static int size_procs = 0;
static int size_recovers = 0;

#endif

int dollar_global;
int milli_label;

struct proc_desc {
    int subspace;
    int symbol_value;
    int start;
    int end;
    int flags;
    int fsize;
    int frame_symbol;
    };
struct proc_desc *proc_table;
int nprocs;

struct recover_desc {
    int subspace;
    int begin_try;
    int end_try;
    int recover;
    };
struct recover_desc *recover_table;
int nrecovers;

/*
 * translate_fixups
 *
 * check the SOM header
 * read in the significant tables
 * check each table
 */

translate_fixups()
    {
    register int i;

    new_fixup_size = 0;

#ifdef Old2New
    /* read tables */
    FETCH(spaces, cur_header.space_location, cur_header.space_total);
    FETCH(subspaces, cur_header.subspace_location, cur_header.subspace_total);

    /* extra one at end is to make computation of subspace quantity easier */
    map_subspace = (int *) emalloc(sizeof(int) * (cur_header.subspace_total+1));

    FETCH(cur_space_strings, cur_header.space_strings_location,
                     cur_header.space_strings_size);
    FETCH(symbols, cur_header.symbol_location, cur_header.symbol_total);
    FETCH(cur_sym_strings, cur_header.symbol_strings_location,
                     cur_header.symbol_strings_size);
    FETCH(fixups, cur_header.fixup_request_location,
                     cur_header.fixup_request_total);

    /* KLUDGE FOR $PRIVATE$ */
    for (i = 0; i < cur_header.space_total; i++) {
        if (strcmp(& cur_space_strings [spaces[i].STR_INDEX], "$PRIVATE$") == 0)
            spaces[i].is_private = TRUE;
        }
#else
    reset_new_fixups();
#endif

    dollar_global = BAD_SYM;
    milli_label = BAD_SYM;
    read_unwind_and_recover();
    scan_subspaces();

#ifdef Old2New
    write_som();
    /* free allocated memory */
    efree(spaces);
    efree(subspaces);
    efree(cur_space_strings);
    efree(cur_sym_strings);
    efree(symbols);
    efree(fixups);
    efree(proc_table);
#endif
    }


#if 0

/* currently unused */

/*
 * validate_fixup
 */

void validate_fixup(f)
register struct fixup_request_record *f;
    {
    switch (f->expression_type) {
        case e_two:
            if (f->symbol_index_two == BAD_SYM)
	        diagnose_fixup(ILLEGAL_SYM_IDX, f, -1);
	    /* fall through to check sym index one */
        case e_one:
        case e_pcrel:
        case e_plabel:
            if (f->symbol_index_one == BAD_SYM)
	        diagnose_fixup(ILLEGAL_SYM_IDX, f, -1);
	    break;
        case e_con:
	    break;
        default:
            diagnose_fixup(BAD_EXPR_SELECTOR, f, -1);
	}
    switch (f->fixup_field) {
        case e_fsel:
            if (f->fixup_format == i_exp21)
                diagnose_fixup(MISMATCHED_SELECTORS, f, -1);
            break;
        case e_lsel:
        case e_ldsel:
        case e_lssel:
        case e_lrsel:
            if (f->fixup_format != i_exp21)
                diagnose_fixup(MISMATCHED_SELECTORS, f, -1);
            break;
        case e_rsel:
        case e_rdsel:
        case e_rssel:
        case e_rrsel:
            if (f->fixup_format != i_exp14 &&
                f->fixup_format != i_exp11 &&
                f->fixup_format != i_abs17 &&
                f->fixup_format != i_milli
               )
                diagnose_fixup(MISMATCHED_SELECTORS, f, -1);
            break;
        default:
            diagnose_fixup(BAD_FIELD_SELECTOR, f, -1);
	}
    switch (f->fixup_format) {
        case i_exp14:
        case i_exp21:
        case i_exp11:
        case i_data:
            if (f->expression_type != e_one &&
                f->expression_type != e_two &&
                f->expression_type != e_plabel
               )
                diagnose_fixup(MISMATCHED_SELECTORS, f, -1);
            break;
        case i_rel12:
        case i_rel17:
            if (f->expression_type != e_pcrel)
                diagnose_fixup(MISMATCHED_SELECTORS, f, -1);
            break;
        case i_abs17:
        case i_milli:
            if (f->expression_type != e_one  &&
                f->expression_type != e_two
               )
                diagnose_fixup(MISMATCHED_SELECTORS, f, -1);
            break;
        case i_break:
            if (f->expression_type != e_con)
                diagnose_fixup(MISMATCHED_SELECTORS, f, -1);
            break;
        default:
            diagnose_fixup(BAD_FMT_SELECTOR, f, -1);
	}
    }
#endif

/*
 * match_dollar_global
 */

char dollar_global_string[] = "$global$";

match_dollar_global(sym_index)
int sym_index;
    {
    register struct symbol_dictionary_record *sym;

    sym = & SYMBOLS(sym_index);
    if ( sym->symbol_scope != SS_LOCAL &&
         strcmp(dollar_global_string,
	        sym_str_buffer.block_ptr + sym->name.n_strx) == 0
       ) {
        dollar_global = sym_index;
        return (TRUE);
        }
    return (FALSE);
    }

/*
 * match_milli_label
 */

char milli_label_string[] = "$$tbl_ASCII";

match_milli_label(sym_index)
int sym_index;
    {
    register struct symbol_dictionary_record *sym;

    sym = & SYMBOLS(sym_index);
    if (sym->symbol_type == ST_DATA &&
        sym->symbol_scope != SS_LOCAL &&
        strcmp(milli_label_string, 
	       sym_str_buffer.block_ptr + sym->name.n_strx) == 0
       ) {
        milli_label = sym_index;
        return (TRUE);
        }
    return (FALSE);
    }

/*
 * Comparison routines for Quick Sort Purposes
 */

compare_proc(p1, p2)
struct proc_desc *p1, *p2;
    {
    if (p1->subspace != p2->subspace)
        return (p1->subspace - p2->subspace);
    if (p1->start != p2->start)
        return (p1->start - p2->start);
    /* handles case of empty regions...  TWO empty regions at SAME */
    /* location compare EQUAL (no matter the original order)       */
    /* (So they may be interchanged)                               */
    return (p1->end - p2->end);
    }

compare_recover(r1, r2)
struct recover_desc *r1, *r2;
    {
    if (r1->subspace != r2->subspace)
        return (r1->subspace - r2->subspace);
    if (r1->begin_try != r2->begin_try)
        return (r1->begin_try - r2->begin_try);
    /* handles case of empty regions...  TWO empty regions at SAME */
    /* location compare EQUAL (no matter the original order)       */
    /* (So they may be interchanged)                               */
    return (r1->end_try - r2->end_try);
    }

/*
 * read_unwind_and_recover
 *
 */

read_unwind_and_recover()
    {
    int i, start;
    long pos;
    struct space_dictionary_record *sp;
    struct subspace_dictionary_record *subsp;
    struct symbol_dictionary_record *sym;
    struct fixup_request_record *fixup;
    struct fixup_request_record *last_fixup;
    struct proc_desc *procent;
    struct recover_desc *rec_ent;

#define MAX_SYM_INDEX 0xFFFFFFFF	/* test value for first iteration */
    unsigned int last_sym1_index;  /* index of 1st sym in 1st fixup in 
					 last subspace read */
    int skipped_unwind_procs;      /* number of procedures skipped on input */
	/* used to eliminate duplicate unwind areas caused by cc -S | as in
	    */

#ifdef Old2New
    int    new_subspace_knt = 0;
    struct udesc udesc;
#define UDESC (&udesc)
#else
    static char *Udesc = NULL;
    static int Udesc_size = 0;
#define UDESC ((struct udesc *)&Udesc[pos])
#endif

    /* count unwind descriptors */
    nprocs = 0;
    nrecovers = 0;
    last_sym1_index = MAX_SYM_INDEX; /* unlikely test value for 1st iteration */
    skipped_unwind_procs = 0;

    for (i = 0; i < cur_header.subspace_total; i++) {
        subsp = & SUBSPACES(i);
#ifdef Old2New
        map_subspace[i] = -1;
#endif
        /* check to see if we are in UNWIND or RECOVER */
        /* used to be a STRING comparison (UGGH)       */
        /* but now use flags & sort keys               */

        sp = & SPACES(subsp->space_index);
        if (sp->is_loadable &&          /* $TEXT$ */
            !sp->is_private &&
            subsp->sort_key >= UNWIND_SORT &&
            subsp->sort_key <= UNWIND_SORT_END
           )
            nprocs += subsp->subspace_length / sizeof(struct udesc);
        else if (sp->is_loadable &&     /* $TEXT$ */
            !sp->is_private &&
            subsp->sort_key >= RECOVER_SORT &&
            subsp->sort_key <= RECOVER_SORT_END
           )
            nrecovers += subsp->subspace_length / sizeof(struct rdesc);
#ifdef Old2New
        else
            map_subspace[i] = new_subspace_knt++;
#endif
        }

#ifdef Old2New

    /* fill in last guy at the end */
    map_subspace[cur_header.subspace_total] = new_subspace_knt;

    proc_table = emalloc((nprocs+1) * sizeof(struct proc_desc));
    if (proc_table == NULL)
        error(ld_gets(1, 1151, "no memory for proc_table"));
    recover_table = emalloc((nrecovers+1) * sizeof(struct recover_desc));
    if (recover_table == NULL)
        error(ld_gets(1, 1152, "no memory for recover_table"));

#else

    fixups = old_fixup_area;

    if (nprocs >= size_procs) {
        if (proc_table != NULL)
            efree(proc_table);
        size_procs = (nprocs+1);
        size_procs += size_procs / 4;
        proc_table = (struct proc_desc *)
		     emalloc (size_procs * sizeof (struct proc_desc));
        }

    if (nrecovers >= size_recovers) {
        if (recover_table != NULL)
            efree(recover_table);
        size_recovers = (nrecovers+1);
        size_recovers += size_recovers / 4;
        recover_table = (struct recover_desc *)
			emalloc (size_recovers * sizeof (struct recover_desc));
        }

#endif

    procent = proc_table;
    rec_ent = recover_table;

    /* collect unwind descriptors and build procedure table */
    for (i = 0; i < cur_header.subspace_total; i++) {
        subsp = & SUBSPACES(i);
        sp = & SPACES(subsp->space_index);
        if (sp->is_loadable &&          /* $TEXT$ */
            !sp->is_private &&
            subsp->sort_key >= UNWIND_SORT &&
            subsp->sort_key <= UNWIND_SORT_END) {

	    /* Going to be doing raw i/o, so clear the fdump buffer */
	    flush_fdump_buffer();

	    /*  Handle UNWIND subspaces */
            fseek(cur_fildes, cur_ofs + subsp->file_loc_init_value, 0);
#ifndef Old2New
            /* buffer */
            if (subsp->initialization_length > Udesc_size) {
                if (Udesc != NULL)
                    efree(Udesc);
                Udesc_size = subsp->initialization_length;
                Udesc_size += Udesc_size / 4;
                Udesc = emalloc(Udesc_size);
            }
            fread(Udesc, subsp->initialization_length, 1, cur_fildes);
	    /* Clear remembered filofs since we used read() directly */
            clear_oldfilofs();
#endif
            fixup = &fixups[subsp->fixup_request_index];
            last_fixup = &fixup[subsp->fixup_request_quantity];

	    if (subsp->fixup_request_quantity > 0)  /* ignore no-fixup cases */
	        if (fixup->symbol_index_one == last_sym1_index) {
		    skipped_unwind_procs += (subsp->subspace_length / 
					        sizeof(struct udesc));
		    continue;  /* skip this subspace as a duplicate of its
				    predecessor */
 	        } else
		    /* normal case */
		    last_sym1_index  = fixup->symbol_index_one; 
            for (pos = 0;
                 pos < subsp->initialization_length;
                 pos += sizeof(struct udesc)) {
                if (fixup->subspace_offset != pos ||
                     fixup[1].subspace_offset != pos+WORDSIZE ||
                     fixup->expression_type != e_one ||
                     fixup[1].expression_type != e_one ||
                     fixup->fixup_format != i_data ||
                     fixup[1].fixup_format != i_data ||
                     fixup->fixup_field != e_fsel ||
                     fixup[1].fixup_field != e_fsel ||
                     fixup->symbol_index_one != fixup[1].symbol_index_one) {
                    error(BAD_UNWIND);
                }
#ifdef Old2New
                fread(UDESC, sizeof(struct udesc), 1, cur_fildes);
#endif
                sym = & SYMBOLS(fixup->symbol_index_one);
                procent->subspace = sym->symbol_info;
                procent->symbol_value = sym->symbol_value;
                procent->start = (procent->symbol_value &~ CLEAR_SYM_XL) -
                                  SUBSPACES(sym->symbol_info).subspace_start +
                                  fixup->fixup_constant;
                procent->end = procent->start + fixup[1].fixup_constant -
                                  fixup->fixup_constant;
                procent->flags = UDESC->flags;
                procent->fsize = UDESC->fsize;
                fixup += 2;
                if (fixup < last_fixup &&
                    fixup->subspace_offset == pos+3*WORDSIZE) {
                    if (fixup->expression_type != e_one ||
                        fixup->fixup_format != i_data ||
                        fixup->fixup_field != e_fsel) {
                        error(BAD_UNWIND);
                    }
                    procent->frame_symbol = fixup->symbol_index_one;
                    fixup++;
                } else
                    procent->frame_symbol = BAD_SYM;
                procent++;
            }
            if (fixup != last_fixup)
                fprintf(stderr,ld_gets(1, 1153, "fixup count mismatch\n"));
        } else if (sp->is_loadable &&     /* $TEXT$ */
            !sp->is_private &&
            subsp->sort_key >= RECOVER_SORT &&
            subsp->sort_key <= RECOVER_SORT_END) {
	    /*  Handle RECOVER subspaces */
            fixup = &fixups[subsp->fixup_request_index];
            last_fixup = &fixup[subsp->fixup_request_quantity];
            for (pos = 0;
                 pos < subsp->initialization_length;
                 pos += sizeof(struct rdesc)) {
                if (fixup->subspace_offset != pos ||
                     fixup[1].subspace_offset != pos+WORDSIZE ||
                     fixup[2].subspace_offset != pos+2*WORDSIZE ||
                     fixup->expression_type != e_one ||
                     fixup[1].expression_type != e_one ||
                     fixup[2].expression_type != e_one ||
                     fixup->fixup_format != i_data ||
                     fixup[1].fixup_format != i_data ||
                     fixup[2].fixup_format != i_data ||
                     fixup->fixup_field != e_fsel ||
                     fixup[1].fixup_field != e_fsel ||
                     fixup[2].fixup_field != e_fsel) {
                    error(BAD_RECOVER);
                }
                sym = & SYMBOLS(fixup->symbol_index_one);
                rec_ent->subspace = sym->symbol_info;
                start = SUBSPACES(rec_ent->subspace).subspace_start;
                rec_ent->begin_try =
                        (sym->symbol_value &~ CLEAR_SYM_XL) -
                        start +
                        fixup->fixup_constant;
                fixup++;
                sym = & SYMBOLS(fixup->symbol_index_one);
                if (rec_ent->subspace != sym->symbol_info)
                    error(BAD_RECOVER);
                rec_ent->end_try =
                        (sym->symbol_value &~ CLEAR_SYM_XL) -
                        start +
                        fixup->fixup_constant;
                fixup++;
                sym = & SYMBOLS(fixup->symbol_index_one);
                if (rec_ent->subspace != sym->symbol_info)
                    error(BAD_RECOVER);
                rec_ent->recover =
                        (sym->symbol_value &~ CLEAR_SYM_XL) -
                        start +
                        fixup->fixup_constant;
                fixup++;
                if (rec_ent->begin_try != rec_ent->end_try)
                    /* bump up pointer */
                    rec_ent++;
                else {
                    nrecovers--;
                }
            }
            if (fixup != last_fixup)
                fprintf(stderr, ld_gets(1, 1154, "fixup count mismatch\n"));
        }
    }
    /* dummy last entry in proc table indexes past last subspace number */
    procent->subspace = cur_header.subspace_total;
    rec_ent->subspace = cur_header.subspace_total;

    qsort(proc_table, (nprocs - skipped_unwind_procs), sizeof(*proc_table), 
							    compare_proc);
    qsort(recover_table, nrecovers, sizeof(*recover_table), compare_recover);
} /* end read_unwind_and_recover */

scan_subspaces()
{
    int i, in_code, in_proc, was_in_proc, flag;
    unsigned int va;
    struct proc_desc *procent;
    struct recover_desc *rec_ent;
    struct space_dictionary_record *sp;
    struct subspace_dictionary_record *subsp;
    struct fixup_request_record *fixup, *last_fixup;
    int start_loc;
    int exec_level;
    char buf[10];  /* Conversion buffer for int args to "internal_error" */


#ifdef Old2New
    /* only read in the data and write it to the tmp file when doing Old2New */
    char *data;
    int code_not_in_proc = 0;

    tmp = tmpfile();
#endif

    procent = proc_table;
    rec_ent = recover_table;
    exec_level = -1;

    for (i = 0; i < cur_header.subspace_total; i++) {
#ifdef Old2New
        fixup_subsp = i;        /* R_RELOCATION needs this */
#endif
        subsp = & SUBSPACES(i);
        sp = & SPACES(subsp->space_index);
        if (sp->is_loadable &&          /* $TEXT$ */
            !sp->is_private &&
            subsp->sort_key >= UNWIND_SORT &&
            subsp->sort_key <= RECOVER_SORT_END) {
#ifndef Old2New
            /* ZAP THESE SUBSPACES */
            subsp->subspace_length = 0;
            subsp->fixup_request_index = 0;
            subsp->fixup_request_quantity = 0;
            subsp->initialization_length = 0;
            /* don't zap subspace_start field since we still need it! */
#endif
            continue;
        }
        override_mode = R_N_MODE;
        if (subsp->space_index > 0 ||
             prefix("$LIT", space_str_buffer.block_ptr + subsp->name.n_strx))
            in_code = FALSE;
        else
            in_code = TRUE;

#ifdef Old2New
        /* only worry about the last few fixups in Old2New */
        clear_PUT_table();
#endif

        fixup = &fixups[subsp->fixup_request_index];
        last_fixup = &fixup[subsp->fixup_request_quantity];

        /* the new fixup index is set here */
        subsp->fixup_request_index = new_fixup_size;

#ifdef Old2New
        assert(procent->subspace >= i);
        assert(rec_ent->subspace >= i);
#else
	if (procent->subspace < i || rec_ent->subspace < i) {
	    sprintf(buf, "%d", i);
	    internal_error(MISCOUNTED_UNW_REC, cur_name, buf, 0);
        }
#endif

        if (subsp->initialization_length == 0) {
            if (subsp->subspace_length > 0) {
		if (subsp->file_loc_init_value == 0) {
		    /* DON'T */
		    /* make an R_UNINIT fixup */
		    /* make_run_fixup(R_UNINIT, subsp->subspace_length); */
		} else { 
		    /* make an R_REPEATED_INIT fixup */
		    /* (use an R_DATA_OVERRIDE for the pattern) */
		    start_fixup();
		    PUT_8(R_DATA_OVERRIDE+4);
		    PUT_32(subsp->file_loc_init_value);
		    make_repeat_fixup(WORDSIZE, subsp->subspace_length);
	        }
            }
        }
	else if (subsp->subspace_length > subsp->initialization_length &&
			subsp->replicate_init) {
	    subsp->replicate_init = FALSE;
	    make_repeat_fixup(subsp->initialization_length,
					subsp->subspace_length);
	} else /* (subsp->initialization_length > 0) */ {
#ifdef Old2New
            /* only read in data when doing Old2New */
            data = emalloc(subsp->initialization_length);
            if (data == NULL)
                error(ld_gets(1, 1155, "no memory for subspace data"));

            ffetch(cur_fildes, subsp->file_loc_init_value, 
		  data, 1, subsp->initialization_length);

            subsp->file_loc_init_value = ftell(tmp);
#else
            /* when in the linker, flag this as a translated file */
            make_simple_fixup(R_TRANSLATED);
#endif
            was_in_proc = FALSE;

            for (va = 0; va < subsp->initialization_length; va += WORDSIZE) {
                if (procent->subspace == i &&
                     procent->start <= va &&
                     procent->end >= va)
                    in_proc = TRUE;
                else {
                    in_proc = FALSE;
                    if (was_in_proc) {
                        /* start a hole in between procedures */
                        make_simple_fixup(R_EXIT);
                    }
                }

#ifdef Old2New
                /* we must handle these cases anyway! */
                if (in_code && !in_proc)
                    code_not_in_proc++;
                else if (in_proc && !in_code)
                    error(ld_gets(1, 1156, "item in procedure not code"));
#endif

                if (in_proc && procent->start == va) {
#ifdef Old2New
                    /* punt, if we aren't Old2New and just do the PROC */
                    if (! was_in_proc ||
                        procent[-1].symbol_value != procent->symbol_value ||
                        procent[-1].fsize != procent->fsize ||
                        procent[-1].frame_symbol != procent->frame_symbol ||
                        (procent[-1].flags &~ REGION_MASK) !=
                                (procent->flags &~ REGION_MASK))
                        /* note that you do not have to check that the
                           previous region abuts the current region,
                           if was_in_proc is TRUE!
                         */
#endif
                        {
			exec_level = procent->symbol_value & 03;
                        make_proc_fixup(procent->flags,
                                        procent->fsize,
                                        procent->frame_symbol,
					exec_level);
                    }
                    if (procent->flags & NOT_ENTRY)
                        /* no entry code */
                        make_simple_fixup(R_EXIT);
#ifdef Old2New
                    else
                        /* only if Old2New do we get alternate entry points */
                        /* otherwise, they look like full procedure entries */
                        /* and make_proc_fixup is always called             */
                        make_simple_fixup(R_ALT_ENTRY);
#endif
                    }

                /* IMPORTANT to do the END-TRY first, before the BEGIN-TRY */
                if (rec_ent->subspace == i && rec_ent->end_try == va) {
                    make_end_try_fixup(rec_ent->recover-rec_ent->end_try);
                    rec_ent++;
                }
                /* MUST test the subspace again, since rec_ent might change */
                if (rec_ent->subspace == i && rec_ent->begin_try == va)
                    make_simple_fixup(R_BEGIN_TRY);

                if (fixup < last_fixup && fixup->subspace_offset < va)
                    error(UNUSED_FIXUP);

#ifdef Old2New
                /* only worry about branch tables in Old2New */
                if (branch_table_counter != 0)
                    {
                    branch_table_counter++;
                    if ((branch_table_counter & 1) &&
                        ! found_branch_pair(&data[va])) {
                        make_simple_fixup(R_END_BRTAB);
                        branch_table_counter = 0;
                    }
                }
#endif

                if (fixup < last_fixup && fixup->subspace_offset == va)
                    tally_with_fixup(*(int *)&data[va], fixup++, exec_level);
                else
#ifdef Old2New
                    tally_no_fixup(*(int *)&data[va], in_proc);
#else
                    add_run(R_NO_RELOCATION);
#endif

                if (in_proc && procent->end == va) {
                    if (procent->flags & NOT_EXIT)
                        make_simple_fixup(R_ALT_ENTRY);
                    else
                        make_simple_fixup(R_EXIT);
                    procent++;
                }

                was_in_proc = in_proc;
            }

            if (was_in_proc) {
                /* at end of code subspace, so act as if there is a hole */
                make_simple_fixup(R_EXIT);
            }
	    if (subsp->subspace_length > subsp->initialization_length) {
		make_run_fixup(R_UNINIT,
		    subsp->subspace_length - subsp->initialization_length);
            }
            start_fixup();
#ifdef Old2New
            subsp->initialization_length = ftell(tmp) -
                                           subsp->file_loc_init_value;
            efree(data);
#endif
        }
        start_fixup();
        subsp->fixup_request_quantity =
                new_fixup_size - subsp->fixup_request_index;
    }
#ifdef Old2New
    if (code_not_in_proc != 0)
        fprintf(stderr, 
		ld_gets(1, 
			1157, 
			"%d code words not in procedure\n"), 
		code_not_in_proc);
    assert(procent->subspace == cur_header.subspace_total);
    assert(rec_ent->subspace == cur_header.subspace_total);
#else
    if (procent->subspace != cur_header.subspace_total ||
	    rec_ent->subspace != cur_header.subspace_total)  {
	sprintf(buf, "%d", cur_header.subspace_total);
	internal_error(MISCOUNTED_UNW_REC, cur_name, buf, 0);
    }
#endif
} /* end scan_subspaces */
