/* @(#) $Revision: 1.1.1.1 $ */

#ifndef		_DL_INCLUDED
#define		_DL_INCLUDED

#ifdef __cplusplus
extern "C" {
#endif

#ifdef 		__hp9000s800

/*
 *  HP 9000 Series 800 Linker, Copyright Hewlett-Packard Co. 1985-1999  
 *
 *	dl.h
 *
 *	declarations and definitions for users
 *
 */


#include <sys/param.h>

typedef struct mapped_shl_entry *shl_t;

#define BIND_IMMEDIATE  0x0
#define BIND_DEFERRED   0x1
#define BIND_REFERENCE  0x2

#define BIND_FIRST	0x4
#define BIND_NONFATAL   0x8
#define BIND_NOSTART	0x10
#define BIND_VERBOSE	0x20
#define BIND_RESTRICTED	0x40  

/* #define BIND_RESERVED1	0x80  Reserve this bit for sharing between */
/* 			              shl_load() and shlib_list_entry{}    */

#define DYNAMIC_PATH	0x100
#define BIND_TOGETHER	0x200
#if defined(__LP64__) || defined(__IA64__) || defined(__COMPAT_LIBDLD__)
#define BIND_BREADTH_FIRST	0x400	/* Load dependents in breadth first
					   load order */
#endif

#define TYPE_UNDEFINED	0
#define TYPE_PROCEDURE	3
#define TYPE_DATA	2
#define TYPE_STORAGE	7
#define TYPE_TSTORAGE   16

#define IMPORT_SYMBOLS	0x1
#define EXPORT_SYMBOLS  0x2

#define NO_VALUES	0x4
#define GLOBAL_VALUES   0x8

#define INITIALIZERS	0x10

#if defined(__LP64__) || defined(__IA64__) || defined(__COMPAT_LIBDLD__)
#define PROG_HANDLE ((shl_t) (-1L))
extern void* __text_start;
#else
extern int __text_start;
#define	 PROG_HANDLE	((shl_t)(&__text_start))
#endif

#if !(defined(__LP64__) || defined(__IA64__) || defined(__COMPAT_LIBDLD__))
/* Offsets into dldjmp table (__dld_loc) for the user-visible dld routines */
#define SHL_INIT   	0	
#define SHL_LOAD   	4
#define SHL_UNLOAD	8
#define SHL_FINDSYM	12
#define SHL_BOR		16
#define SHL_GET		20
#define SHL_TERM	24
#define SHL_GETHANDLE	28
#define SHL_DEFINESYM   32
#define SHL_GETSYMBOLS  36
#define SHL_GET_R       40
#define SHL_GETHANDLE_R 44
#endif /* !defined(__LP64__) && !defined(__IA64__) && !defined(__COMPAT_LIBDLD__)*/

#define NO_INITIALIZER 	((void *)(0))

/* Version number of the shl_descriptor structure. */
#define SHL_D_UX10 1

struct shl_descriptor {
	unsigned long tstart;
	unsigned long tend;
	unsigned long dstart;
	unsigned long dend;
	void         *ltptr;
	shl_t	      handle;
	char filename[MAXPATHLEN+1];
	void         *initializer;
	unsigned long ref_count;
	unsigned long reserved3;
	unsigned long reserved2;
	unsigned long reserved1;
	unsigned long reserved0;
};

struct shl_symbol {
        char 	       *name;
        short 		type;
        void  	       *value;
        shl_t 		handle;
};

#pragma HP_DEFINED_EXTERNAL	shl_load
#pragma HP_DEFINED_EXTERNAL	shl_unload
#pragma HP_DEFINED_EXTERNAL	shl_findsym
#pragma HP_DEFINED_EXTERNAL	shl_get
#pragma HP_DEFINED_EXTERNAL	shl_gethandle
#pragma HP_DEFINED_EXTERNAL	shl_definesym
#pragma HP_DEFINED_EXTERNAL	shl_getsymbols
#pragma HP_DEFINED_EXTERNAL	shl_get_r
#pragma HP_DEFINED_EXTERNAL	shl_gethandle_r
				
#if defined(__STDC__) || defined(__cplusplus)
#if defined(__LP64__) || defined(__IA64__) || defined(__COMPAT_LIBDLD__)
extern shl_t shl_load (const char *path, int flags, ... /* long address */);
#else
extern shl_t shl_load (const char *path, int flags, long address);
#endif
extern int shl_findsym (shl_t *handle, const char *sym, short type,void *value);
extern int shl_unload (shl_t handle);
extern int shl_get (int index, struct shl_descriptor **desc);
extern int shl_gethandle (shl_t handle, struct shl_descriptor **desc);
extern int shl_definesym (const char *sym, short type, long value, int flags);
extern int shl_getsymbols (shl_t handle, short type, int flags, 
			   void *(*memory)(), struct shl_symbol **symbols); 
extern int shl_get_r (int index, struct shl_descriptor *desc);
extern int shl_gethandle_r (shl_t handle, struct shl_descriptor *desc);
#else
extern shl_t shl_load ();
extern int shl_findsym ();
extern int shl_definesym ();
extern int shl_unload ();
extern int shl_get ();
extern int shl_gethandle ();
extern int shl_getsymbols ();
extern int shl_get_r ();
extern int shl_gethandle_r ();
#endif

#endif		/* __hp9000s800 */

#ifdef __cplusplus
}
#endif
#endif		/* _DL_INCLUDED */
