/*
 *  HP 9000 Series 800 Linker, Copyright Hewlett-Packard Co. 1985-1999  
 *  Stubs Manipulation Routines
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  $Header: /home/cvs/cvsroot/linker/stubs.c,v 1.1.1.1 1999/10/18 19:53:03 pschwan Exp $
 */

#include <string.h>
#include <stdio.h>
#include <sys/types.h>
#include <sys/param.h>
#include <sys/times.h>

#ifndef DEBUG
#define NDEBUG
#endif  /* !DEBUG */
#include <assert.h>

#include "aouthdr.h"
#include "scnhdr.h"
#include "spacehdr.h"
#include "reloc.h"
#include "syms.h"

#include "std.h"
#include "driver.h"
#include "errors.h"
#include "fixups.h"
#include "libraries.h"
#include "ldlimits.h"
#include "linker.h"
#include "stubs.h"
#include "stub_inst.h"
#include "spaces.h"
#include "subspaces.h"
#include "symbols.h"
#include "util.h"
#ifdef WW_ANNOTATIONS
#include "annotate.h"
#endif /* WW_ANNOTATIONS */

/* Parameter relocation descriptors */
#define	NO_CHECK        0
#define	ARG	        1
#define	FARG	        2
#define	FARGU	        3

#define COMBINE(caller,callee) (((caller)<<2)|(callee))

/* Parameter relocation instruction sequences */
#define ARG0_FARG0	1
#define ARG1_FARG1	(ARG0_FARG0+1)
#define ARG2_FARG2	(ARG0_FARG0+2)
#define ARG3_FARG3	(ARG0_FARG0+3)
#define FARG0_ARG0	5
#define FARG1_ARG1	(FARG0_ARG0+1)
#define FARG2_ARG2	(FARG0_ARG0+2)
#define FARG3_ARG3	(FARG0_ARG0+3)
#define ARG01_FARG1	9
#define ARG23_FARG3	(ARG01_FARG1+2)
#define FARG1_ARG01	13
#define FARG3_ARG23	(FARG1_ARG01+2)

/* Return relocation instruction sequences */
#define RET0_FRET0	1
#define FRET0_RET0	2
#define RET01_FRET0	3
#define FRET0_RET01	4

#define RELOC_ERROR	(-1)

#define	LB_STUB_SIZE	8
#define	SHL_LB_STUB_SIZE	16
#define	IQ_STUB_SIZE	20
#define	DL_STUB_SIZE	24

#define	PA2_0_EXPORT_STUB_SIZE		16
#define	PA2_0_IMPORT_STUB_SIZE		20
#define	PA2_0_IMPORT_STUB_SIZE_NO_RP	16
#define	HPUX_EXPORT_STUB_SIZE		24
#define	HPUX_EXPORT_STUB_SIZE_NO_RP	8  /* Only BL to entry & NOP */
#define	HPUX_IMPORT_STUB_SIZE		28
#define	HPUX_IMPORT_STUB_SIZE_NO_RP	24 /* No STW rp, -24(0,sp)   */

#define	FDP_STUB_SIZE	24
#define	SHL_FDP_STUB_SIZE	40

/* When the offset of the next stub to be added is within BL_PAD_SIZE of
** the limit of the reach of a BL instruction from misc->check_bl_stub_offset,
** we convert the misc->check_bl_stub stub to go through a long branch stub
** while we can still guarantee that we can reach the long branch stub.  
** The pad space needs to be large enough to hold a maximum size stub 
** plus the long branch stub for all the stubs that have to be fixed 
** after the maximum size stub is added plus the stubs that have to be 
** fixed because of the long branch stubs we added... 
**
** Since a long branch stub uses 2 words and the shortest BL stub uses 3
** words, we reduce the problem by at leasst 1 word for each long branch
** stub we create.  Since the longest possible stub is under 22 words,
** we need to have enough space for the 22 word stub followed by 22 long
** branch stubs.  22 + 2*22 words = 264 bytes.  We round up to 300.
**
*/

#define BL_PAD_SIZE     300

/* Globals */

struct stub_record **_stubs = NULL;
int    stubs_size = 0;
int    stubs_max = STUBS_MAX;
int    log_stubs_max = 0;
int    mask_stubs_max = 0;
int    stub_segs = 0;
int    stub_segs_max = MAX_SEGS;
int    stub_area_max = STUB_AREA_MAX;
int    next_xrt = 1;
int    sr4export_sym;   /* set in fixups.c */
char   sr4export_string[] = "_sr4export";

extern struct symbol_record null_symbol_record; 
extern int    dyncall_external; 

int    branch_counter_sym;      /* set in fixups.c */
/* 
** This symbol is used to keep track of the fdp strings subspaces
** it is set in linker.c
*/
static char   	    *fdp_names = NULL;  /* Area to write fdp strings */
static unsigned int fdp_names_size = 0; /* FDP string area size */

extern int  dollar_global; /* really should be and o2n_driver.h */
/* first pass through relocate_subspaces this is true */
extern int  first_time;  

/* Locals */

int 		*stub_area = NULL;
int    stub_limit = 0;
Boolean more_stubs;

/* Forwards */

struct stub_record *stub_add();
void get_stub_info();
int *spit_arg_reloc_code();
int *spit_rtn_reloc_code();
static int import_stub_needed(int, Boolean);

/* Macros */

#define FDP_COUNTING_STUB_POSSIBLE (count_calls)

#define PROMOTION_STUB_POSSIBLE (alloc_stubs_xl && !no_promotion)

/* macro to test if a symbol type is one that it makes sense to call */
#define IS_CALLABLE(type) ( (type == ST_ENTRY ||		\
      		 	     type == ST_CODE ||			\
      		 	     type == ST_PRI_PROG ||	\
      		 	     type == ST_SEC_PROG ||	\
      		 	     IS_STUB(type)) )

/*##################### Functions and Subroutines ##########################*/


void stubs_initialize()
{
    int seg_size;

    stubs_size = 0;
    next_xrt = 1;

    if (_stubs == NULL) {

        /* allocate stubs table segment pointers */
        _stubs = (struct stub_record **) emalloc(stub_segs_max *
			sizeof(struct stub_record *));

        /* round stubs_max to next power of two; find log and mask */
        log_stubs_max = 0;
        for (seg_size = 1; seg_size < stubs_max; seg_size <<= 1)
	    log_stubs_max++;
        stubs_max = seg_size;
        mask_stubs_max = seg_size - 1;

    }

    if (stub_area == NULL)
        stub_area = (int *) emalloc(stub_area_max);
} /* end stubs_initialize */

/*************************************************************
** FUNCTION:	use_lb_stub
**
** DESCRIPTION:	A stub, like an export stub, needs to be modified to use
**		a long branch stub.  This is accomplished by setting
**		stub->stub_constant to the offset between the BL and the
**		long branch stub and setting stub->stub_symbol to
**		BAD_SYM.
**
** PARAMETERS:
**		unconditionally	TRUE if the stub should be fixed regardless
**				of the offset calculation.  TRUE for
**				fix_bl_stub, FALSE for long_reach_stubs_added.
**		misc		The subspace containing the stub.
**		stub_record	The stub to be fixed up.
**
** NOTES:	Extracted from long_reach_stubs_added in the process of
*************************************************************/

void use_lb_stub(Boolean 			unconditionally,
		 struct subsp_misc_record 	*misc, 
		 struct stub_record  		*stub)
{
    int			fixup_offset;
    int			offset;
    int			sym_index;

    sym_index = stub->stub_symbol;

    /* if HP-UX shared libraries */
    if ((sym_index != BAD_SYM) && (stub->type == HPUX_EXPORT_STUB)) {
	sym_index = find_orig_sym(sym_index);
    }

    if (sym_index != BAD_SYM) {
	/* check to see if this branch is out of reach. */
	fixup_offset = stub->subsp_off +
		       stub->arg_reloc_size +
		       2*WORDSIZE;
	if (stub->type == LOCAL_RELOC_STUB &&
		    stub->rtn_reloc_size > 0)
	    fixup_offset += WORDSIZE;

	offset = symbol_value(sym_index) -
	     (misc->new_subspace_start + fixup_offset);

	if (unconditionally || OFL(offset, 19)) {
	    stub->stub_constant =
		bld_lb_stub_rec(sym_index, 0) - fixup_offset;
	    stub->stub_symbol = BAD_SYM;
	}
    }
} /* end use_lb_stub */

/*************************************************************
** FUNCTION:	fix_bl_stub
**
** DESCRIPTION:	Make sure that a stub which uses a BL to get to its
**		destination can at least get to a long branch stub.
**		When the difference between the stub offset and 
**		misc->next_stub_offset approaches the limit of a BL, we 
**		allocate a long branch stub and fix the bl stub to go to the
** 		long branch stub.  
**
**		The value of misc->check_bl_stub falls into one of three cases:
**		    1. NULL	Find the first BL stub and see if it needs
**				to be fixed.
**		    2. Points to a BL stub
**				See if this BL stub needs to be fixed
**		    3. Points to a stub which is not a BL stub:
**				Find the next BL stub and see if it needs
**				to be fixed.
**		If misc->check_bl_stub does not point at a BL stub,
**		misc->check_bl_stub_offset is guaranteed to be less than
**		or equal to the offset of the next BL stub to be fixed.
**		If misc->check_bl_stub points at a BL stub, the value is
**		exact.
**
**
** NOTES:	Note that if check_bl_stub is not pointing at a BL stub,
**		we may not need to fix the next BL stub once we find out 
**		where it is.
**		
**       	We need to update check_bl_stub and check_bl_stub_offset
**		before we call bld_lb_stub_rec to keep stub_add from infinitely
**		calling fix_bl_stub again when bld_lb_stub_rec calls stub_add.
**
*************************************************************/

void fix_bl_stub(struct subsp_misc_record *misc)
{
    struct stub_record 	*fix_stub;
    struct stub_record 	*stub_ptr;

    while (OFL(  misc->next_stub_offset 
	       - misc->check_bl_stub_offset 
	       + BL_PAD_SIZE,
               19))
    {
	if (misc->check_bl_stub == NULL || !IS_BL_STUB(misc->check_bl_stub)) {
	    /* Find the next stub which uses a BL */
	    for (stub_ptr = misc->check_bl_stub == NULL ? 
				    misc->stub_list :
				    misc->check_bl_stub->next_stub;
		 stub_ptr != NULL && !IS_BL_STUB(stub_ptr);
		 stub_ptr = stub_ptr->next_stub);
	         /* traverse list to end or until BL stub is found */
	    if (stub_ptr == NULL) {
		/* 
		** No stub to fix.  Check against offset of last stub in the
		** future.  Also, pick up the search with the last stub.
		*/
		misc->check_bl_stub = misc->stub_tail;
		misc->check_bl_stub_offset = misc->stub_tail->subsp_off;
		return;
	    }
	    misc->check_bl_stub = stub_ptr;
	    misc->check_bl_stub_offset = stub_ptr->subsp_off;
	    if (!OFL(  misc->next_stub_offset 
		     - misc->check_bl_stub_offset 
		     + BL_PAD_SIZE,
		     19))
 	        return;  /* we haven't hit the limit yet. */
	}
	fix_stub = misc->check_bl_stub;

	/* set the new misc->check_bl_stub */
	for (stub_ptr = misc->check_bl_stub->next_stub;  
	     stub_ptr != NULL && !IS_BL_STUB(stub_ptr);
	     stub_ptr = stub_ptr->next_stub);
	     /* traverse list to end or until BL stub is found */
	misc->check_bl_stub = stub_ptr;
	if (stub_ptr != NULL)
	    misc->check_bl_stub = stub_ptr;
	else
	    misc->check_bl_stub = misc->stub_tail;
	misc->check_bl_stub_offset = misc->check_bl_stub->subsp_off;

	/* Now fix the stub in question to go through a long branch stub. */

	use_lb_stub(TRUE, misc, fix_stub);
    } /* end while */
} /* end fix_bl_stub */

struct stub_record *stub_add(misc)
struct subsp_misc_record *misc;
{
    int index, seg, off;
    struct stub_record *stub, *tail;

    if(pcx_u_pa2_0){
       if (OFL(misc->next_stub_offset - misc->check_bl_stub_offset 
					+ BL_PAD_SIZE, 24)) {
	   /* Convert a stub which uses BL to branch to a long branch stub */
	   fix_bl_stub(misc);
	}
    }
    else{
       if (OFL(misc->next_stub_offset - misc->check_bl_stub_offset 
					+ BL_PAD_SIZE, 19)) {
	   /* Convert a stub which uses BL to branch to a long branch stub */
	   fix_bl_stub(misc);
       }
    }
    more_stubs = TRUE;

    index = stubs_size++;
    seg = Stub_Seg(index);
    off = Stub_Off(index);
    if (seg >= stub_segs) {
        if (seg >= stub_segs_max) {
	    stub_segs_max += MAX_SEGS;
	    _stubs = (struct stub_record **) erealloc((char *) _stubs,
		    stub_segs_max * sizeof(struct stub_record *));
	}
        _stubs[seg] = (struct stub_record *)
		emalloc(stubs_max * sizeof(struct stub_record));
        stub_segs++;
    }

    stub = &_stubs[seg][off];
    tail = misc->stub_tail;
    if (tail == NULL)
        misc->stub_list = stub;
    else
        tail->next_stub = stub;

    misc->stub_tail = stub;

    /* zero out all fields in stub record. */
    memset((char *)stub, '\0', sizeof(struct stub_record));

    return (stub);
} /* end stub_add */

struct stub_record *find_stub_at_offset(subsp_index, stub_offset)
int subsp_index, stub_offset;
{
    struct stub_record *head;

    head = Subsp_Misc(subsp_index).stub_list;
    while (head != NULL) {
    	if (head->subsp_off == stub_offset)
	    return(head);
	head = head->next_stub;
    } 
    return(NULL);
} /* end find_stub_at_offset */

/* FORWARD declaration */
Fixup *check_for_stubs();
Fixup *build_pcrel_to_stub();

static int total_branches, lbstubs, reused_lbstubs;
static int milli_lbstubs;

Boolean long_reach_stubs_added()
{
    int old_index;
    struct tms pstart, pstop;
    time_t rstart, rstop;
    struct stub_record *stub;

    struct fru_list *fru, *next;  
    int x;

#ifdef WW_ANNOTATIONS
    int subsp_index;
#endif /* WW_ANNOTATIONS */

    more_stubs = FALSE;
    total_branches = 0;
    lbstubs = 0;
    reused_lbstubs = 0;
    milli_lbstubs = 0;

    if (first_time) {
	stub_limit = stubs_size;

    /* 
    ** HP-UX shared library support 
    ** assign lt_offsets and symbol info fields for symbols referenced 
    ** through the PLT. Relies on: 
    **	   1) all PLT entries have been found. 
    **	   2) Virtual Offsets for the PLT and DLT subspaces have been set.
    **  This routine must be called before bld_import_stub_rec() since
    **  it initializes the symbol_info field. 
    */
	if (PLT_subsp_index != BAD_SUBSP) 
           assign_PLT_offsets();
    }

    if (verbose & V_TIMES)
	rstart = times(&pstart);

    /* For each subspace, check its fixups. */
#ifdef WW_ANNOTATIONS_REMOVED
    for (subsp_index= fru_subsp_count;   /* SKIP FRU subspaces */
         subsp_index < subsp_dict_size;
         subsp_index++) {
	    /* 
	    ** Only traverse in output order if FRU is not being done.
	    ** We disable annotations on fru links anyway 
	    */
	    if (fru_subsp_count == 0 && (! annotations_killed_at_startup)) {
	        old_index=Subsp_Misc(subsp_index).r_n_x;
	    } else {
		old_index = subsp_index;
	    }
#else /* WW_ANNOTATIONS */
    for (old_index = fru_subsp_count;   /* SKIP FRU subspaces */
         old_index < subsp_dict_size;
         old_index++) {
#endif /* WW_ANNOTATIONS */

	    if (Subspace_Length(old_index) == 0) /* prevent useless call */
		continue;

#ifdef WW_ANNOTATIONS_REMOVED
	    if (Subsp_Stubs_Size(old_index) != 0) {
	        flush_current_annotations(old_index,
	    			     Subspace_Virtual_Offset(old_index),
				     COUNT_MODE);
	        out_annotation(STUBS_HEADER,old_index,
			       Subspace_Virtual_Offset(old_index),0,0,0);
	    }
#endif /* WW_ANNOTATIONS */ 

	    traverse_fixups(old_index, CHECK_FOR_STUBS);

	    /* for each stub, see if it needs a long branch stub */
	    for (stub = (struct stub_record *) Subsp_Misc(old_index).stub_list;
		 stub != NULL;
		 stub = stub->next_stub) {
		if (IS_BL_STUB(stub))
		    use_lb_stub(FALSE, &Subsp_Misc(old_index), stub);
	    }
        }

#ifdef WW_ANNOTATIONS_REMOVED
    /* 
    ** If the arguments are -1 and 0, then this is the last set of annotations
    ** to count 
    */
    flush_current_annotations(BAD_SUBSP, 0, COUNT_MODE);
#endif /* WW_ANNOTATIONS */

    if (first_time && alloc_stubs_xl)
    	more_stubs |= assign_xrt_offsets();

    /* 
    ** Remove all symbols on this list.  Go out and null out symbol record
    ** and extensions so we don't end up with duplicates.  This is for the
    ** FRU problem where we didn't build a promotion stub if we relinked the
    ** caller and the callee in the same patchxl() in that order.  For
    */

    for (fru = fru_list; fru != NULL; fru = fru->next) {
      /* null out our symbol in the symbol dict and all of its extensions */
      Sym_Type(fru->index) = ST_NULL;
      x = fru->index + 1;
      while (Sym_Type(x) == ST_ARG_EXT ||
             Sym_Type(x) == ST_SYM_EXT) {
         Sym_Type(x) = ST_NULL;
         x++;
      }
      if (verbose & V_STUBS)
          printf(ld_gets(1, 1193, "\nnullified fru index %d\n"),fru->index);
    }
    /* free up fru list */
    for (fru = fru_list; fru != NULL; fru = next) {
       next = fru->next;
       efree(fru);
    }

    if (verbose & V_TIMES)
        rstop = times(&pstop);

    if (verbose & (V_STUBS)) {
        if (first_time)
	    printf(ld_gets(1, 
			   1194, 
			   "Total short branches: %d\n"), 
		   total_branches);
	printf(ld_gets(1, 
		       1195, 
		       "Added %d long branch stubs; "), 
	       lbstubs);
	printf(ld_gets(1, 
		       1196, 
		       "reused %d long branch stubs"), 
	       reused_lbstubs);
        printf(ld_gets(1, 
		       1197, 
		       " (including %d to millicode)"), 
	       milli_lbstubs);

/* 
** The Unified header files do not describe the units returned
** by the times() function other than to say that they are in
** hardware dependent units. Defining HZ to be 1000 will convert
** all our timing print statements on the Unified release to be
** in units of clock ticks.  
*/
#ifndef HZ
#define HZ 1000
#endif
        if (verbose & V_TIMES)
	    printf(ld_gets(1, 1198, " (%d ms. real, %d ms. user)"),
	        (int) 1000*(rstop-rstart)/HZ,
	        (int) 1000*(pstop.tms_utime-pstart.tms_utime)/HZ);
        printf("\n");
    }

    /* 
    ** After all long branch stubs have been added, if we are in the
    ** instrumentation phase add some subspaces.
    */
    if (first_time && do_fdp_measure)
        set_fdp_subspace_information(fdp_names, fdp_names_size);
    return (more_stubs); 
} /* end long_reach_stubs_added */

/* external */
extern Fixup *build_call_fixup();
extern Fixup *build_symbol_fixup();
extern Fixup *build_compsym_fixup();
int curr_execution_level;

Fixup *check_for_stubs(fix_info, fixup, arg0, arg1)
struct fix_desc *fix_info;
Fixup *fixup;
int arg0, arg1;
{
    int info_type, new_sym;
    Fixup *ret_val;
    int value, constant, type;
    int i;
    Boolean changed;
    int branch_distance;  /* absolute value of jump distance, in bytes  */
#ifdef WW_ANNOTATIONS
    unsigned int new_flags, action, info;
#endif /* WW_ANNOTATIONS */

    ret_val = NULL;
    changed = FALSE;

    switch (info_type = fix_info->type) {

#ifdef WW_ANNOTATIONS
	case R_COMMENT:

/*  No longer generate PA annotations.
 * out_annotation() is a dummy function.
 */
#ifdef WW_ANNOTATIONS_REMOVED
	    action=(arg0 >> 5) & 0x7;
	    info=(arg0 & 0x1f);
	    switch (action) {
		case R_COMMENT_COPY_BITS:
		    out_annotation(COPY_BITS,
				   fixup_subsp,
				   branch_dot-2*WORDSIZE,
				   info,
				   arg1,
				   0);
		    break;
		case R_COMMENT_SYM_ADDR_LOOKUP:
		    out_annotation(SYM_ADDR_LOOKUP,
				   fixup_subsp,
				   branch_dot-2*WORDSIZE,
				   (info & 0xf),
				   arg1,
				   0);
		    break;
		default:
#ifdef DEBUG
                    /* Unknown annotation action type */
                    fprintf(stderr,
		      "Annotation error: Unknown annotation action type=%d\n",
                      action);
#endif /* DEBUG */
		    stop_annotations();
		    break;
	    }
#endif /* WW_ANNOTATIONS_REMOVED */
	    break;
#endif /* WW_ANNOTATIONS */

        case R_DATA_PLABEL:
        case R_CODE_PLABEL:
            arg0 += sym_bias;
            arg0 = Sym_Remap(arg0);
            if (first_time) {
                /* if HP-UX shared libraries */
	        if (building_incomp_exec || building_shlib)
		    new_sym = BAD_SYM;
		else
                /*
		** plabel code sequences will always be able to reach
		** an import stub if one exists. 
		*/
                    new_sym = import_stub_needed(arg0, TRUE);
                if (new_sym != BAD_SYM) {
                    arg0 = new_sym;
                    changed = TRUE;
                }
                new_sym = plabel_stub_needed(arg0);
                if (new_sym != BAD_SYM) {
                    arg0 = new_sym;
                    changed = TRUE;
                }
                new_sym = arg_reloc_stub_needed(arg0,
                                all_gen_regs(Sym_Dict(arg0).arg_reloc));
                if (new_sym != BAD_SYM) {
                    arg0 = new_sym;
                    changed = TRUE;
                }
                if (changed)
                    ret_val = build_symbol_fixup(info_type, arg0-sym_bias);
            }
            break;

	case R_COMP2:
	    if (arg0 == R_PUSH_PLABEL || arg0 == R_PUSH_PLABEL+1) {
		arg1 += sym_bias;
		arg1 = Sym_Remap(arg1);
		if (first_time) {
		    new_sym = plabel_stub_needed(arg1);
		    if (new_sym != BAD_SYM) {
			arg1 = new_sym;
			changed = TRUE;
	            }
		    new_sym = arg_reloc_stub_needed(arg1,
				    all_gen_regs(Sym_Dict(arg1).arg_reloc));
		    if (new_sym != BAD_SYM) {
			arg1 = new_sym;
			changed = TRUE;
		    }
		    if (changed)
			ret_val = build_compsym_fixup(R_COMP2,
						      R_PUSH_PLABEL, 
						      arg1-sym_bias);
		}
    	    }
            break;

        case R_PCREL_CALL:
            arg1 += sym_bias;
            arg1 = Sym_Remap(arg1);

	    /* Don't build stubs for calls to optional procs */
	    if (OPTIONAL_PROC(arg1))
		break;

            if (first_time) {

		/* 
		** If field selector is not FSEL, then we can reach any
		** import stub (arg 2 of import_stub_needed is TRUE.
		*/

		if (field_sel == R_FSEL || field_sel == NO_OVERRIDE)
		    new_sym = import_stub_needed(arg1, FALSE);
		else
		    new_sym = import_stub_needed(arg1, TRUE);

                if (new_sym != BAD_SYM) {
                    arg1 = new_sym;
                    changed = TRUE;
                } else
		    /* do again as "import_stub_needed" can change it */
		    arg1 = Sym_Remap(arg1);  
                new_sym = iq_stub_needed(arg1);
                if (new_sym != BAD_SYM) {
                    arg1 = new_sym;
                    changed = TRUE;
                }
		if (PROMOTION_STUB_POSSIBLE) {
                    new_sym = promotion_stub_needed(arg1);
                    if (new_sym != BAD_SYM) {
                        arg1 = new_sym;
                        changed = TRUE;
                    }
		}
                new_sym = arg_reloc_stub_needed(arg1, arg0);
                if (new_sym != BAD_SYM) {
                    arg1 = new_sym;
                    changed = TRUE;
                }
                if (FDP_COUNTING_STUB_POSSIBLE && !changed) {
                    new_sym = fdp_counting_stub_needed(arg1);
                    if (new_sym != BAD_SYM) {
                        arg1 = new_sym;
                        changed = TRUE;
                    }
                }
                if (changed)
                    ret_val = build_call_fixup(info_type, arg0, arg1-sym_bias);
            }
            /* long branch stub needed? */

	    /* 
	    ** If field_sel is not FSEL, we can reach the import stub without
	    ** a long branch stub.
	    */
	    if (field_sel != R_FSEL && field_sel != NO_OVERRIDE)
                break;

		/*  If we have an R_INDIRECT_CALL
		** fixup, and we're linking fully archive on 2.0, we won't
		** build a stub, since we will replace this BL with a
		** BVE,L */
	    if (dyncall_external_used) { 
	       dyncall_external_used = FALSE;
	       if (building_incomp_exec || building_shlib) {
		  if (dyncall_external == -1) {
		      user_error(BAD_MILLI_A, 0);
		  }
	          arg1 = dyncall_external; /* dyncall_external is biased. */
	       }
	       else if (pcx_u_pa2_0) {
		  break;
	       }
	    }

            total_branches++;
            value = symbol_value(arg1);
            /* constant must NOT be embedded in the data word */
            constant = get_constant(0);
            value += constant;
            type = Sym_Remap_Type(arg1);
            if (type == ST_MILLI_EXT)
                goto CONVERT_TO_BLE;

            branch_distance = value-branch_dot;
	    if (branch_distance < 0)
		branch_distance = (-branch_distance);  /* positive distance */

	    /* 
            ** break if we predict that a short branch will reach 
	    ** prediction for passes after the first pass is full reach - 
	    */
#ifdef PA_2_0
            if (! is_pcrel_short) 
		{   /* BLL instruction */
		    if (!OFL((branch_distance+lb_reach_pad),24))
			break; 
		} 
	    else 
#endif /* ifdef PA_2_0 */
	        {   /* BL instruction */
		    if (!OFL((branch_distance+lb_reach_pad),19))
			break;
		}

            if (!building_shlib && type == ST_MILLICODE && !OFL(value,19)) {
               /* 
	       ** we don't want to do use a BLE in PIC code, when building 
               ** HPUX shared libs  -- 
	       */
               CONVERT_TO_BLE:
                /* 
		** at this point, we have a branch to MILLICODE that        
                ** reaches with a BLE.  So change it in place!              
		*/
		if (!new_ble_flag) {
		    ret_val = static_fixup_area;
		    *ret_val++ = fix_info->len+1;         /* length */
		    *ret_val++ = R_NEW_BLE;               /* override */
		    for (i = 0; i < fix_info->len; i++)   /* original fixup */
			*ret_val++ = fixup[i];
		    ret_val = static_fixup_area;
		}
                break;
            }
            /* at this point, we need a long branch stub */

            /* annotate old fixup */
            ret_val = build_pcrel_to_stub(bld_lb_stub_rec(arg1, constant));
            break;

        case R_ABS_CALL:
            arg1 += sym_bias;
            arg1 = Sym_Remap(arg1);

	    dyncall_external_used = FALSE;

	    /* Don't build stubs for calls to optional procs */
	    if (OPTIONAL_PROC(arg1))
		break;

            if (first_time) {
		/*
		**  Since this is an absolute branch
		** it will reach unless its a call to millicode, in which
		** case it will be using an F' fixup. This case occurs when
		** millicode is in a low address text area and it can
		** be reached with a single BLE instruction.
		*/
                new_sym = import_stub_needed(arg1,(field_sel != R_FSEL));
                if (new_sym != BAD_SYM) {
                    arg1 = new_sym;
                    changed = TRUE;
                } else
		    /* do again as "import_stub_needed" can change it */
		    arg1 = Sym_Remap(arg1);  
                new_sym = iq_stub_needed(arg1);
                if (new_sym != BAD_SYM) {
                    arg1 = new_sym;
                    changed = TRUE;
                }
	        if (PROMOTION_STUB_POSSIBLE) {
                    new_sym = promotion_stub_needed(arg1, arg0);
                    if (new_sym != BAD_SYM) {
                        arg1 = new_sym;
                        changed = TRUE;
                    }
		}
                new_sym = arg_reloc_stub_needed(arg1, arg0);
                if (new_sym != BAD_SYM) {
                    arg1 = new_sym;
                    changed = TRUE;
                }
                if (FDP_COUNTING_STUB_POSSIBLE && !changed) {
                    new_sym = fdp_counting_stub_needed(arg1);
                    if (new_sym != BAD_SYM) {
                        arg1 = new_sym;
                        changed = TRUE;
                    }
                }
                if (changed)
                    ret_val = build_call_fixup(info_type, arg0, arg1-sym_bias);
            }
            /* long branch stub needed? */
            if (field_sel != R_FSEL)
                break;

            total_branches++;

            value = symbol_value(arg1);
            /* constant must NOT be embedded in the data word */
            constant = get_constant(0);
            value += constant;
            if (!OFL(value,19))
                break;

            /* the absolute branch doesn't reach.  are we to an FDP */
            /* counting stub? */

            if (Sym_Remap_Type(arg1) == ST_FDP_COUNT) {
                /* annotate fixup to branch to stub */
                ret_val = build_pcrel_to_stub(Sym_Dict(arg1).symbol_value);
                break;
            }

            /* 
            ** don't handle F' absolute branches, except to millicode 
            ** if the branch breaks, so be it.  The user will get an error 
	    */
            if (Sym_Remap_Type(arg1) != ST_MILLICODE)
                break;

            /* at this point, we need a long branch stub */

            /* annotate old fixup */
            ret_val = build_pcrel_to_stub(bld_lb_stub_rec(arg1, constant));
            break;

        case R_MILLI_REL:
            break;

        case R_PCREL_TO_STUB:
		/*   Reset this flag for subsequent passes over
		** the fixups.  case R_PCREL_CALL will catch short branches on
		** the first pass through long_reach_stubs_added(), and will
		** clear this flag; but on later passes, if indeed a branch
		** stub was created for the PCREL_CALL, the fixup type has
		** been changed to PCREL_TO_STUB.  Thus we WON'T CLEAR THE
		** FLAG FOR CALLS TO $$dyncall; the flag will still be set
		** on the next trailing PCREL_CALL fixup we see.
		**  */
	    dyncall_external_used = FALSE;
            break;

        case R_ENTRY:
            curr_execution_level = (arg0 >> REGION_SHIFT) & 03;
#ifdef WW_ANNOTATIONS_REMOVED
	    flush_current_annotations(fixup_subsp,
				      branch_dot-2*WORDSIZE,
				      COUNT_MODE);
	    new_flags=0;
	    if (arg0 & HP_COMPILED_UNWIND_INFO)
	      new_flags |= HP_COMPILED;
	    if (arg1 & SERIALIZE_UNWIND_INFO)
	      new_flags |= SERIALIZE;
            out_annotation(ENTRY_HEADER,
			   fixup_subsp,
			   branch_dot-2*WORDSIZE,
			   0,
			   0,
			   new_flags);
#endif /* WW_ANNOTATIONS */
            break;

    }
    return (ret_val);
} /* end check_for_stubs */

Fixup *build_pcrel_to_stub(stub_off)
int stub_off;
{
    Fixup *fixup;

    fixup = static_fixup_area;

    /* If offset is over 256K, give error */
    if (stub_off >= 0x40000) {
       unlink(output_name);	/* Don't leave bogus executable around */
       diagnose_fixup(_17_BIT_OFLO_BL, fixup_subsp);
       external_error(INVALID_FIXUPS, 0); /* This calls cleanup and exits */
    }

    /* 
    ** Build 2 byte R_PCREL_TO_STUB fixup if offset fits.  Since all offsets
    ** will be word aligned, shift right 2 bits and get 1024 byte range.
    ** This will allow us to replace a 2 byte R_PCREL_CALL fixup with a 
    ** 2 byte fixup so we doesn't malloc extra space. 
    */
    if (stub_off <= 0x3FF) {
       *++fixup = R_PCREL_TO_STUB;
       *++fixup = stub_off >> 2;
    } else {
       /* 
       ** Since a stub is guaranteed to be forwards from the beginning of a
       ** subspace, and since it is word aligned, we can change the 19 bit
       ** +/-256Kbyte offset into a 16 bit +64Kword offset.  64K fits in 2
       ** bytes, making this fixup 3 bytes, which is the same size as the
       ** second longest R_PCREL_CALL fixup.  This helps avoid mallocing up
       ** memory to annotate this fixup. 
       */
       *++fixup = R_PCREL_TO_STUB+1;
       *++fixup = stub_off >> 10;
       *++fixup = stub_off >> 2;
    }
    static_fixup_area[0] = fixup-static_fixup_area;
    return (static_fixup_area);
} /* end build_pcrel_to_stub */

int bld_lb_stub_rec(sym_index, constant)
int sym_index;
int constant;
{
    struct  subspace_dictionary_record *subsp;
    struct  subspace_dictionary_record *temp_subsp;
    struct  subsp_misc_record	       *misc;
    struct  stub_record                *stub,
				       *last_stub;
    int type, remap;
    int space_index, this_space_index;
    int subspace_index;
    Boolean reloc;     /* should we build a relocatable stub (embed sys)? */

    last_stub = Sym_Last_Lbstub(sym_index);
    if (last_stub != NULL && last_stub->subsp_index == fixup_subsp) {
	/* reuse an existing lb stub */
	reused_lbstubs++;
	return(last_stub->subsp_off);
    }

    /* need to create new long branch stub */
    lbstubs++;

    subsp = &Subsp_Dict(fixup_subsp);
    misc = &Subsp_Misc(fixup_subsp);
    stub = stub_add(misc);

    type = Sym_Remap_Type(sym_index);

    /* 
    ** if HP-UX shared libraries 
    ** If a space is relocatable (embedded systems) then we want branches to 
    ** the same space to be relocatable as well 
    ** Branches to different spaces are normal long branch stubs (absolute). 
    **
    ** perform the same calculations that symbol_value() did to find the     
    ** destination of our branch 					     
    */
    
    remap = Sym_Remap(sym_index);
    subspace_index = Sym_Subsp(remap);

    /* adjust for HP-UX shlib case of having both import and export stubs. */
    if (subspace_index == BAD_SUBSP && building_shlib) {
	int stub_index = Sym_Remap(Sym_Related_Stub(remap));  
				/* index of related export stub symbol */
	if ((stub_index != BAD_SYM) && 
	    (Sym_Dict(remap).symbol_type == ST_STUB_IMPORT)) {
	    subspace_index = Sym_Subsp(stub_index);
	}
    }

    assert(subspace_index != BAD_SUBSP);
    space_index = Subsp_Dict(subspace_index).space_index;
    this_space_index = subsp->space_index;
    reloc = ((space_index == this_space_index) && 
  	         space_misc[this_space_index].relocatable);

    if (reloc || building_shlib) 
        stub->type = SHL_LONG_BRANCH_STUB;
    else
        stub->type =
            (type == ST_MILLICODE || type == ST_MILLI_EXT) ?
	     MILLILONG_BRANCH_STUB :
             LONG_BRANCH_STUB;

    stub->subsp_index = fixup_subsp;

    stub->length      = (reloc || building_shlib) ? SHL_LB_STUB_SIZE 
                                                      : LB_STUB_SIZE;

    if (stub->type == MILLILONG_BRANCH_STUB) {
        milli_lbstubs++;
    }

    stub->subsp_off   = misc->next_stub_offset;

    /* Put the fixup info here */
    stub->stub_symbol = sym_index;
    stub->stub_constant   = constant;

    /* Update the subspace definition */
    subsp->subspace_length += stub->length;
    subsp->initialization_length += stub->length;
    misc->next_stub_offset += stub->length;

    /* Update symbol, saving the stub just created */
    Sym_Last_Lbstub(sym_index) = stub;

    return (stub->subsp_off);
} /* end bld_lb_stub_rec */

void bld_lb_stub(stub)
struct stub_record *stub;

/* FDP Long branch code sequence.

        addil   0,dp            ; ADDIL_DP (defined below)
        ldw     0(r1),r31       ; LDW_R1_R31
        addi,=  1,r31,r31       ; ADDI_EQ_1_R31_R31
        stw     r31,0(r1)       ; STW_R31_R1
        ldil    L'0,r1
        be,n    R'0(sr4,r1)
*/

/* Long branch code sequence.

	ldil	L'0,r1
	be,n	R'0(sr4,r1)
*/

{
    int *stubs_ptr;
    int value;

    stubs_ptr = &stub_area[stub->subsp_off / sizeof(int)];

#ifdef COUNT_LONG_BRANCHES

    if (count_long_branches && stub->type == LONG_BRANCH_STUB) {

        /* value is difference between counter symbol and $global$ */

        value = symbol_value(branch_counter_sym) - symbol_value(dollar_global);

        *stubs_ptr++ = fix_format(ADDIL_DP,
                            fix_field(value, stub->count_index, e_lsel),
                            i_exp21,
                            SR_IS_VALID); /* not used */
        *stubs_ptr++ = fix_format(LDW_R1_R31,
                            fix_field(value, stub->count_index, e_rsel),
                            i_exp14,
                            SR_IS_VALID); /* not used */
        *stubs_ptr++ = ADDI_EQ_1_R31_R31;
        *stubs_ptr++ = fix_format(STW_R31_R1,
                            fix_field(value, stub->count_index, e_rsel),
                            i_exp14,
                            SR_IS_VALID); /* not used */
        }
#endif /* COUNT_LONG_BRANCHES */
    value = symbol_value(stub->stub_symbol) +
            stub->stub_constant;

    *stubs_ptr++ = fix_format(LDIL_R1,
			fix_field(value, 0, e_lsel),
			i_exp21,
			SR_IS_VALID); /* not used */
    *stubs_ptr   = fix_format(BE_SR4_R1_NULL,
			fix_field(value, 0, e_rsel),
			i_abs17,
			GET_QUAD(value)); /* fix sr bits for target quadrant */
} /* end bld_lb_stub */

/* if HP-UX shared libraries */
void bld_shl_lb_stub(stub)
struct stub_record *stub;

/* HPUX shared lib long branch code sequence.

        bl	.+8, r1
	addil	L'0,r1
	ldo	R'0(r1),r1
	bv,n	R'0(r1)
*/

{
    int *stubs_ptr;
    int value;
    int stub_branch_dot;

    stub_branch_dot = Subspace_Virtual_Offset(stub->subsp_index) + 
			stub->subsp_off + 2*WORDSIZE;
    value = symbol_value(stub->stub_symbol) +
            stub->stub_constant - stub_branch_dot;

    stubs_ptr = &stub_area[stub->subsp_off / sizeof(int)];

    *stubs_ptr++ = fix_format(BL_DISP_R1,
		       0,
                       i_rel17,
		       SR_IS_VALID); /* not used */
    *stubs_ptr++ = fix_format(ADDIL_R1,
			fix_field(value, 0, e_lsel),
			i_exp21,
			SR_IS_VALID); /* not used */
    *stubs_ptr++ = fix_format(LDO_R1_R1,
			fix_field(value, 0, e_rsel),
			i_exp14,
			SR_IS_VALID); /* not used */

    *stubs_ptr = BV_R1_NULL;

    if (verbose & V_STUBS) {
	printf(ld_gets(1, 
		       1192, 
		       "SHL Long Branch Stub built: sym = %s, file = %s, "
			   "target_value = %0x8x\n"), 
	       Sym_Dict(stub->stub_symbol).name.n_name, 
	       Subsp_Misc(fixup_subsp).file_name, 
	       value);
    }
} /* end bld_shl_lb_stub */

int bld_iq_stub_rec(sym_index)
int sym_index;
{
    struct  subspace_dictionary_record *subsp;
    struct  subsp_misc_record	       *misc;
    struct  stub_record                *stub;
    struct  symnode  	               *sym_ptr;
    int subsp_index, type;

    subsp_index = Sym_Subsp(sym_index);
    subsp = &Subsp_Dict(fixup_subsp);
    misc = &Subsp_Misc(fixup_subsp);
    stub = stub_add(misc);

    type = Sym_Remap_Type(sym_index);
    stub->type = INTERQUAD_IMPORT_STUB;
    stub->subsp_index = fixup_subsp;
    stub->length      = IQ_STUB_SIZE;
    stub->subsp_off   = misc->next_stub_offset;

    /* Put the fixup info here */
    stub->stub_symbol = sym_index;

    /* Update the subspace definition */
    subsp->subspace_length += stub->length;
    subsp->initialization_length += stub->length;
    misc->next_stub_offset += stub->length;

    /* Set up stub field of this symbol for stub reuse     */
    sym_ptr = Sym_Back_Ptr(sym_index);
    Sym_Import_Stub(sym_ptr->index) = stub;

    return (stub->subsp_off);
} /* end bld_iq_stub_rec */

void bld_iq_stub(stub)
struct stub_record *stub;

/* Interquad branch stub code sequence.

	ldil	L'0,r22
	ldo	R'0(r22),r22
	ldil	L'0,r21
	be  	R'0(sr4,r21)
        stw	rp,-24(sp)
*/

{
    int *stubs_ptr;
    int value, sr4value;

    value = symbol_value(stub->stub_symbol) + stub->stub_constant;

    sr4value = symbol_value(sr4export_sym);

    stubs_ptr = &stub_area[stub->subsp_off / sizeof(int)];

    *stubs_ptr++ = fix_format(LDIL_R22,
			fix_field(value, 0, e_lsel),
			i_exp21,
			SR_IS_VALID); /* not used */
    *stubs_ptr++ = fix_format(LDO_R22_R22,
			fix_field(value, 0, e_rsel),
			i_exp14,
			SR_IS_VALID); /* not used */
    *stubs_ptr++ = fix_format(LDIL_R21,
			fix_field(sr4value, 0,e_lsel),
			i_exp21,
			SR_IS_VALID); /* not used */
    *stubs_ptr++ = fix_format(BE_SR4_R21,
			fix_field(sr4value,0,e_rsel),
			i_abs17,
			SR_IS_VALID); /* don't change sr bits! */
    *stubs_ptr   = SAVE_RP;
} /* end bld_iq_stub */

int bld_dl_export_stub_rec(export_index)
int export_index;

/* 
** Call when a UNIVERSAL, ENTRY or CODE symbol is found and dynamically
** loading a file. (Not called for base file symbols - only for dynamic file).
*/

{
    struct  stub_record		       *stub;
    struct  symbol_dictionary_record *export;
    struct  subspace_dictionary_record *subsp;
    struct  subsp_misc_record	       *misc;
    int     subsp_index;
    int	    dummy_relocation, arg_reloc_size, rtn_reloc_size;

    export = &Sym_Dict(export_index);
    subsp_index = Sym_Subsp(export_index);
    subsp  = &Subsp_Dict(subsp_index);
    misc   = &Subsp_Misc(subsp_index);
    stub   = stub_add(misc);

    dummy_relocation = all_gen_regs(export->arg_reloc);

    /* determine the size of the stub */
    get_stub_info(dummy_relocation, 
		  export->arg_reloc,
		  &arg_reloc_size, 
		  &rtn_reloc_size);

    stub->type		        = DL_EXPORT_STUB;
    stub->subsp_index		= subsp_index;
    stub->subsp_off		= misc->next_stub_offset;
    stub->length		= arg_reloc_size + rtn_reloc_size +
      				  DL_STUB_SIZE;
    stub->arg_reloc_size	= arg_reloc_size;
    stub->rtn_reloc_size	= rtn_reloc_size;
    stub->caller_reloc		= dummy_relocation;
    stub->callee_reloc		= export->arg_reloc;

    /* Fix the pc-relative branch target */
    stub->stub_symbol  = export_index;

    /* Update the subspace definition */
    subsp->subspace_length       += stub->length;
    subsp->initialization_length += stub->length;
    misc->next_stub_offset       += stub->length;

    return(stub->subsp_off);
} /* end bld_dl_export_stub_rec */

void bld_dl_export_stub(stub, stubs_location)
struct stub_record *stub;
int stubs_location;

/* Entry Export stub code sequence. (entry stubs for dynamic routines)

	bl	0,rp		; branch to real entry point
	nop
	ldw	-24(sp),rp	; restore return link from stack
	ldsid	(rp),r1		; get space id for return
	mtsp	r1,sr0
	be,n  	0(sr0,rp)	; return
*/

{
    int *stubs_ptr;
    int sym_index, value;

    sym_index = stub->stub_symbol;
    stubs_ptr = &stub_area[stub->subsp_off / sizeof(int)];

    if (stub->arg_reloc_size != 0)
	stubs_ptr = spit_arg_reloc_code(stubs_ptr, stub);

    stubs_location += WORDSIZE*(stubs_ptr - stub_area + 2);
    value = symbol_value(sym_index) - stubs_location;

    *stubs_ptr++ = fix_format(BL_TO_ENTRY,
			value,
			i_rel17,
			SR_IS_VALID); /* not used */
    *stubs_ptr++ = NOP;
    if (stub->rtn_reloc_size != 0)
	stubs_ptr = spit_rtn_reloc_code(stubs_ptr, stub);
    *stubs_ptr++ = RESTORE_RP;
    *stubs_ptr++ = LOAD_RETURN_SID;
    *stubs_ptr++ = MOVE_SID_2_SREG;
    *stubs_ptr   = BE_SR0_RP_NULL;
} /* end bld_dl_export_stub */

/* if HP-UX shared libraries */
int bld_shlib_export_stub_rec(export_index)
int export_index;

/* 
** Call when a UNIVERSAL, ENTRY or CODE symbol is found and linking an
** HPUX incomplete exececutable or shared library file.
*/

{
    struct  stub_record		       *stub;
    struct  symbol_dictionary_record *export;
    struct  subspace_dictionary_record *subsp;
    struct  subsp_misc_record	       *misc;
    int     subsp_index;
    int	    dummy_relocation, arg_reloc_size, rtn_reloc_size;

    export = &Sym_Dict(export_index);
    subsp_index = Sym_Subsp(export_index);
    subsp  = &Subsp_Dict(subsp_index);
    misc   = &Subsp_Misc(subsp_index);
    
    /* if both has_long_return and no parms reloc then no need to */
    /* build export stub. Just return symbol value w/o add stub.  */
    /* For PA2.0, a parameter relocation stub may be added later  */
    /* so we always create the export stub in case we end up      */
    /* needing it later unless no_relocation is also TRUE.        */
    if(export->has_long_return && export->no_relocation ) {

#ifdef DEBUG
        fprintf(stderr,
        "Export stub not built for %s\n", Sym_Name(export_index));

#endif /* DEBUG */
       return(symbol_value(export_index));
    }

    stub   = stub_add(misc);

    dummy_relocation = all_gen_regs(export->arg_reloc);

    /* determine the size of the stub */
    get_stub_info(dummy_relocation, 
		  export->arg_reloc,
		  &arg_reloc_size, 
		  &rtn_reloc_size);

    if(export->has_long_return && (rtn_reloc_size == 0)){
       /* OpenGL support. Export stubs w/otrapping procedure return. */
       stub->type    = HPUX_EXPORT_STUB_NO_RP;
    }
    else {
       stub->type		        = HPUX_EXPORT_STUB;
    }
    stub->subsp_index		= subsp_index;
    stub->subsp_off		= misc->next_stub_offset;
    if(stub->type == HPUX_EXPORT_STUB_NO_RP){
       stub->length      = arg_reloc_size + rtn_reloc_size + 2*WORDSIZE;
    }
    else {
       if(pcx_u_pa2_0)
          stub->length		= arg_reloc_size + rtn_reloc_size +
						   PA2_0_EXPORT_STUB_SIZE;
       else
          stub->length		= arg_reloc_size + rtn_reloc_size +
						   HPUX_EXPORT_STUB_SIZE;
    }
    stub->arg_reloc_size	= arg_reloc_size;
    stub->rtn_reloc_size	= rtn_reloc_size;
    stub->caller_reloc		= dummy_relocation;
    stub->callee_reloc		= export->arg_reloc;

    /* Fix the pc-relative branch target */
    stub->stub_symbol  = export_index;

    /* Update the subspace definition */
    subsp->subspace_length       += stub->length;
    subsp->initialization_length += stub->length;
    misc->next_stub_offset       += stub->length;

    return(stub->subsp_off);
} /* end bld_shlib_export_stub_rec */

void bld_shlib_export_stub(stub, stubs_location)
struct stub_record *stub;
int stubs_location;

/* HPUX Shared Library Entry Export stub code sequence. 

	bl	0,rp		; branch to real entry point
	nop
	ldw	-24(sp),rp	; restore return link from stack
	ldsid	(rp),r1		; get space id for return
	mtsp	r1,sr0
	be,n  	0(sr0,rp)	; return
*/

{
    int *stubs_ptr;
    int sym_index, value;
    int type;  /* type of current symbol */

    sym_index = stub->stub_symbol;

    if (sym_index != BAD_SYM && Sym_Remap_Type(sym_index) == ST_STUB_IMPORT) {
	/* 
	** handle case of imports for routines exported from a shlib. 
	** The "related_stub" list here looks like :
	** Import Stub -> (possible arg-reloc/local import stubs) ->
	**	Export Stub -> Copy of original Sym (i.e., Code Univ) 
	*/

	sym_index = find_export_stub_sym (sym_index);
	/* 
	** use copy of original symbol made in "shlib_build_tables" so that 
	** "symbol_value" below will get right address, because it assumes
	** that when processing stubs we'll really be looking at the original
	** symbol or one that's been relocated 
	*/
	sym_index = Sym_Related_Stub(sym_index);  /* copy is next struct on
						     list after export stub */
    }

    stubs_ptr = &stub_area[stub->subsp_off / sizeof(int)];

    if (stub->arg_reloc_size != 0)
	stubs_ptr = spit_arg_reloc_code(stubs_ptr, stub);

    stubs_location += WORDSIZE*(stubs_ptr - stub_area + 2);
    value = (sym_index == BAD_SYM) ? stub->stub_constant 
			   : (symbol_value(sym_index) - stubs_location);

    if(stub->type == HPUX_EXPORT_STUB_NO_RP){
       *stubs_ptr++ = fix_format(B_DISP,
                        value,
                        i_rel17,
                        SR_IS_VALID); /* not used */
    }
    else{
       if(pcx_u_pa2_0){
          /*
	   * PA 2.0 new instruction stub 
	   * Use BLL instead of BL for larger displacement to entry.
	   */
          *stubs_ptr++ = fix_format(BLL_DISP,
			value,
			i_rel22,
			SR_IS_VALID); /* not used */
       }
       else {
          *stubs_ptr++ = fix_format(BL_TO_ENTRY,
			value,
			i_rel17,
			SR_IS_VALID); /* not used */
       }
    }
    *stubs_ptr++ = NOP;
    if (stub->rtn_reloc_size != 0)
	stubs_ptr = spit_rtn_reloc_code(stubs_ptr, stub);

    if(stub->type != HPUX_EXPORT_STUB_NO_RP){
       /* OpenGL support: If not HPUX_EXPORT_STUB_NO_RP then  */
       /* Restore return address from stack and branch external */

       *stubs_ptr++ = RESTORE_RP;
       if(pcx_u_pa2_0){
          /*
           * PA 2.0 new instruction stub
           * Use BVE (%rp) to replace 3 PA 1.x intructions
           * (load sid, mvsid to SR, BE).
           */
          *stubs_ptr++ = BVE_RP_NULL;
       }
       else {
          *stubs_ptr++ = LOAD_RETURN_SID;
          *stubs_ptr++ = MOVE_SID_2_SREG;
          *stubs_ptr++ = BE_SR0_RP_NULL;
       }
    }
} /* end bld_shlib_export_stub */

int plabel_stub_needed(sym_index)
int sym_index;
{
    int stub_index;
    int sym_subsp;
    int stub_subsp;

    /* sym_index already remapped */

    if (extern_plabels) {
	if (building_incomp_exec || building_shlib ||
	    Sym_Dict(sym_index).symbol_type == ST_STUB_IMPORT)
            /* don't do anything, since already given an xrt offset or N/A */
	    return (BAD_SYM);
        sym_subsp = Sym_Subsp(sym_index);
	for (stub_index = Sym_Related_Stub(sym_index);
    	     stub_index != BAD_SYM;
	     stub_index = Sym_Related_Stub(stub_index)) {
  	    if (Sym_Dict(stub_index).symbol_type == ST_PLABEL) {
                stub_subsp = Sym_Subsp(stub_index);
                /* in order to be OK, the stub must either be in the */
                /* caller or callee subspaces */
                if (stub_subsp == sym_subsp ||  /* stub with callee */
                    stub_subsp == fixup_subsp)   /* stub with caller */
                    return (stub_index);
	    }
        }
	/* print warning for plabel stubs */
	if (verbose & V_STUBS)
	    printf( ld_gets(1, 1200, "Plabel stub from %s(%s+%x) to %s\n"),
		    Subsp_Misc(fixup_subsp).file_name,
		    Subsp_Dict(fixup_subsp).name.n_name,
		    branch_dot-original_branch_dot,
		    Sym_Dict(sym_index).name.n_name);
        return (add_plabel_stub(sym_index));
    } else if (base_file_name != NULL && !relinkable &&
               strcmp(base_file_name,
                  Subsp_Misc(Sym_Subsp(sym_index)).file_name) != 0) {

        /* 
	** for a dynamic link we need to create a plabel stub for indirect
        ** calls (e.g. addresses of dynamically linked routines).
        */
	for (stub_index = Sym_Related_Stub(sym_index);
    	     stub_index != BAD_SYM;
	     stub_index = Sym_Related_Stub(stub_index)) {

  	    if (Sym_Dict(stub_index).symbol_type == ST_PLABEL) 
                    return (stub_index);
         }
         /* 
	 ** If we have gotten to here then there is no PLABEL stub for the
         ** symbol so make one. 
         */
        return (add_plabel_stub(sym_index));
    }
    return (BAD_SYM);
} /* end plabel_stub_needed */

int add_plabel_stub(export_index)
int export_index;
{
    struct symbol_dictionary_record *export, *plabel_symbol;
    int el_bits;  /* Execution Level Bits - low-order two bits of code addr */
    int plabel_index, export_stub_index, sym_type;
    int sym_subsp, stub_subsp;

    /* if HP-UX shared libraries */
    /* 
    ** this routine should never be called in the cases below since there
    ** should always be an import stub for these plabel cases, and
    ** "plabel_stub_needed" no-ops if it sees an import stub symbol. 
    */
    if (building_incomp_exec || building_shlib)
	internal_error(BAD_PLABEL_FIXUP, 0);

    export = &Sym_Dict(export_index);
    sym_subsp = Sym_Subsp(export_index);

    if (export->symbol_type != ST_ENTRY &&
	export->symbol_type != ST_PRI_PROG &&
	export->symbol_type != ST_SEC_PROG)
  	warning(BAD_SYM_PLABEL_STUB,
		Subsp_Misc(sym_subsp).file_name,
		export->name.n_name, 
		0);

    /* see if there is another export stub already */
    for (export_stub_index = Sym_Related_Stub(export_index);
         export_stub_index != BAD_SYM;
         export_stub_index = Sym_Related_Stub(export_stub_index)) {
        sym_type = Sym_Dict(export_stub_index).symbol_type;
        if (sym_type == ST_STUB_ENTRY ||
  	    sym_type == ST_STUB_PRI_PROG ||
  	    sym_type == ST_STUB_SEC_PROG ||
  	    sym_type == HPUX_EXPORT_STUB ||
  	    sym_type == DL_EXPORT_STUB) {
            /* are we in an OK subspace? */
            stub_subsp = Sym_Subsp(export_stub_index);
            if (stub_subsp == sym_subsp ||
                stub_subsp == fixup_subsp)
                break;
        }
    }

    if (export_stub_index == BAD_SYM) {
        /* didn't find an export stub */
        /* we will build one later, see which subspace now */
        if (base_file_name != NULL && !relinkable)
            stub_subsp = sym_subsp;
        else
            stub_subsp = (sym_subsp >= fru_subsp_count)?sym_subsp 
	      : fixup_subsp;
    } else if (base_file_name != NULL && !relinkable)
        /* use the existing export stub if we are doing a dynamic link */
        return (export_stub_index);

    /* going to add a symbol, so we must make another counting pass */
    more_stubs = TRUE;

    plabel_index = symbol_allocate(stub_subsp);
    plabel_symbol = &Sym_Dict(plabel_index);
    Sym_Related_Stub(plabel_index) = Sym_Related_Stub(export_index);
    Sym_Related_Stub(export_index) = plabel_index;

    *plabel_symbol = *export;
    plabel_symbol->symbol_type  = ST_PLABEL;
    plabel_symbol->symbol_scope = SS_LOCAL;
    plabel_symbol->check_level  = 0;
    plabel_symbol->arg_reloc    = all_gen_regs(export->arg_reloc);
    if (base_file_name != NULL && !relinkable)
        plabel_symbol->symbol_info  = stub_subsp;
    else
        plabel_symbol->symbol_info  = (next_xrt++) * XRT_ENTRY_SIZE;

    if (export_stub_index == BAD_SYM) {
        el_bits = export->symbol_value & 03;
        if (base_file_name != NULL & !relinkable) 
            plabel_symbol->symbol_value = 
                    bld_dl_export_stub_rec(export_index) | el_bits;
        else
            plabel_symbol->symbol_value =
                    bld_export_stub_rec(export_index, stub_subsp) | el_bits;
    } else {
        plabel_symbol->symbol_value = Sym_Dict(export_stub_index).symbol_value;
    }

    return (plabel_index);
} /* end add_plabel_stub */

int arg_reloc_stub_needed(sym_index, fixup_arg_reloc)
int sym_index;
int fixup_arg_reloc;
{
    struct symbol_dictionary_record *sym;
    struct symbol_misc_record *sym_misc;
    int    arg_reloc_size, rtn_reloc_size;
    struct symbol_dictionary_record *new_sym;
    struct symbol_misc_record *new_sym_misc;
    int    stub_index;
    int    sym_subsp, stub_subsp;
    struct stub_record	              *stub;
    struct subspace_dictionary_record *subsp;
    struct subsp_misc_record          *misc;
    char   *nls_temp;
    char   *nls_msg1;

    if (no_arg_reloc)
        return (BAD_SYM);

    /* sym_index already remapped */

    sym = &Sym_Dict(sym_index);
    sym_misc = &Sym_Misc(sym_index);

    /* check for obvious wildcards or exact match */
    if (fixup_arg_reloc == 0 ||
	sym->arg_reloc == 0 ||
	fixup_arg_reloc == sym->arg_reloc)
	return (BAD_SYM);
	
    /* check more carefully -- do we really need a stub? */
    get_stub_info(fixup_arg_reloc, 
		  sym->arg_reloc,
		  &arg_reloc_size, 
		  &rtn_reloc_size);

    if (arg_reloc_size == 0 && rtn_reloc_size == 0)
	return (BAD_SYM);

    /* definitely need a stub if we get here */

    sym_subsp = Sym_Subsp(sym_index);

    /* look for an existing relocation stub with the right bits */
    for (stub_index = Sym_Related_Stub(sym_index);
    	 stub_index != BAD_SYM;
	 stub_index = Sym_Related_Stub(stub_index)) {
	new_sym = &Sym_Dict(stub_index);
	if (new_sym->symbol_type == ST_STUB_RELOC &&
            fixup_arg_reloc == new_sym->arg_reloc) {
            stub_subsp = Sym_Subsp(stub_index);
	    /* found one!  use it again, if possible */
            /* things are OK, if stub is associated with caller or callee */
            if (stub_subsp == sym_subsp ||      /* stub with caller */
                stub_subsp == fixup_subsp)       /* stub with callee */
    	        return (stub_index);
	}
    }

    /* couldn't find one... have to make one */

    /* print warning for parameter relocation stubs */
    if (verbose & V_STUBS) {
	nls_temp = ld_gets(1, 
			   1256,
			   "Parameter relocation stub from "
			       "%s(%s+%x) to %s ");
	nls_msg1 = emalloc(strlen(nls_temp) + 1);
	strcpy(nls_msg1, nls_temp);
        printf( nls_msg1,
		Subsp_Misc(fixup_subsp).file_name,
		Subsp_Dict(fixup_subsp).name.n_name,
		branch_dot-original_branch_dot,
		sym->name.n_name);
	(void) efree((void *) nls_msg1);
        print_arg_reloc(fixup_arg_reloc);
        printf(ld_gets(1, 1201, " vs. "));
        print_arg_reloc(sym->arg_reloc);
        printf("\n");
    }

    /* 
    ** argument relocation stubs can be created in both dynamic loading and
    ** FRU relink.  In neither case can the stub go in the original target
    ** subspace.  It must go in the caller subspace (fixup_subsp) instead
     */
    stub_subsp = (sym_subsp >= fru_subsp_count &&
                  sym_subsp >= dynamic_load_subsp_count) ?
                  sym_subsp : fixup_subsp;

    stub_index = symbol_allocate(stub_subsp);
    new_sym = &Sym_Dict(stub_index);
    new_sym_misc = &Sym_Misc(stub_index);
    Sym_Related_Stub(stub_index) = Sym_Related_Stub(sym_index);
    Sym_Related_Stub(sym_index) = stub_index;

    *new_sym = *sym;
    new_sym->symbol_type  = ST_STUB_RELOC;
    new_sym->symbol_scope = SS_LOCAL;
    new_sym->check_level  = 0;
    new_sym->arg_reloc    = fixup_arg_reloc;
    new_sym->symbol_info  = stub_subsp;

    new_sym_misc->shlib_import_indx  = sym_misc->shlib_import_indx;
    new_sym_misc->code_plabel        = sym_misc->code_plabel;
    new_sym_misc->hide_export        = sym_misc->hide_export;
    new_sym_misc->import_data_plabel = sym_misc->import_data_plabel;

    /* now, build the stub record itself */

    subsp = &Subsp_Dict(stub_subsp);
    misc  = &Subsp_Misc(stub_subsp);
    stub  = stub_add(misc);

    stub->type		      = LOCAL_RELOC_STUB;
    stub->subsp_index	      = stub_subsp;
    stub->subsp_off	      = misc->next_stub_offset;
    stub->length	      = arg_reloc_size + WORDSIZE;
    if (rtn_reloc_size > 0)
	stub->length	     += rtn_reloc_size + 4*WORDSIZE;
    stub->arg_reloc_size      = arg_reloc_size;
    stub->rtn_reloc_size      = rtn_reloc_size;
    stub->caller_reloc	      = fixup_arg_reloc;
    stub->callee_reloc	      = sym->arg_reloc;

    /* Fix the pc-relative branch target */
    stub->stub_symbol = sym_index;

    /* Update the subspace definition */
    subsp->subspace_length += stub->length;
    subsp->initialization_length += stub->length;
    misc->next_stub_offset += stub->length;

    new_sym->symbol_value = stub->subsp_off;
    return (stub_index);
} /* end arg_reloc_stub_needed */

print_arg_reloc(i)
int i;
{
    int j;
    for (j = 8; j >= 0; j -= 2)
        printf("%d", (i>>j)&03);
}

void bld_local_reloc_stub(stub, stubs_location)
struct stub_record *stub;
int stubs_location;
{
    int sym_index;
    int *stubs_ptr;

    stubs_ptr = &stub_area[stub->subsp_off / sizeof(int)];

    stubs_ptr = spit_arg_reloc_code(stubs_ptr, stub);

    stubs_location += WORDSIZE*(stubs_ptr - stub_area + 2);

    sym_index = stub->stub_symbol;

    if (stub->rtn_reloc_size == 0) {
	*stubs_ptr++ =
            fix_format(B_DISP_NULL,
                       sym_index == BAD_SYM ?
                            stub->stub_constant :
                            symbol_value(sym_index) - stubs_location,
                       i_rel17,
		       SR_IS_VALID); /* not used */
    } else {
	*stubs_ptr++ = SAVE_RP_2PRIME;
        stubs_location += WORDSIZE;
	*stubs_ptr++ =
            fix_format(BL_DISP_NULL,
                       sym_index == BAD_SYM ?
                            stub->stub_constant :
                            symbol_value(sym_index) - stubs_location,
                       i_rel17,
		       SR_IS_VALID); /* not used */
	*stubs_ptr++ = NOP;
	stubs_ptr = spit_rtn_reloc_code(stubs_ptr, stub);
	*stubs_ptr++ = RESTORE_RP_2PRIME;
	*stubs_ptr++ = LOCAL_RETURN;
    }
} /* end bld_local_reloc_stub */

int check_promotion_list(sym)
struct symbol_dictionary_record *sym;
{
    char **list = promotion_list;
    char *name, *t, *s;

    while (name = *list++) {
        if (strcmp(sym->name.n_name, name) != 0) continue;

        /* we found a match! */
        if (verbose & V_STUBS)
            printf(ld_gets(1, 
			   1202, 
			   "Forcing promotion of %s in file %s\n"),
		   name, 
		   Subsp_Misc(fixup_subsp).file_name);
        return(TRUE);
    }

    /* we didn't find any matches */
    return(FALSE);

} /* end check_promotion_list */


/*
 * promotion_stub_needed() checks to see if a procedure call
 * can result in execution level promotion.  If it can, then
 * the linker must make it an external call, despite the fact
 * that it can be resolved internally.  To do this, we make
 * a "plabel" stub (which makes an export stub and allocates
 * an XRT entry), and an import stub for which the XRT offset
 * is that of the plabel stub.
 */

int promotion_stub_needed(sym_index)
int sym_index;
{
    int	stub_index, plabel_index;
    register struct symbol_dictionary_record *sym;
    int sym_subsp, stub_subsp;
    int exec_level;

    if (! PROMOTION_STUB_POSSIBLE)
	return (BAD_SYM);

    /* sym_index already remapped */

    sym = &Sym_Dict(sym_index);

    /* if target symbol isn't a procedure, ignore this fixup */
    if (sym->symbol_type != ST_ENTRY &&
	sym->symbol_type != ST_PRI_PROG &&
	sym->symbol_type != ST_SEC_PROG)
	return (BAD_SYM);

    /* set execution level ; check it below */
    exec_level = (exec_level_override >= 0)?
			exec_level_override : curr_execution_level;
    
    /* 
    ** Force the generation of this promotion if the symbol appears on
    ** the promotion list. This functionality is used for procedure exits
    ** on XL. Namely this will force an XRT entry for the loader to play with
    */
      if (promotion_list == NULL || (!check_promotion_list(sym))) {
        /* 
	** symbol is not on list, let's check and see if one is necessary 
        ** see if execution level is more privileged at the target 
        ** external symbols already must be going through XRT table 
	*/
        if (sym->symbol_scope == SS_EXTERNAL ||
            exec_level <= (sym->symbol_value & 03))
            return (BAD_SYM);

    } /* not on promotion list */

    /* print warning for promotion stubs */
    if (verbose & V_STUBS)
        printf( ld_gets(1, 
			1203, 
			"Promotion stub from %s (%s+%x, xl=%d) to "
			    "%s (xl=%d)\n"),
		Subsp_Misc(fixup_subsp).file_name,
		Subsp_Dict(fixup_subsp).name.n_name,
		branch_dot-original_branch_dot,
		exec_level,
		sym->name.n_name,
		sym->symbol_value & 03);

    sym_subsp = Sym_Subsp(sym_index);

    /* look for an existing plabel stub */
    for (plabel_index = Sym_Related_Stub(sym_index);
	 plabel_index != BAD_SYM;
	 plabel_index = Sym_Related_Stub(plabel_index)) {
	if (Sym_Dict(plabel_index).symbol_type == ST_PLABEL) {
            stub_subsp = Sym_Subsp(plabel_index);
            if (stub_subsp == sym_subsp ||
                stub_subsp == fixup_subsp) {
    	        /* found one */
    	        break;
            }
	}
    }

    /* create the plabel and import stubs if no existing one */
    if (plabel_index == BAD_SYM) {
	plabel_index = add_plabel_stub(sym_index);
	return (add_promotion_stub(plabel_index));
    }

    /* 
    ** look for an existing import stub. NOTE: shouldn't be one if there
    ** wasn't a plabel stub!  If there is, it won't refer to the right XRT
    ** entry
    */
    for (stub_index = Sym_Related_Stub(sym_index);
         stub_index != BAD_SYM;
         stub_index = Sym_Related_Stub(stub_index)) {
	if (Sym_Dict(stub_index).symbol_type == ST_STUB_IMPORT)
	    return (stub_index);
    }
    /* create the import stub if no existing one */
    return (add_promotion_stub(plabel_index));
} /* end promotion_stub_needed */

int add_promotion_stub(sym_index)
int sym_index;
{
    int subsp, stub_index;
    struct symbol_dictionary_record *sym, *new_symbol;

    sym = &Sym_Dict(sym_index);
    subsp = Sym_Subsp(sym_index);
    /* 
    ** check to see if subspace is fru subspace - if not then use fixup
    ** subspace rather than the symbol subspace.
    */
    if (subsp < fru_subsp_count) subsp = fixup_subsp;
    stub_index = symbol_allocate(subsp);
    new_symbol = &Sym_Dict(stub_index);
    /* add it to related list of plabel stub which also puts it on */
    /* related list of the original symbol                         */
    Sym_Related_Stub(stub_index) = Sym_Related_Stub(sym_index);
    Sym_Related_Stub(sym_index) = stub_index;

    /* XRT offset already been assigned (since plabel stub), just use copy */
    *new_symbol = *sym;
    new_symbol->symbol_type  = ST_STUB_IMPORT;
    new_symbol->symbol_scope = SS_LOCAL;
    new_symbol->check_level  = 0;
    new_symbol->arg_reloc    = all_gen_regs(-1);

    /* parm 2 specifies that the call IS from add_promo_stub */
    bld_import_stub_rec(stub_index, TRUE);
    return (stub_index);
} /* end add_promotion_stub */

int iq_stub_needed(sym_index)
int sym_index;
{
    struct symbol_dictionary_record *symbol, *sym_ptr, *new_symbol;
    struct symnode *prev_ptr, *symnode_ptr;
    struct stub_record *stub_ptr; 
    int value, new_sym_index;

        /* 
	** if dynamically loading the file, then check to see that
        ** branch_dot and value are in the same quad; if not then
        ** an interquad stub is needed; otherwise return BAD_SYM.
        */
        value = symbol_value(sym_index);
        if ((base_file_name == NULL) || 
	    (GET_QUAD(value) == GET_QUAD(branch_dot))){
            return(BAD_SYM);
        }

	/* Search to see if one exists:
        ** Get the created import stub list with INTERQUAD_IMPORT_STUB
        ** stub type.
        */

        prev_ptr = Sym_Back_Ptr(sym_index);
        symnode_ptr = prev_ptr->same;
        stub_ptr = Sym_Import_Stub(prev_ptr->index);
	if (stub_ptr != NULL) {
	    if ((stub_ptr->stub_symbol == sym_index) && 
                (stub_ptr->type == INTERQUAD_IMPORT_STUB)) 
                          return (Sym_Related_Stub(sym_index));

	}
	/* Does not exist, create new symbol */

        symbol = &Sym_Dict(sym_index);
        new_sym_index = symbol_allocate(fixup_subsp);
        new_symbol = &Sym_Dict(new_sym_index);
        Sym_Related_Stub(new_sym_index) = Sym_Related_Stub(sym_index);
        Sym_Related_Stub(sym_index) = new_sym_index;

        *new_symbol = *symbol;
        new_symbol->symbol_type  = ST_STUB_IMPORT;
        new_symbol->symbol_scope = SS_LOCAL;  /* ?? */
        new_symbol->arg_reloc    = symbol->arg_reloc;
        new_symbol->symbol_value = bld_iq_stub_rec(sym_index);

        return(new_sym_index);
} /* end iq_stub_needed */

/* 
** Call when a UNIVERSAL, ENTRY or CODE symbol is found and the allocate
** stubs flag is set or dynamic loading is in effect.
** .  Changes for better processing:  now
** return the stub_index, so the caller can use it.
** Also, check first to see if we've already built an export stub
** for it; if so, just return it, don't build a new one 
*/
int add_export_stub (int export_index)
{
    struct  symbol_dictionary_record *export, *new_symbol;
    int stub_index;
    int el_bits;  /* Execution Level Bits - low-order two bits of code addr */
    int stub_subsp;

    if ((stub_index = find_export_stub_sym (export_index)) != BAD_SYM)
	return stub_index;

    export = &Sym_Dict(export_index);
    stub_subsp = Sym_Subsp(export_index);

    /* lose check in shlib use */
    if (!(building_shlib || building_incomp_exec)) 
    	if ((export->symbol_type != ST_ENTRY &&
	     export->symbol_type != ST_PRI_PROG &&
	     export->symbol_type != ST_SEC_PROG) ||
	    export->symbol_scope != SS_UNIVERSAL || 
	    (!(alloc_stubs_xl || alloc_stubs_ux) && base_file_name == NULL))
	    internal_error(BAD_SYM_EXP_STUB,
		           Subsp_Misc(stub_subsp).file_name,
		           export->name.n_name, 
			   0);

    stub_index = symbol_allocate(stub_subsp);
    new_symbol = &Sym_Dict(stub_index);
    *new_symbol = *export;
    Sym_Back_Ptr(stub_index) = Sym_Back_Ptr(export_index);
    Sym_ShlImp_Indx(stub_index) = Sym_ShlImp_Indx(export_index);

    Sym_Related_Stub(stub_index) = Sym_Related_Stub(export_index);
    Sym_Related_Stub(export_index) = stub_index;

    switch (export->symbol_type) {
        case ST_CODE:	/* these happen, like R_DATA_PLABELs on _sr4_export */
        case ST_ENTRY:
            new_symbol->symbol_type = ST_STUB_ENTRY;
            break;
        case ST_PRI_PROG:
            new_symbol->symbol_type = ST_STUB_PRI_PROG;
            break;
        case ST_SEC_PROG:
            new_symbol->symbol_type = ST_STUB_SEC_PROG;
            break;
    }

    new_symbol->check_level = min(export->check_level, parmcheck);
    new_symbol->arg_reloc   = all_gen_regs(export->arg_reloc);
    new_symbol->symbol_info = export_index;
    el_bits = export->symbol_value & 03;

    if (base_file_name != NULL && !relinkable)
        /* dynamic loading */
        new_symbol->symbol_value = 
	  bld_dl_export_stub_rec(export_index)|el_bits;
    else if (building_incomp_exec || building_shlib)
        /* shared libaries */
        new_symbol->symbol_value = 
	    bld_shlib_export_stub_rec(export_index) | el_bits;
    else
        new_symbol->symbol_value =
            bld_export_stub_rec(export_index, stub_subsp) | el_bits;

    if (export->symbol_type == ST_PRI_PROG && !building_incomp_exec) {
	if (entry_symbol_index != BAD_SYM &&
	    entry_symbol_index != export_index)
	   Sym_Dict(entry_symbol_index).symbol_type = ST_STUB_SEC_PROG;
	entry_symbol_index = stub_index;
    }

    /*
    ** Since we added a new symbol dictionary entry for the export stub
    ** we also need to add any extension records to follow the stubs 
    ** symbol dictionary entry if there are any.
    **
    ** Added declaration for stub_extension_index.
    ** Since the stub_index is getting returned, we dont want to overwrite
    ** the stub_index for the actual export stub which would result in the
    ** return of the stub index of the extension records.
    */
    if (new_symbol->check_level >= 1) {
	int stub_extension_index;

	while (++export_index < sym_dict_size) {
	    export = &Sym_Dict(export_index);
	    if (export->symbol_type != ST_SYM_EXT && 
		export->symbol_type != ST_ARG_EXT)
		break;
	    stub_extension_index = symbol_allocate(stub_subsp);
	    new_symbol = &Sym_Dict(stub_extension_index);
	    *new_symbol = *export;
    	    Sym_Back_Ptr(stub_extension_index) = 
		Sym_Back_Ptr(export_index);
    	    Sym_ShlImp_Indx(stub_extension_index) = 
		Sym_ShlImp_Indx(export_index);
    	    Sym_Related_Stub(stub_extension_index) = 
		Sym_Related_Stub(export_index);
        }
    }

    return stub_index;
} /* end add_export_stub */

/* 
** Call when a UNIVERSAL, ENTRY or CODE symbol is found and the allocate
** stubs flag is set or dynamic loading is in effect.
** return the stub_index, so the caller can use it.
** Also, check first to see if we've already built an export stub
** for it; if so, just return it, don't build a new one 
*/

/* 
 *
 * This function is called when a UNIVERSAL ENTRY or CODE symbol is
 * found and an export stub is ordinarily necessary, but the presence
 * of the no relocation and long return bits eliminate the need for
 * an actual stub. 
 *
 * Several routines downstream seem to get confused by a code symbol
 * that does not have an export stub.
 *
 * This routine goes through the motions of allocating an export 
 * stub, but really only creates the symbol and points it back at
 * the actual routine, which doesn't need the export stub.
 *
 * Most of this code was lifted from add_export_stub().
 *
 */

int add_null_export_stub (int export_index)
{
    struct  symbol_dictionary_record *export, *new_symbol;
    int stub_index;
    int el_bits;  /* Execution Level Bits - low-order two bits of code addr */
    int stub_subsp;

    if ((stub_index = find_export_stub_sym (export_index)) != BAD_SYM)
	return stub_index;

    export = &Sym_Dict(export_index);
    stub_subsp = Sym_Subsp(export_index);

    /* lose check in shlib use */
    if (!(building_shlib || building_incomp_exec)) 
    	if ((export->symbol_type != ST_ENTRY &&
	     export->symbol_type != ST_PRI_PROG &&
	     export->symbol_type != ST_SEC_PROG) ||
	    export->symbol_scope != SS_UNIVERSAL || 
	    (!(alloc_stubs_xl || alloc_stubs_ux) && base_file_name == NULL))
	    internal_error(BAD_SYM_EXP_STUB,
		           Subsp_Misc(stub_subsp).file_name,
		           export->name.n_name, 
			   0);

    stub_index = symbol_allocate(stub_subsp);
    new_symbol = &Sym_Dict(stub_index);
    *new_symbol = *export;
    Sym_Back_Ptr(stub_index) = Sym_Back_Ptr(export_index);
    Sym_ShlImp_Indx(stub_index) = Sym_ShlImp_Indx(export_index);

    Sym_Related_Stub(stub_index) = Sym_Related_Stub(export_index);
    Sym_Related_Stub(export_index) = stub_index;

    switch (export->symbol_type) {
        case ST_CODE:	/* these happen, like R_DATA_PLABELs on _sr4_export */
        case ST_ENTRY:
            new_symbol->symbol_type = ST_STUB_ENTRY;
            break;
        case ST_PRI_PROG:
            new_symbol->symbol_type = ST_STUB_PRI_PROG;
            break;
        case ST_SEC_PROG:
            new_symbol->symbol_type = ST_STUB_SEC_PROG;
            break;
    }

    new_symbol->check_level = min(export->check_level, parmcheck);
    new_symbol->arg_reloc   = all_gen_regs(export->arg_reloc);
    new_symbol->symbol_info = export_index;
    el_bits = export->symbol_value & 03;

    /* There isn't actually a stub, so point this symbol back to */
    /* the actual routine.                                       */
    new_symbol->symbol_value = Sym_Value(export_index);

    if (export->symbol_type == ST_PRI_PROG && !building_incomp_exec) {
	if (entry_symbol_index != BAD_SYM &&
	    entry_symbol_index != export_index)
	   Sym_Dict(entry_symbol_index).symbol_type = ST_STUB_SEC_PROG;
	entry_symbol_index = stub_index;
    }

    /*
    ** Since we added a new symbol dictionary entry for the export stub
    ** we also need to add any extension records to follow the stubs 
    ** symbol dictionary entry if there are any.
    **
    ** Added declaration for stub_extension_index.
    ** Since the stub_index is getting returned, we dont want to overwrite
    ** the stub_index for the actual export stub which would result in the
    ** return of the stub index of the extension records.
    */
    if (new_symbol->check_level >= 1) {
	int stub_extension_index;

	while (++export_index < sym_dict_size) {
	    export = &Sym_Dict(export_index);
	    if (export->symbol_type != ST_SYM_EXT && 
		export->symbol_type != ST_ARG_EXT)
		break;
	    stub_extension_index = symbol_allocate(stub_subsp);
	    new_symbol = &Sym_Dict(stub_extension_index);
	    *new_symbol = *export;
    	    Sym_Back_Ptr(stub_extension_index) = 
		Sym_Back_Ptr(export_index);
    	    Sym_ShlImp_Indx(stub_extension_index) = 
		Sym_ShlImp_Indx(export_index);
    	    Sym_Related_Stub(stub_extension_index) = 
		Sym_Related_Stub(export_index);
        }
    }

    return stub_index;
} /* end add_export_stub */

int bld_export_stub_rec(export_index, stub_subsp)
int export_index;
int stub_subsp;
{
    int    dummy_relocation, arg_reloc_size, rtn_reloc_size;
    struct  stub_record		       *stub;
    struct  symbol_dictionary_record   *export;
    struct  subspace_dictionary_record *subsp;
    struct  subsp_misc_record	       *misc;

    export = &Sym_Dict(export_index);
    subsp  = &Subsp_Dict(stub_subsp);
    misc   = &Subsp_Misc(stub_subsp);

    /* For PA2.0 code, a parameter relocation stub may be added 	*/
    /* later so we always create the export stub in case we end up 	*/
    /* needing it later unless no_relocation is also TRUE.
    /* if both has_long_return and no parms reloc then no need to */
    /* build export stub. Just return symbol value w/o add stub.  */
    /* For PA2.0, a parameter relocation stub may be added later  */
    /* so we always create the export stub in case we end up      */
    /* needing it later unless no_relocation is also TRUE.        */
    if(export->has_long_return && export->no_relocation ) {

#ifdef DEBUG
	fprintf(stderr,
	"Export stub not built for %s\n", Sym_Name(export_index));
										#endif /* DEBUG */
       return(symbol_value(export_index));
    }

    stub   = stub_add(misc);

    dummy_relocation = all_gen_regs(export->arg_reloc);

    /* determine the size of the stub */
    get_stub_info(dummy_relocation, 
		  export->arg_reloc,
		  &arg_reloc_size, 
		  &rtn_reloc_size);

    if(export->has_long_return && (rtn_reloc_size == 0)){
       /* OpenGL support. Export stubs w/otrapping procedure return. */
       stub->type    = HPUX_EXPORT_STUB_NO_RP;
    }
    else {
       if (arg_reloc_size + rtn_reloc_size > 0)
	   stub->type	 = EXPORT_RELOC_STUB;
       else
	   stub->type	 = EXTERN_EXPORT_STUB;
    }
    stub->subsp_index	 = stub_subsp;
    stub->subsp_off	 = misc->next_stub_offset;
    if(stub->type == HPUX_EXPORT_STUB_NO_RP) 
       stub->length	 = arg_reloc_size + rtn_reloc_size + 2*WORDSIZE;
    else
       stub->length	 = arg_reloc_size + rtn_reloc_size + 7*WORDSIZE;
    stub->arg_reloc_size = arg_reloc_size;
    stub->rtn_reloc_size = rtn_reloc_size;
    stub->caller_reloc	 = dummy_relocation;
    stub->callee_reloc	 = export->arg_reloc;

    /* Fix the pc-relative branch target */
    stub->stub_symbol  = export_index;

    /* Update the subspace definition */
    subsp->subspace_length       += stub->length;
    subsp->initialization_length += stub->length;
    misc->next_stub_offset       += stub->length;

    return (stub->subsp_off);
} /* end bld_export_stub_rec */

void bld_export_stub(stub, stubs_location)
struct stub_record *stub;
int stubs_location;

/* External export code sequence.

	(* Parameter relocation code *)
	bl      disp, rp                ; Branch to local entry point
	dep	r31,bit31,len2,rp	; Deposit caller's exec level
	(* Function return relocation code *)
	ldw	sr4_save(sp),tmp1	; Restore SR4
	ldw	rp_prime_save(sp),rp	; Restore return address (RP')
	mtsp	tmp1,sr4		; Restore SR4, part II
	be	0(sr4,rp)		; Return to caller
	ldw	dp_save(sp),dp		; Restore DP
*/

{
    int *stubs_ptr;
    int sym_index;

    sym_index = stub->stub_symbol;
    stubs_ptr = &stub_area[stub->subsp_off / sizeof(int)];

    if (stub->arg_reloc_size != 0)
	stubs_ptr = spit_arg_reloc_code(stubs_ptr, stub);

    stubs_location += WORDSIZE*(stubs_ptr - stub_area + 2);

    *stubs_ptr++ = fix_format(BL_DISP,
                              sym_index == BAD_SYM ?
                                  stub->stub_constant :
                                  symbol_value(sym_index) - stubs_location,
                              i_rel17,
			      SR_IS_VALID); /* not used */
    *stubs_ptr++ = SET_EXEC_LEVEL;

    if (stub->rtn_reloc_size != 0)
	stubs_ptr = spit_rtn_reloc_code(stubs_ptr, stub);

    if(stub->type != HPUX_EXPORT_STUB_NO_RP){
       /* OpenGL support: If not HPUX_EXPORT_STUB_NO_RP then  */
       /* Restore return address from stack and branch external */
       *stubs_ptr++ = UNSTACK_SR4;
       *stubs_ptr++ = RESTORE_RP_PRIME;
       *stubs_ptr++ = RESTORE_SR4;
       *stubs_ptr++ = EXTRN_RETURN;
       *stubs_ptr   = RESTORE_DP;
    }
} /* end bld_export_stub */

void add_import_stub(import_index)
int import_index;

/* 
** Call when an UNSAT, CODE symbol is not satisfied and the allocate stubs
** flag is set.
** Note: symbol info in the new symbol is the XRT offset.
*/
{
    struct symbol_dictionary_record *import;
    extern int all_gen_regs();

    import = &Sym_Dict(import_index);

    if (!building_shlib && !building_incomp_exec)
					/* don't do check when forcing stubs */
    if (import->symbol_type != ST_CODE ||
	import->symbol_scope != SS_UNSAT ||
	!(alloc_stubs_xl || alloc_stubs_ux))
	internal_error(BAD_SYM_IMP_STUB,
		       Subsp_Misc(Sym_Subsp(import_index)).file_name,
		       import->name.n_name, 
		       0);

    /* print warning for import stubs */
    if (verbose & V_STUBS)
        printf( ld_gets(1, 1204, "Import stub from %s(%s) to %s\n"),
		Subsp_Misc(Sym_Subsp(import_index)).file_name,
		Subsp_Dict(Sym_Subsp(import_index)).name.n_name,
		import->name.n_name);

    /* scope may be changed later (in assign_xrt_offsets) to SS_LOCAL */
    import->symbol_scope = SS_EXTERNAL;
    import->symbol_type	= ST_STUB_IMPORT;
    if (parmcheck < import->check_level)
	import->check_level = parmcheck;
    import->arg_reloc = all_gen_regs(-1);
    /* assign import->symbol_info later */
    /* assign import->symbol_value later */
} /* end add_import_stub */

/* used to check if stub is sharable */
extern int subspace_match();

#define DATA_PLABEL -2

/*
***************************************************************************
**
**   import_stub_needed()
**
**   Routine determines if an import stub needs to be built or an existing
**   stub can be reached.  If an import stub does need to be built
**   bld_import_stub_rec() is called to build the stub.
**
**   When a symbol is determined to be an UNSAT CODE symbol and we are
**   building an incomplete executable, the symbol is marked as a
**   ST_STUB_IMPORT and its subspace is set to BAD_SUBSP.
**   See add_import_stub() and shlib_build_tables().  import_stub_needed()
**   will build a stub for this marked symbol or try to share an existing
**   stub for this situation and remap the existing symbol to the shared
**   symbol.
**
**   If a import stub symbol has been built and it resides in the current
**   subspace then we will always use it.  The assumption is that if we
**   dont reach it from within the subspace a long branch stub will be
**   generated to reach the import stub. 
**
**   If an import stub symbol has been built and it resides in a subspace
**   other than the current subspace we will check to see if we can reach
**   it from where we are.  If we can we do nothing since it reaches.
**
**   If we cant reach the import stub symbol we will traverse an ordered
**   list of stubs for this symbol to determine if the next closest stub
**   can be reached.  If so we will change to fixup to reference this
**   stub.
**
**   If we can't find an import stub which works we will build a stub and
**   possibly allocate a new symbol.
**
***************************************************************************
*/
static int import_stub_needed(int sym_index, Boolean absolute)
{
    int new_sym_index;
    struct symnode *prev_ptr, *symnode_ptr;
    struct stub_record *stub_ptr; 
    struct symbol_dictionary_record *sym_ptr;
    struct subspace_dictionary_record *fix_subsp, *subsp;
    int value;            /* distance to import stub */
    int force_sym_alloc = FALSE;

    int i, t; 
    /* 
    ** sym_index already remapped 
    */
    new_sym_index = BAD_SYM;

    /*
    ** Mark the symbol as seen so assign_xrt_offsets() will assign an xrt
    ** to it, even though no stub is built, so the DATA Plabel can be
    ** resolved by the XL Loader. If NO code reference was ever seen,
    ** assign_xrt_offsets() will NOT change the symbol to NULL.
    */
    if (space_array[Subsp_Dict(fixup_subsp).space_index].is_private) {
	Sym_Misc(sym_index).import_data_plabel = TRUE;
	if (Sym_Subsp(sym_index) == BAD_SUBSP)
            Sym_Subsp(sym_index) = fixup_subsp;  /* set only if prev. unset */

        /* 
        ** probably a DATA_PLABEL fixup - no-op rather than 
        ** try to build a stub in data space 
        */
	return(BAD_SYM);  
    }

    /*
    ** If this symbol has been marked as an import stub and the symbol
    ** import stub does not reside in the current subspace being fixed
    ** up or the stub has not been built then we either build an import
    ** stub or just share an existing stub.
    **
    ** Note! that shlib_build_tables() will mark an UNSAT code symbol as
    ** an added import stub (ST_STUB_IMPORT) refer to add_import_stub().
    ** However, the stub does not get built when add_import_stub() is called
    ** it is built when we check_for_stubs().  It can be determined that
    ** the stub is built when the symbol misc records subspace index is
    ** no longer BAD_SUBSP.
    */
    if (Sym_Dict(sym_index).symbol_type == ST_STUB_IMPORT &&
        Sym_Subsp(sym_index) != fixup_subsp) {

        /*
        ** If this is a data plabel then it has a valid subspace
        ** (from above) but does NOT have a stub!  Now it will be
        ** treated like it has not been seen yet Note that this forces
        ** us to overite Sym_Subsp when we actually build the stub
        ** (see below) which is fine!
        **
        ** The subsp is ONLY needed when no stubs were created for this
        ** symbol but the data plabel WAS seen.
        */
	if (Sym_Misc(sym_index).import_data_plabel == TRUE) {
	     Sym_Subsp(sym_index) = BAD_SUBSP;
        }

        /* Get pointer to fixup subspace--doesn't change  */
        fix_subsp = &Subsp_Dict(fixup_subsp);

        /*
        ** If this symbol refers to an existing stub (the symbols
        ** stubs subspace will not be BAD_SUBSP), then let's see if we
        ** reach the stub without searching the import stub list for
        ** a stub which is closer.  If we don't reach we will have to
        ** find one that does or else build a new import stub symbol
        **
        ** We must check the subspaces to see if the attributes
        ** match prior to allowing a stub to be shared (re priv
        ** level and memory resident stub sharing problem.)
        **
        **/
        if (Sym_Subsp(sym_index) != BAD_SUBSP) {

	    subsp = &Subsp_Dict(Sym_Subsp(sym_index));

	    if (!(building_shlib && do_fdp_measure) && 
	       (subspace_match(fix_subsp, subsp))) {

                /*
                ** Determine the distance to the existing stubs postion
                ** from the current position.
                **
                ** we need to use the subspace of the __symbol__, not where
                ** the fixup takes place!  See for details.
                */
                value = branch_dot -
		           (Subspace_Virtual_Offset (Sym_Subsp(sym_index)) + 
			      Sym_Value (sym_index));
#if 0
                value = branch_dot -
		        (Subspace_Virtual_Offset (fixup_subsp) + 
			Sym_Value (sym_index));
#endif /* 0 */

                /*
                ** Check to see if we can reach the stub. 
		**
		** Added branch reach padding to avoid multiple passes
		** over the fixups.
                */
                if (absolute || 
		    (!OFL((value<0 ? -value : value)+lb_reach_pad,19))) {

                    /*
                    ** If this symbol can be reached with the current
                    ** instruction then we are already sharing this
                    ** sym with another subspace we point to valid
                    ** symbol,so don't remap or change fixup.
                    */
                    return(BAD_SYM);
		}
	    }
        }

        /*
        ** Get the created import stub list
        */
        prev_ptr = Sym_Back_Ptr(sym_index);
        symnode_ptr = prev_ptr->same;
        stub_ptr = Sym_Import_Stub(prev_ptr->index);

        /*
        ** traverse ordered stub list to determine if any of the import
        ** stubs can be used.   if symnode_ptr is null then we do not
        ** have a same list (of symnodes) so we will allocate a new symbol
        ** Note! that the stub list is an ordered list and that the
        ** closest stub will be the first one found.  If its subspace
        ** attributes match it better reach or we will have to build
        ** another import stub.
        */
        for ( ; ((stub_ptr != NULL) && (symnode_ptr != NULL)); 
             stub_ptr = stub_ptr->next_import_stub) {

            /* Get symbol for this stub */
	    sym_ptr = &Sym_Dict(stub_ptr->stub_symbol);

	    subsp = &Subsp_Dict(stub_ptr->subsp_index);

            /*
            ** If this stub's subsp attributes don't match find another
            ** stub that does.
            */
	    if (!subspace_match(fix_subsp, subsp)) {
	        continue;
	    }

            /*
            ** subsp attributes match, so make sure stub is within range
            ** start of subspace + offset (imports do not have arg reloc)
            **
            ** Calculate the branch distance as the current position
            ** minus the potential shared stubs position.
            */
	    value = branch_dot -
		    (Subspace_Virtual_Offset(stub_ptr->subsp_index) + 
	            stub_ptr->subsp_off);

            /*
            ** Check to see if this stub can be reached if we are
            ** using an absolute branch or a short branch.  Added
            ** check for the long branch.
	    **
	    ** Added branch reach padding to avoid multiple passes
	    ** over the fixups. 
            */
            if ( absolute ||
                 (!OFL((value<0 ? -value : value)+lb_reach_pad,19)) ) {

                /*
                ** Success! we found one.  Now determine if it is in
                ** the current subspace. If so then we'll just change
                ** the fixup to reference this stub symbol.  If its
                ** not we'll just remap the symbol to the shared symbol
                ** and leave the fixup unchanged.
                */
		if (stub_ptr->subsp_index != fixup_subsp) {

		    /* 
		    ** if we're going to put counting code in this stub, ensure
		    ** we're only counting from one proc to another.  Within
		    ** a subpace is OK (e.g., multiple calls to printf from a
		    ** given proc), assuming that proc==subspace for
		    ** instrumentation purposes.  Only exported symbols are to
		    ** be instrumented, as pure imports aren't arcs. 
		    */
		    if (building_shlib && do_fdp_measure &&
			(shlib_match(out_hash_tbl, 
				     out_hash_tbl_len,
			 	     out_export_list, 
				     out_shlstr_table,
				     sym_ptr->NAME_PT, 
				     ST_CODE) != BAD_SYM))
	                break;	/* out of loop */

	            if (verbose & V_STUBS) {
	                printf(ld_gets(1, 
				       1205, 
				       "Sharing sym %s (index %d) with %s "
					   "(index %d)"),
			       Sym_Dict(sym_index).name, 
                               sym_index, 
			       sym_ptr->NAME_PT, 
                               stub_ptr->stub_symbol);
			printf(ld_gets(1, 1206, " across subspaces\n"));
                    }     

                    if (stub_ptr->subsp_index == BAD_SUBSP) {
	                internal_error(BAD_STUB_PTR_SUBSPACE);
		    } else if (Sym_Subsp(sym_index) == BAD_SUBSP) {

                        /*
                        ** Remap this sym to shared sym and don't try
                        ** and change fixup
                        **
			** Run down the related stub chain, and change
			** any reference to the symbol we are remmapping
			** to the symbol we are remapping it to. 
                        */
			int sym;

			for(sym=stub_ptr->stub_symbol; 
                            sym != -1;
			    sym=Sym_Related_Stub(sym)) {
			    if (Sym_Related_Stub(sym) == sym_index) {
			        Sym_Related_Stub(sym) =
				    Sym_Related_Stub(sym_index);
                            }
			}
                        /* 
                        ** We remap code unsat to stub ext.
                        ** Stub ext will have 0 extension records so nuke
                        ** code unsat extension records, reset bit to false.
                        ** This way we won't have extra extension records
                        ** "floating around" in the output file!
                        */
			Remap_Sym_Records (sym_index, stub_ptr->stub_symbol);
                        if (sym_index+1 < sym_dict_size) {
                            for (i = sym_index+1; i < sym_dict_size; i++) {
                                 t = Sym_Dict(i).symbol_type;
                                 if (t != ST_SYM_EXT && t != ST_ARG_EXT)
                                     break;
                                 Free_Sym_Record (_sym_record[i]);
                                 _sym_record[i] = &null_symbol_record;
                                 
			    }
                            /* reset bit if symbol has ext recs */
                            if (i > sym_index+1)
                                Sym_Misc (sym_index).has_ext_recs = FALSE;
			}
		        return (BAD_SYM);
                        
		    } else { /* sym subsp = bad subsp */

                        /*
                        ** This symbol(sym_index) is in a different
                        ** subspace.
                        **
                        ** Since we cannot update fixups to point to a
                        ** symbol associated with a different subspace
                        ** lets create a new symbol in this subspace and
                        ** then remap that symbol to the one in the other
                        ** subspace.
                        */
			force_sym_alloc = TRUE;
			break;
		      }
                } else { 

                    /*
                    ** We are in the same subspace, change fixup
                    */
	            if (verbose & V_STUBS) {
	                printf(ld_gets(1, 
				       1207, 
				       "Sharing sym %s (index %d)"
			       		   " with %s (index %d) \n"),
			       Sym_Dict(sym_index).name, 
                               sym_index, 
			       sym_ptr->NAME_PT, 
                               stub_ptr->stub_symbol);
		    }

                    new_sym_index = stub_ptr->stub_symbol;
		    return(new_sym_index);
                }

            } else {

                /*
                ** Virtual addresses are already too far away to reach.
                */
	        break;				/* out of loop */
	    }

        } /* end for */

        /*
        ** We couldn't share an existing stub so we will build a stub and/or
        ** allocate a new symbol
        */
        if ((Sym_Subsp(sym_index) == BAD_SUBSP) && !force_sym_alloc) {

            /*
            ** still original symbol, just flag the subspace
            */
            Sym_Subsp(sym_index) = fixup_subsp;

            /*
            ** build the stub. parm 2 specifies that the call is not
            ** from add_promo_stub
            */
            bld_import_stub_rec(sym_index, FALSE);

        } else {

	    if (verbose & V_STUBS) {
	        if (force_sym_alloc)
	            printf(ld_gets(1, 
				   1208, 
				   "Forcing creation of symbol"
				       " - old sym %s (index %d)\n"),
			   Sym_Dict(sym_index).name, 
                           sym_index);
	    }

            /*
            ** Couldn't share so create a new sym
            */

            /* no match, so allocate new symbol, copy old */
            new_sym_index = symbol_allocate(fixup_subsp);
            Sym_Dict(new_sym_index) = Sym_Dict(sym_index);
            Sym_Misc(new_sym_index) = Sym_Misc(sym_index);

            /* 
            **      for the explanation of why the next 3 lines of code
            **      have been put here, see description in the function
            **      copy_orig_sym_for_imp_stub().
            **
            **      new_sym_index is the index of the import stub
            */

	    /*   Since we are not doing a remap, the remap
	     *              array should stay with the *original* symbol
	     *  	    not the copy. Otherwise, we leave the remap
	     *              information in a very inconsistent state.
	     *              The mapped_to_a array says that several symbols
	     *              are mapped to copy, when in reality, they are
	     *              mapped to the original. If we remap the copy
	     *              to another symbol, we drag along all of the
	     *              symbols in the mapped to array, even though
	     *              we never actually mapped the original to the
	     *              copy.
	     */

	    Sym_Misc(new_sym_index).mapped_to_a = NULL;
	    Sym_Misc(new_sym_index).mapped_to_cnt = 0;
	    Sym_Misc(new_sym_index).mapped_to_sz = 0;

	    /* Correct fields that shouldn't be copied */
	    Sym_Subsp(new_sym_index) = fixup_subsp;
	    Sym_Related_Stub(sym_index) = new_sym_index;  /* link into list */

            /*
            ** Will be changed to LOCAL in assign xrt offsets unless this
            ** is the first symbol on the link list
            */
	    Sym_Dict(new_sym_index).symbol_scope = SS_EXTERNAL;

            /*
            ** Set check_level to 0 for this sym so no symbol or argument
            ** extension records are expected
            */
	    Sym_Dict(new_sym_index).check_level = 0;

            /* allocate new node */
            symnode_ptr = get_node(prev_ptr->name,
				       prev_ptr->mq,
                                       Sym_Qual_Name(prev_ptr->index),
                                       prev_ptr->hashval,
                                       new_sym_index,
                                       ST_CODE,
                                       prev_ptr->len);
            /* link node into list */
            symnode_ptr->same = prev_ptr->same;
            prev_ptr->same = symnode_ptr;
	    if (force_sym_alloc) {
		/* 
                ** remap this new sym to sym in other subspace.
                **
                ** Run down the related stub chain, and change
		** any reference to the symbol we are remmapping
		** to the symbol we are remapping it to. 
                */
                int sym;

                for(sym=stub_ptr->stub_symbol; 
                    sym != -1;
                    sym=Sym_Related_Stub(sym)) {
                    if (Sym_Related_Stub(sym) == new_sym_index) {
                         Sym_Related_Stub(sym) = 
                             Sym_Related_Stub(new_sym_index);
                    }
                }
		Remap_Sym_Records(new_sym_index,stub_ptr->stub_symbol);
            } else { 
                /*
                ** Build the stub. parm 2 specifies that the call is not
                ** from add_promo_stub()
                */
                bld_import_stub_rec(new_sym_index, FALSE);
            }
        } 
    }
    return (new_sym_index);
} /* end import_stub_needed */

void bld_import_stub_rec(sym_index, from_add_promotion)
int sym_index;
int from_add_promotion;
{
    int subsp_index;
    struct  stub_record			*stub;
    struct  subspace_dictionary_record	*subsp;
    struct  symnode  	                *sym_ptr;
    struct  subsp_misc_record		*misc;

    /* 
    ** this will be fixup_subsp for UNSAT fixups but it will be the target's
    ** subsp for promotion stubs (unless they are forced promotion stubs)
    */
    subsp_index = Sym_Subsp(sym_index);

    subsp  = &Subsp_Dict(subsp_index);
    misc   = &Subsp_Misc(subsp_index);

    /* don't actually build a stub in DATA area! */
    /* in this case, the symbol_value field is undefined */
    /* This is OK, since the only time you would need the symbol value */
    /* is in the application of the fixup.  But this must be a DATA_PLABEL */
    /* in order to be in the DATA area, and since extern_plabels is TRUE,  */
    /* you only care about the xrt_offset in the symbol_info field         */

    if (space_array[subsp->space_index].is_private)
        return;

    stub   = stub_add(misc);
    if (verbose & V_STUBS) {
       printf(ld_gets(1, 
		       1209, 
		       "Building import stub - sym %s (index %d)\n"),
	      Sym_Dict(sym_index).name, sym_index);
    }

    /* HP-UX shared library stub types */
    if (building_shlib) {
	/* OpenGL support import stubs w/o STW rp */
	if(Sym_has_long_return(sym_index) && Sym_no_relocation(sym_index)){
	   stub->type	 = SHLIB_IMPORT_STUB_NO_RP;
	   if(pcx_u_pa2_0)
              stub->length	 = PA2_0_IMPORT_STUB_SIZE_NO_RP;
	   else
              stub->length	 = HPUX_IMPORT_STUB_SIZE_NO_RP;
	}
        else {
	   stub->type	 = SHLIB_IMPORT_STUB;
	   if(pcx_u_pa2_0)
              stub->length	 = PA2_0_IMPORT_STUB_SIZE;
	   else
              stub->length	 = HPUX_IMPORT_STUB_SIZE;
	}

	if (!OFL (Sym_Dict(sym_index).symbol_info+4, 14))
	    stub->length -= WORDSIZE;  /* ADDIL will be eliminated */
		    /* 
		    ** if we're going to put counting code in this stub, ensure
		    ** we're only counting from one proc to another.  Within
		    ** a subpace is OK (e.g., multiple calls to printf from a
		    ** given proc), as we already assume that proc==subspace 
		    ** for instrumentation purposes.  Only exported symbols 
		    ** are to be instrumented, as pure imports aren't arcs.
		    */
	if (do_fdp_measure &&
	    (shlib_match(out_hash_tbl, 
			 out_hash_tbl_len,
			 out_export_list,
			 out_shlstr_table,
			 Sym_Name(sym_index), 
			 ST_CODE) != BAD_SYM)) {
	    /* 
	    ** adjust the length to allow for insertion of a shlib FDP (PBO)
	    ** counter stub, less the shlib long branch stub code. 
	    */
	    stub->length += (SHL_FDP_STUB_SIZE - SHL_LB_STUB_SIZE);
    	    /* get the counter location for the stub */
    	    stub->count_index =
		get_fdp_counter(Sym_Subsp(find_orig_sym(sym_index)),
				fixup_subsp);
	}
    } else if (building_incomp_exec) {
	/* OpenGL support import stubs w/o STW rp */
	if(Sym_has_long_return(sym_index) && Sym_no_relocation(sym_index)){

	   stub->type	 = HPUX_IMPORT_STUB_NO_RP;
	   if(pcx_u_pa2_0)
              stub->length	 = PA2_0_IMPORT_STUB_SIZE_NO_RP;
	   else {
	      /**************************************************/
	      /* PA 1.x import stub for incomplete a.out       */
	      /* If +Ouse_sr7 flag is on then using SR7 for     */
	      /* space register instead of loading it from the  */
	      /* target address, thus the stub's length is      */
	      /* reduced by 2 intruction (8bytes).              */
	      /**************************************************/
              stub->length	 = HPUX_IMPORT_STUB_SIZE_NO_RP;
	      if(use_sr7_import)
		 stub->length = stub->length - 8;
	   }
	}
	else {
	   stub->type	 = HPUX_IMPORT_STUB;
	   if(pcx_u_pa2_0)
              stub->length	 = PA2_0_IMPORT_STUB_SIZE;
	   else {
              stub->length	 = HPUX_IMPORT_STUB_SIZE;
	      /**************************************************/
	      /* Length is reduced by 2 intruction (8bytes)     */
	      /* if +Ouse_sr7 flag is on.                       */
	      /**************************************************/
	      if(use_sr7_import)
		 stub->length = stub->length - 8;
	   }
	}

	/* if (LD'ltoff+lt_ptr == 0) */
	if (fix_field( Sym_Dict(sym_index).symbol_info +
		           (Subspace_Virtual_Offset(PLT_subsp_index) - 
		            symbol_value(dollar_global)), 
		       0, e_ldsel) == 0)
	    stub->length -= WORDSIZE;  /* ADDIL will be eliminated */
    } else
    /* MPE import stub */
    {
	stub->type	 = EXTERN_IMPORT_STUB;
        stub->length	 = 8*WORDSIZE;
    }
    stub->subsp_index	 = subsp_index;
    stub->subsp_off	 = misc->next_stub_offset;
    stub->arg_reloc_size = 0;
    stub->rtn_reloc_size = 0;
    stub->caller_reloc	 = 0;
    stub->callee_reloc	 = 0;

    /* point back to the symbol, so we can put in the xrt offset later... */
    stub->stub_symbol  = sym_index;

    /* Update the subspace definition */
    subsp->subspace_length       += stub->length;
    subsp->initialization_length += stub->length;
    misc->next_stub_offset       += stub->length;

    Sym_Dict(sym_index).symbol_value = stub->subsp_off;

    /* Link in latest import stub in ordered list of stubs for this symbol */
    if (!from_add_promotion) {
	/* This stub is from an unsat (not from a promotion stub) */
        sym_ptr = Sym_Back_Ptr(sym_index);
        stub->next_import_stub = Sym_Import_Stub(sym_ptr->index);
        Sym_Import_Stub(sym_ptr->index) = stub;
    }
} /* end bld_import_stub_rec */

int fdp_counting_stub_needed(sym_index)
int sym_index;
{
    int stub_index;
    int sym_subsp;
    struct symbol_dictionary_record *sym, *new_symbol;
    struct stub_record *stub;
    struct subspace_dictionary_record *subsp;
    struct subsp_misc_record *misc;

    /* sym_index already remapped */

    assert(FDP_COUNTING_STUB_POSSIBLE);

    sym_subsp = Sym_Subsp(sym_index);

    /* The branch_counter_sym is set for fdp in fixups.c,
     * count_unwind_recover_size. We don't want this
     * stub if it was not found in the _LB_COUNT area.
     *
     * Check any other symbol for BAD_SYM.
     */
    if (branch_counter_sym == BAD_SYM || 
        sym_subsp == BAD_SYM ||
        fixup_subsp == BAD_SYM)
            return (BAD_SYM);

    /* don't count calls within the same subspace! */
    if (sym_subsp == fixup_subsp)
        return (BAD_SYM);

    /* don't count calls to/from FLUFF */
    if (Subsp_Dict(sym_subsp).sort_key == 32 ||
        Subsp_Dict(fixup_subsp).sort_key == 32)
        return (BAD_SYM);

    /* look for an existing stub from the same subspace to same target */

    for (stub_index = Sym_Related_Stub(sym_index);
         stub_index != BAD_SYM;
         stub_index = Sym_Related_Stub(stub_index)) {
        if (Sym_Dict(stub_index).symbol_type == ST_FDP_COUNT &&
            Sym_Subsp(stub_index) == fixup_subsp)
            return (stub_index);
    }

    sym = &Sym_Dict(sym_index);

    /* 
    ** For ST_CODE, if the secondary_def bit is FALSE, then we have 
    ** no guarantee about the calling convention for it. 
    ** So we will not insert any counter stub for it. 
    */
     if (sym->symbol_type == ST_CODE && sym->secondary_def == FALSE )
         return (BAD_SYM);

    /* 
    ** For millicode, there is no point in positioning it within the 
    ** $MILLICODE$ subspace - it's too small.  
    */
    if (sym->symbol_type == ST_MILLICODE) 
        return (BAD_SYM);

    /* 
    ** If it isn't callable, quit now. Guards against building stub to 
    ** all other nonsensical type,s like ST_ABSOLUTE. 
    */
    if (!IS_CALLABLE(sym->symbol_type)) 
        return (BAD_SYM);

    /* put the stub in the fixup's subsp */

    stub_index = symbol_allocate(fixup_subsp);
    new_symbol = &Sym_Dict(stub_index);

    Sym_Related_Stub(stub_index) = Sym_Related_Stub(sym_index);
    Sym_Related_Stub(sym_index) = stub_index;

    *new_symbol = *sym;

    new_symbol->symbol_type = ST_FDP_COUNT;
    new_symbol->symbol_scope = SS_LOCAL;
    new_symbol->check_level = 0;
    new_symbol->symbol_info = fixup_subsp;

    /* now, build the stub record itself */
    subsp = &Subsp_Dict(fixup_subsp);
    misc  = &Subsp_Misc(fixup_subsp);
    stub  = stub_add(misc);

    stub->type           = FDP_COUNTING_STUB;
    stub->length         = (building_shlib ? SHL_FDP_STUB_SIZE : 
			    FDP_STUB_SIZE);
    stub->arg_reloc_size = 0;
    stub->subsp_index    = fixup_subsp;
    stub->subsp_off      = misc->next_stub_offset;
    stub->rtn_reloc_size = 0;
    stub->caller_reloc   = 0;
    stub->callee_reloc   = 0;

    /* get the stub's branch target */
    stub->stub_symbol = sym_index;

    /* get the counter location for the stub */
    stub->count_index = get_fdp_counter(sym_subsp, fixup_subsp);

    subsp->subspace_length += stub->length;
    subsp->initialization_length += stub->length;
    misc->next_stub_offset += stub->length;

    new_symbol->symbol_value = stub->subsp_off;

    return (stub_index);
} /* end fdp_counting_stub_needed */

/*
 * modified get_fdp_counter() and associated data structure to
 * use hash table instead of binary tree.
 */
struct counter_record {
    int subsp1;
    int subsp2;
    unsigned int id;
    struct counter_record * next;
};

struct counter_record **_counter = NULL;
unsigned int fdp_counter_size = 0;

#define LOG_COUNTER_BLK_SIZE    10
#define COUNTER_BLK_SIZE        (1<<LOG_COUNTER_BLK_SIZE)
#define FDP_HASH_TBL_SIZE       5011
struct counter_record * fdp_hash_table[FDP_HASH_TBL_SIZE];

int get_fdp_counter(subsp1, subsp2)
int subsp1, subsp2;
{
    struct counter_record *counter_ptr;
    struct counter_record *prev;
    struct subspace_dictionary_record *temp_subsp;
    int caller_subsp;
    int callee_subsp;

    int i, j, slot;

    caller_subsp = subsp2;
    callee_subsp = subsp1;
    if (subsp2 < subsp1) {
        /* switch subsp1 and subsp2 */
        subsp1 ^= subsp2;
        subsp2 ^= subsp1;
        subsp1 ^= subsp2;
    }

    slot = (subsp1 ^ subsp2) % FDP_HASH_TBL_SIZE;
    prev = counter_ptr = fdp_hash_table[slot]; 
    for ( ; counter_ptr; counter_ptr = counter_ptr->next) {
	if ((counter_ptr->subsp1 == subsp1) && (counter_ptr->subsp2 == subsp2))
	    return counter_ptr->id * WORDSIZE;
	else
	    prev = counter_ptr;
    }

    i = fdp_counter_size >> LOG_COUNTER_BLK_SIZE;
    j = fdp_counter_size & (COUNTER_BLK_SIZE-1);

    /* need to add a new counter record here */
    if (j == 0) {
        /* need to add a new block of counter records here */
        /* allocate the space for the indirect pointer */
        if (i == 0) {
            /* first one */
            _counter = (struct counter_record **)
                emalloc(sizeof(struct counter_record *));
	} else {
            /* subsequent ones */
            _counter = (struct counter_record **)
                erealloc((char *) _counter, 
			 (i+1)*sizeof(struct counter_record *));
        }
        _counter[i] = (struct counter_record *)
                emalloc(COUNTER_BLK_SIZE*sizeof(struct counter_record));
    }

    counter_ptr = &_counter[i][j];
    counter_ptr->subsp1 = subsp1;
    counter_ptr->subsp2 = subsp2;
    counter_ptr->id     = fdp_counter_size;
    counter_ptr->next   = 0;

    if (prev == 0)
	fdp_hash_table[slot] = counter_ptr;
    else
	prev->next = counter_ptr;

    temp_subsp = &Subsp_Dict(Sym_Subsp(branch_counter_sym));
    temp_subsp->file_loc_init_value = 0;
    temp_subsp->subspace_length += 4;

    print_name_of(caller_subsp,FALSE);

    print_name_of(callee_subsp,TRUE);

    return (WORDSIZE * fdp_counter_size++);
} /* end get_fdp_counter */


void get_a_block_if_needed (current_size,size_needed)
int current_size;
int size_needed;
/* Call erealloc to get 1K blocks each time */
{
int allocation_size = 1024;
int number_of_blocks;

    if (fdp_names == NULL) {
       /* This is the first time, allocate 1 block */
       fdp_names = emalloc(allocation_size);
       fdp_names_size = 0;
     } else {
   
       number_of_blocks = (current_size + size_needed)/allocation_size;

       if ((current_size/allocation_size) < number_of_blocks)
           fdp_names = 
		erealloc((char *) fdp_names, 
			 (number_of_blocks + 1) * allocation_size);
     }
} /* get_a_block_if_needed */

extern FDP_find_som_index_this_file();  /* no fdp.h file as yet */

print_name_of (subsp, newline)
int subsp;
Boolean newline;

/* This function prints the name of the subspace as a string and
 * its size as an integer. This is printed to memory as the names are
 * accumulated and when all names are gathered, this area is printed
 * to the subspace LB_STRINGS . This is used by the application to
 * print out its own profile database (FDP).
 */
{
    struct subsp_misc_record *misc;
    struct symbol_dictionary_record *sym;
    unsigned int size_of_object;
    char temp_string[11]; /* temp string for int to string conversions */

    /* in order to cut down on the printing, the normal print is:
        entry_point,size

       if this is a qualified symbol, then the qualifier name is added :
        entry_point:module_name,size

       if this is a local symbol, then the file name is printed as well:
        entry_point:file,size

       if this is a local symbol from a SOM after the first SOM in this file, 
	  then the SOM index is added to the file name as well:
        entry_point:file[SOM_index],size

       if the subspace does not have an entry point (boo hiss), then
       we print:
        ? # ?:file,size

       where # is the subspace number (not very informative)...
    */

    misc = &Subsp_Misc(subsp);

    if (misc->entry_sym == BAD_SYM) {

        /* We have a bad symbol, just write the file it came from */

        /* Write "?" and the subspace number */
        sprintf(temp_string,"?%lu%",subsp);
        size_of_object = strlen (temp_string);
        get_a_block_if_needed (fdp_names_size,size_of_object);
        memcpy (&fdp_names[fdp_names_size], temp_string, size_of_object);
        fdp_names_size = fdp_names_size + size_of_object;

        /* Write the file name */
        size_of_object = strlen (misc->file_name);
        get_a_block_if_needed (fdp_names_size,size_of_object);
        /* Use memcpy rather than strcpy because we don't care
           about the null termination character */
        memcpy (&fdp_names[fdp_names_size], misc->file_name, size_of_object);

    } else {
        sym = &Sym_Dict(misc->entry_sym);

        /* Write the subspace name to memory as a string.
           Strlen does not count the null termination character.  */
        size_of_object = strlen (sym->n_nptr);
        /* If the size_of_object pushes us over the allocation size chunk
           received, then get another area of memory.  */
        get_a_block_if_needed (fdp_names_size,size_of_object);
        /* Use memcpy rather than strcpy because we don't care
           about the null termination character */
        memcpy (&fdp_names[fdp_names_size], sym->n_nptr, size_of_object);
        fdp_names_size += size_of_object;

        if (sym->symbol_scope != SS_UNIVERSAL || (sym->q_nptr != NULL)){

	    /* local symbol - qualify to disambiguate from same sym name in 
	       other subspaces */

	    /* add colon as the qualifier delimiter */
            get_a_block_if_needed (fdp_names_size,sizeof(char));
            memcpy (&fdp_names[fdp_names_size], ":", sizeof(char));
            fdp_names_size += sizeof(char);

            /* If a symbol has the must_qualify flag set then use that
               name rather than the file name as a qualifier.  */
            if (sym->must_qualify || (sym->q_nptr != NULL)) {

               size_of_object = strlen (sym->q_nptr);
               get_a_block_if_needed (fdp_names_size,size_of_object);
               memcpy (&fdp_names[fdp_names_size], 
		       sym->q_nptr, 
		       size_of_object);

            } else {

	       /* use the file name and SOM index number as a qualifier */
               size_of_object = strlen (misc->file_name);
               get_a_block_if_needed (fdp_names_size,size_of_object);
               memcpy (&fdp_names[fdp_names_size], 
		       misc->file_name, 
		       size_of_object);

	       som_index_this_file = 
			FDP_find_som_index_this_file(misc->entry_sym);

	       if (som_index_this_file > 0) {
                   fdp_names_size += size_of_object;

                   /* Write the SOM number in square brackets - if non-zero. */
                   sprintf(temp_string,"[%lu%]",som_index_this_file);
                   size_of_object = strlen (temp_string);
                   get_a_block_if_needed (fdp_names_size,size_of_object);
                   memcpy (&fdp_names[fdp_names_size], 
			   temp_string, 
			   size_of_object);
	        }
            }
            fdp_names_size += size_of_object;
	}
    }

    sprintf(temp_string,
	    ",%lu%",
	    Subsp_Dict(subsp).subspace_length - misc->next_stub_offset);
    size_of_object = strlen (temp_string) + 1; /* +1 to include null byte */
    get_a_block_if_needed (fdp_names_size,size_of_object);
    memcpy (&fdp_names[fdp_names_size], temp_string, size_of_object);
    fdp_names_size += size_of_object;
} /* end print_name_of */

bld_fdp_counting_stub(stub)
struct stub_record *stub;
{

/* FDP counting stub sequence

        addil   0,dp            ; ADDIL_DP
        ldw     0(r1),r31       ; LDW_R1_R31
        addi,=  1,r31,r31       ; ADDI_EQ_1_R31_R31
        stw     r31,0(r1)       ; STW_R31_R1
        ldil    L'0,r1
        be,n    R'0(sr4,r1)
*/
    int *stubs_ptr;
    int value;

    stubs_ptr = &stub_area[stub->subsp_off /sizeof(int)];

    /* value is difference between counter symbol and $global$ */
    value = symbol_value(branch_counter_sym) - symbol_value(dollar_global);
    *stubs_ptr++ = fix_format(ADDIL_DP,
                        fix_field(value, stub->count_index, e_lsel),
                        i_exp21,
                        SR_IS_VALID); /* not used */
    *stubs_ptr++ = fix_format(LDW_R1_R31,
                        fix_field(value, stub->count_index, e_rsel),
                        i_exp14,
                        SR_IS_VALID); /* not used */
    *stubs_ptr++ = ADDI_EQ_1_R31_R31;
    *stubs_ptr++ = fix_format(STW_R31_R1,
                        fix_field(value, stub->count_index, e_rsel),
                        i_exp14,
                        SR_IS_VALID); /* not used */

    value = symbol_value(stub->stub_symbol);

    *stubs_ptr++ = fix_format(LDIL_R1,
                        fix_field(value, 0, e_lsel),
                        i_exp21,
                        SR_IS_VALID); /* not used */
    *stubs_ptr   = fix_format(BE_SR4_R1_NULL,
                        fix_field(value, 0, e_rsel),
                        i_abs17,
                        GET_QUAD(value)); /* fix sr bits for target quadrant */
} /* end bld_fdp_counting_stub */

/* 
** emit actual code for the counter part of a shlib FDP counter stub 
** this can be used in either an explicit shlib FDP counter (long branch) stub,
** or as the FDP component of an import stub for a universally-visible symbol.
*/
void emit_fdp_shlib_counter_code(stubs_ptr, count_index)
int *stubs_ptr;
int count_index;
{
    int ltoff; /* DLT index of the _LB_COUNT symbol */
    int offset; /* offset of this counter from the _LB_COUNT symbol */
    int *orig_stubs_ptr = stubs_ptr;  /* save for assert at end */

    assert(FDP_COUNTING_STUB_POSSIBLE);
    assert(building_shlib);


    /* Load the contents of the DLT slot for the base of the counter area */
    ltoff = (Sym_ShlImp_Indx(branch_counter_sym) -
	     ltptr_DLT_entry_index) * sizeof(DLT_ENTRY);
    *stubs_ptr++ = fix_format(SETUP_PLT_ACCESS,
			      fix_field(ltoff, 0, e_ldsel),
			      i_exp21,
			      SR_IS_VALID); /* not used */
    *stubs_ptr++ = fix_format(LONG_LOAD_COUNT_ADDR,
            		      fix_field(ltoff, 0, e_rdsel),
			      i_exp14,
			      SR_IS_VALID); /* not used */

    /* Load the page address of the counter in R1 */
    *stubs_ptr++ = fix_format(ADDIL_R1,
                        fix_field(count_index, 0, e_lsel),
                        i_exp21,
                        SR_IS_VALID); /* not used */

    /* Load the current value of the counter in R31 */
    *stubs_ptr++ = fix_format(LDW_R1_R31,
                        fix_field(count_index, 0, e_rsel),
                        i_exp14,
                        SR_IS_VALID); /* not used */

    /* Increment it by one, clamp by nullifying the STW-back if it overflows */
    *stubs_ptr++ = ADDI_EQ_1_R31_R31;
    *stubs_ptr++ = fix_format(STW_R31_R1,
                        fix_field(count_index, 0, e_rsel),
                        i_exp14,
                        SR_IS_VALID); /* not used */

    /* callers "know" how many words this routine emits, check it here */
    assert(stubs_ptr == (orig_stubs_ptr +
			 ((SHL_FDP_STUB_SIZE - SHL_LB_STUB_SIZE) / WORDSIZE)));

} /* end emit_fdp_shlib_counter_code */

/* 
** this routine generates an explicit shlib FDP counter (long branch) stub,
** only used for calls to scope-Local symbols within a shlib.  Adding counter
** code to a regular import stub is used for a universally-visible symbol.
*/
void bld_fdp_shlib_counting_stub(stub)
struct stub_record *stub;
{

/* FDP shlib counting stub sequence
	addil   LD'ltoff,r19    ; SETUP_PLT_ACCESS
	ldw     RD'ltoff(r1),r1 ; LONG_LOAD_COUNT_ADDR
	addil   LD'offset,r1    ; ADDIL_R1
				;  (needed in case counter offset is > 8K bytes)
	ldw     RD'offset(r1),r31       ; LDW_R1_R31
	addi,=  1,r31,r31       ; ADDI_EQ_1_R31_R31
	stw     r31,RD'offset(r1)       ; STW_R31_R1
	<shlib long branch >
*/
    assert(FDP_COUNTING_STUB_POSSIBLE);
    assert(building_shlib);
    assert(stub->length == SHL_FDP_STUB_SIZE);

    emit_fdp_shlib_counter_code(&stub_area[stub->subsp_off /sizeof(int)],
				stub->count_index);
    /* now do a PIC long branch to the actual callee */
    /* mung the offset for this stub to write at before building PIC lb stub */
    stub->subsp_off += (SHL_FDP_STUB_SIZE - SHL_LB_STUB_SIZE);
    bld_shl_lb_stub(stub);
    /* restore */
    stub->subsp_off -= (SHL_FDP_STUB_SIZE - SHL_LB_STUB_SIZE);
} /* end bld_fdp_shlib_counting_stub */

void bld_shlib_import_stub(stub)
struct stub_record *stub;

/* External HP-UX shared library import code sequence.

 HP-UX Shared Library Import stubs for incomplete executables

        addil   LD'lt_ptr+ltoff,dp	; GET_PROC_ENTRY - possibly eliminated
	ldw     RD'lt_ptr+ltoff(1),21	; LOAD_PLT_CALLEE
	ldw     RD'lt_ptr+ltoff+4(1),r19 ; LONG_GET_NEW_R19
	ldsid   (r21),r1	; LOAD_RTN_SID
	mtsp	r1,sr0		; MOVE_SID_2_SREG
	be      0(sr0,r21)      ; BE_SR0_R21
	stw     rp,-24(sp)      ; SAVE_RP


 HP-UX Shared Library Import stubs for Shared Libraries (small tables)

	<possibly FDP counter code>
	ldw     ltoff(r19),21	; LOAD_CALLEE_FROM_PLT
	ldw     ltoff+4(r19),r19 ; GET_NEW_R19
	ldsid   (r21),r1	; LOAD_RTN_SID
	mtsp	r1,sr0		; MOVE_SID_2_SREG
	be      0(sr0,r21)      ; BE_SR0_R21
	stw     rp,-24(sp)      ; SAVE_RP


 HP-UX Shared Library Import stubs for Shared Libraries (large tables)

	<possibly FDP counter code>
	addil   LD'ltoff,r19	; SETUP_PLT_ACCESS
	ldw     RD'ltoff(r1),r21	; LONG_PLT_LOAD_CALLEE
	ldw     RD'ltoff+4(r1),r19 ; LONG_GET_NEW_R19
	ldsid   (r21),r1	; LOAD_RTN_SID
	mtsp	r1,sr0		; MOVE_SID_2_SREG
	be      0(sr0,r21)      ; BE_SR0_R21
	stw     rp,-24(sp)      ; SAVE_RP
*/

/* These stubs use LD'/RD' because the offsets get to be very negative and when 
   we used LR'/RR' the LR' rolled over the address into the previous space reg.
   Similarly, when we used to call "fix_field" again with an argument of
   x+4, the RD' was found to jump onto the wrong page if a page boundary
   fell between x and x+4.  Since there are three overlap bits between 
   ADDIL/LDW, this is always safe.   Let's be CAREFUL out there!  */

/* Enhanced to expect only the required space to
   be allocated in bld_import_stub_rec (no more NO-OP's inserted after 
   ADDIL elimination). */

#define UNSET (0x7FFFFFF)

{
    int *stubs_ptr;

    int lt_ptr; /* dp-relative offset of the linkage table pointer */
    int ltoff;  /* r19-relative offset of the PLT entry */
    Boolean long_load_seq; /* Is ltoff > 14 bits? */

    int LD_prime_offset = UNSET;  /* LD' of ltoff+lt_ptr, for ADDIL-elim */
    int RD_prime_offset = UNSET;  /* RD' of ltoff+lt_ptr */
    int load_PLT_callee = LOAD_PLT_CALLEE;
    int long_get_new_r19 = LONG_GET_NEW_R19;
    int fdp_stub_size = 0;  /* size in bytes of FDP counter code included */

    Boolean save_rp_needed = TRUE;   /* do we need to save rp -> rp'? */

    ltoff = Sym_Info(stub->stub_symbol);
    long_load_seq = OFL (ltoff+4, 14);

    stubs_ptr = &stub_area[stub->subsp_off /sizeof(int)];

    /* 
    ** if we're going to put counting code in this stub, ensure we're looking
    ** at an exported symbol to be instrumented, as pure imports aren't arcs.
    */
    if (building_shlib && do_fdp_measure &&
	(shlib_match(out_hash_tbl, 
		     out_hash_tbl_len,
		     out_export_list, 
		     out_shlstr_table,
		     Sym_Name(stub->stub_symbol), 
		     ST_CODE) != BAD_SYM)) {
        emit_fdp_shlib_counter_code(stubs_ptr, stub->count_index);
	fdp_stub_size = (SHL_FDP_STUB_SIZE - SHL_LB_STUB_SIZE);
        stubs_ptr += (fdp_stub_size / WORDSIZE);
    }

    lt_ptr = (building_shlib ? 0 : Subspace_Virtual_Offset(PLT_subsp_index) - 
				   symbol_value(dollar_global));
	
    if (building_incomp_exec) {
        LD_prime_offset = fix_field(ltoff+lt_ptr, 0, e_ldsel);
        RD_prime_offset = fix_field(ltoff+lt_ptr, 0, e_rdsel);
	if (LD_prime_offset != 0) {
            *stubs_ptr++ = fix_format(GET_PROC_ENTRY,
				      LD_prime_offset,
				      i_exp21,
				      SR_IS_VALID); /* not used */
        } else {
	    load_PLT_callee = LOAD_PLT_CALLEE_DP;
	    long_get_new_r19 = LONG_GET_NEW_R19_DP;
	}
	assert (RD_prime_offset != UNSET);
        *stubs_ptr++ = fix_format(load_PLT_callee,
				  RD_prime_offset,
				  i_exp14,
				  SR_IS_VALID); /* not used */
    } else if (building_shlib) {
    	if (long_load_seq) {
            RD_prime_offset = fix_field(ltoff, 0, e_rdsel);
            *stubs_ptr++ = fix_format(SETUP_PLT_ACCESS,
				      fix_field(ltoff, 0, e_ldsel),
				      i_exp21,
				      SR_IS_VALID); /* not used */
            *stubs_ptr++ = fix_format(LONG_PLT_LOAD_CALLEE,
				      RD_prime_offset,
				      i_exp14,
				      SR_IS_VALID); /* not used */
        } else {
            *stubs_ptr++ = fix_format(LOAD_CALLEE_FROM_PLT,
				      ltoff,
				      i_exp14,
				      SR_IS_VALID); /* not used */
	}
    }  /* building shlib */

    if (long_load_seq || building_incomp_exec) {
	assert (RD_prime_offset != UNSET);
        *stubs_ptr++ = fix_format(long_get_new_r19,
				  RD_prime_offset+4, /* not using e_rdsel again
							fixes PLT entry split 
							over page boundary */
				  i_exp14,
				  SR_IS_VALID); /* not used */
    } else  /* short load shlib */
        *stubs_ptr++ = fix_format(GET_NEW_R19,
				  ltoff+4,
				  i_exp14,
				  SR_IS_VALID); /* not used */

    if (   stub->type == SHLIB_IMPORT_STUB_NO_RP ||
           stub->type == HPUX_IMPORT_STUB_NO_RP)  {
    	save_rp_needed = FALSE;
    }

    if (pcx_u_pa2_0) {
        /* Use BVE instruction. It will replace the 3 PA1.x 
	* instructions to load SR, mv SR, and BE.
	*/
       /* OpenGL support */
    	if (save_rp_needed) {
	    *stubs_ptr++ = BVE_R21;
	    *stubs_ptr   = SAVE_RP;
    	} else {
	    *stubs_ptr   = BVE_R21_NULL;
	}
    } else {
       /****************/
       /* PA 1.x stub. */
       /****************/
       /* If building incomplete a.out and +Ouse_sr7 flag is on */
       /* then use SR7 directly instead of loading space        */
       /* register from the address.                            */
       /*********************************************************/
	if (use_sr7_import && building_incomp_exec) {
	    if (save_rp_needed) {
		*stubs_ptr++ = BE_SR7_R21;
	    	*stubs_ptr   = SAVE_RP;
	    } else {
		*stubs_ptr   = BE_SR7_R21_NULL;
	    }
	}
	else {
          /* Normal PA 1.x import stub. */
	    *stubs_ptr++ = LOAD_RTN_SID;
	    *stubs_ptr++ = MOVE_SID_2_SREG;
	    if (save_rp_needed) {
	    	*stubs_ptr++ = BE_SR0_R21;
	    	*stubs_ptr   = SAVE_RP;
	    } else {
		*stubs_ptr   = BE_SR0_R21_NULL;
	    }
	}
    }

} /* end bld_shlib_import_stub */

#undef UNSET 

void bld_import_stub(stub)
struct stub_record *stub;

/* External import code sequence.

	ldw	-4(dp),r1		; Load LP
	stw	dp,dp_save(sp)		; Save DP

	addil	L'XRT_OFFSET,r1		; (Omitted if L'offset is zero)

	ldo	R'XRT_OFFSET(r1),r1	; R1 = XRT offset + LP
	ldw	16(r1),tmp2		; Load address of CALLX
	stw	rp,rp_prime_save(sp)	; Save RP'
	be	0(sr7,tmp2)		; Branch to CALLX
	mfsp	sr4,tmp1		; Move SR4 to tmp register
*/


{
    int value;
    int *stubs_ptr;
    int L_prime_offset; /* L' value of this routine's offset in XRT  */

    value = Sym_Dict(stub->stub_symbol).symbol_info;

    stubs_ptr = &stub_area[stub->subsp_off /sizeof(int)];

    *stubs_ptr++ = LOAD_LP;
    *stubs_ptr++ = SAVE_DP;
    L_prime_offset = fix_field(value, 0, e_lsel);
    if (L_prime_offset != 0)  /* speed up calls by one cycle if XRT nearby */
        *stubs_ptr++ = fix_format(ADDIL_R1,
				  L_prime_offset,
				  i_exp21,
				  SR_IS_VALID); /* not used */
    *stubs_ptr++ = fix_format(LDO_R1_R1,
			fix_field(value, 0, e_rsel),
			i_exp14,
			SR_IS_VALID); /* not used */
    *stubs_ptr++ = LOAD_ADDR_CALLX;
    *stubs_ptr++ = SAVE_RP_PRIME;
    *stubs_ptr++ = BRANCH_TO_CALLX;
    *stubs_ptr++ = GET_SR4;
    if (L_prime_offset == 0)
        *stubs_ptr = NOP;  /* not strictly necessary, but better to not 
			      leave undefined holes in object file  */
} /* end bld_import_stub */

char *build_stubs(subsp_index, size)
int    subsp_index, size;
{
    register struct stub_record *stub;
    struct subsp_misc_record *misc;

    if (size > stub_area_max) {
	efree(stub_area);
	stub_area_max = size + size / 4;
	stub_area = (int *) emalloc(stub_area_max);
    }
    misc = &Subsp_Misc(subsp_index);
    fixup_subsp = subsp_index;
    for (stub = misc->stub_list; stub != NULL; stub = stub->next_stub) {
	switch (stub->type) {
	    case LONG_BRANCH_STUB:
	    case MILLILONG_BRANCH_STUB:
		bld_lb_stub(stub);
		break;
            /* if HP-UX shared libraries */
	    case SHL_LONG_BRANCH_STUB:
		bld_shl_lb_stub(stub);
		break;
    	    case LOCAL_RELOC_STUB:
		bld_local_reloc_stub(stub,
                                     Subspace_Virtual_Offset(subsp_index));
		break;
            /* if HP-UX shared libraries */
	    case HPUX_IMPORT_STUB:
	    case HPUX_IMPORT_STUB_NO_RP:
	    case SHLIB_IMPORT_STUB:
	    case SHLIB_IMPORT_STUB_NO_RP:
		bld_shlib_import_stub(stub);
		break;
	    case EXTERN_IMPORT_STUB:
		bld_import_stub(stub);
		break;
            /* if HP-UX shared libraries */
	    case HPUX_EXPORT_STUB:
	    case HPUX_EXPORT_STUB_NO_RP:
		bld_shlib_export_stub(stub,
                                Subspace_Virtual_Offset(subsp_index));
                break;
	    case EXTERN_EXPORT_STUB:
	    case EXPORT_RELOC_STUB:
		bld_export_stub(stub,
                                Subspace_Virtual_Offset(subsp_index));
                break;
	    case INTERQUAD_IMPORT_STUB:
		bld_iq_stub(stub);
		break;
	    case DL_EXPORT_STUB:
		bld_dl_export_stub(stub, Subspace_Virtual_Offset(subsp_index));
		break;
            case FDP_COUNTING_STUB:
		if (building_shlib)
                   bld_fdp_shlib_counting_stub(stub);
		else
                   bld_fdp_counting_stub(stub);
                break;
	    default:
		internal_error(UNIMPL_STUB_TYP, 0);
		break;
	}
    }
    return (char *) stub_area;
} /* end build_stubs */

int *spit_arg_reloc_code(stubs_ptr, stub)
int *stubs_ptr;
struct stub_record *stub;
{
    int reloc_array[5], last, i;

    extern void get_arg_reloc_array();

    get_arg_reloc_array(stub->caller_reloc, 
			stub->callee_reloc,
			reloc_array);

    last = 0;
    for (i = 0; i < 4; i++) {
	if (reloc_array[i] == 0)
	    break;
	if (reloc_array[i+1] == 0)
	    last++;
	switch (reloc_array[i]) {
	    case ARG0_FARG0:
		*stubs_ptr++ = (i==0)? PUSH_ARG0:STORE_ARG0;
		*stubs_ptr++ = (last)? POP_FARG0:LOAD_FARG0;
		break;
	    case ARG1_FARG1:
		*stubs_ptr++ = (i==0)? PUSH_ARG1:STORE_ARG1;
		*stubs_ptr++ = (last)? POP_FARG1:LOAD_FARG1;
		break;
	    case ARG2_FARG2:
		*stubs_ptr++ = (i==0)? PUSH_ARG2:STORE_ARG2;
		*stubs_ptr++ = (last)? POP_FARG2:LOAD_FARG2;
		break;
	    case ARG3_FARG3:
		*stubs_ptr++ = (i==0)? PUSH_ARG3:STORE_ARG3;
		*stubs_ptr++ = (last)? POP_FARG3:LOAD_FARG3;
		break;
	    case FARG0_ARG0:
		*stubs_ptr++ = (i==0)? PUSH_FARG0:STORE_FARG0;
		*stubs_ptr++ = (last)? POP_ARG0  :LOAD_ARG0;
		break;
	    case FARG1_ARG1:
		*stubs_ptr++ = (i==0)? PUSH_FARG1:STORE_FARG1;
		*stubs_ptr++ = (last)? POP_ARG1  :LOAD_ARG1;
		break;
	    case FARG2_ARG2:
		*stubs_ptr++ = (i==0)? PUSH_FARG2:STORE_FARG2;
		*stubs_ptr++ = (last)? POP_ARG2  :LOAD_ARG2;
		break;
	    case FARG3_ARG3:
		*stubs_ptr++ = (i==0)? PUSH_FARG3:STORE_FARG3;
		*stubs_ptr++ = (last)? POP_ARG3  :LOAD_ARG3;
		break;
	    case ARG01_FARG1:
		*stubs_ptr++ = (i==0)? DPUSH_ARG1:DSTORE_ARG1;
		*stubs_ptr++ =                    DSTORE_ARG0;
		*stubs_ptr++ = (last)? DPOP_FARG1:DLOAD_FARG1;
		break;
	    case ARG23_FARG3:
		*stubs_ptr++ = (i==0)? DPUSH_ARG3:DSTORE_ARG3;
		*stubs_ptr++ =                    DSTORE_ARG2;
		*stubs_ptr++ = (last)? DPOP_FARG3:DLOAD_FARG3;
		break;
	    case FARG1_ARG01:
		*stubs_ptr++ = (i==0)? DPUSH_FARG1:DSTORE_FARG1;
		*stubs_ptr++ =                     DLOAD_ARG0;
		*stubs_ptr++ = (last)? DPOP_ARG1  :DLOAD_ARG1;
		break;
	    case FARG3_ARG23:
		*stubs_ptr++ = (i==0)? DPUSH_FARG3:DSTORE_FARG3;
		*stubs_ptr++ =                     DLOAD_ARG2;
		*stubs_ptr++ = (last)? DPOP_ARG3  :DLOAD_ARG3;
		break;
	    default:
		external_error(POOR_COMB_OF_ARGS,
    			    Subsp_Misc(stub->subsp_index).file_name,
			    Sym_Dict(stub->stub_symbol).
						name.n_name, 0);
	}
    }
    return (stubs_ptr);
} /* end spit_arg_reloc_code */

void get_arg_reloc_array(caller_reloc, callee_reloc, reloc_array)
int caller_reloc, callee_reloc;
int *reloc_array;
{
    int caller[4], callee[4], i;

    /* grab caller's argument location bits */
    caller[0] = (caller_reloc >> 8) & 03;
    caller[1] = (caller_reloc >> 6) & 03;
    caller[2] = (caller_reloc >> 4) & 03;
    caller[3] = (caller_reloc >> 2) & 03;

    /* grab callee's argument location bits */
    callee[0] = (callee_reloc >> 8) & 03;
    callee[1] = (callee_reloc >> 6) & 03;
    callee[2] = (callee_reloc >> 4) & 03;
    callee[3] = (callee_reloc >> 2) & 03;

    /* canonicalize so that FARGU appears only in arg0 or arg2 */
    if (caller[0] == FARGU || caller[1] == FARGU) {
	caller[0] = FARGU;
	caller[1] = NO_CHECK;
    }
    if (caller[2] == FARGU || caller[3] == FARGU) {
	caller[2] = FARGU;
	caller[3] = NO_CHECK;
    }
    if (callee[0] == FARGU || callee[1] == FARGU) {
	callee[0] = FARGU;
	callee[1] = NO_CHECK;
    }
    if (callee[2] == FARGU || callee[3] == FARGU) {
	callee[2] = FARGU;
	callee[3] = NO_CHECK;
    }

    for (i = 0; i <= 3; i++) {
	switch (COMBINE(caller[i],callee[i])) {

	    case COMBINE(ARG,FARG):
		*reloc_array++ = ARG0_FARG0 + i;
		break;
	    case COMBINE(FARG,ARG):
		*reloc_array++ = FARG0_ARG0 + i;
		break;
	    case COMBINE(ARG,FARGU):
		*reloc_array++ = ARG01_FARG1 + i;
		break;
	    case COMBINE(FARGU,ARG):
		*reloc_array++ = FARG1_ARG01 + i;
		break;

	    case COMBINE(FARG,FARGU):
	    case COMBINE(FARGU,FARG):
		*reloc_array++ = RELOC_ERROR;
		break;
	}
    }
    *reloc_array++ = 0;
} /* end get_arg_reloc_array */

int *spit_rtn_reloc_code(stubs_ptr, stub)
int *stubs_ptr;
struct stub_record *stub;
{
    switch (get_rtn_reloc(stub->caller_reloc, stub->callee_reloc)) {
        case 0:
    	    /* no return relocation */
	    break;
        case RET0_FRET0:
	    *stubs_ptr++ = PUSH_RET0;
	    *stubs_ptr++ = POP_FRET0;
	    break;
        case FRET0_RET0:
	    *stubs_ptr++ = PUSH_FRET0;
	    *stubs_ptr++ = POP_RET0;
	    break;
        case RET01_FRET0:
	    *stubs_ptr++ = PUSH_RET0;
	    *stubs_ptr++ = STORE_RET1;
	    *stubs_ptr++ = DPOP_FRET0;
	    break;
        case FRET0_RET01:
	    *stubs_ptr++ = DPUSH_FRET0;
	    *stubs_ptr++ = LOAD_RET1;
	    *stubs_ptr++ = POP_RET0;
	    break;
        default:
	    external_error(POOR_COMB_OF_ARGS,
	        Subsp_Misc(stub->subsp_index).file_name,
	        Sym_Dict(stub->stub_symbol).name.n_name, 0);
    }
    return (stubs_ptr);
} /* end spit_rtn_reloc_code */

int get_rtn_reloc(caller_reloc, callee_reloc)
int caller_reloc, callee_reloc;
{
    int caller, callee;

    /* grab caller's return location bits */
    caller = caller_reloc & 03;

    /* grab callee's return location bits */
    callee = callee_reloc & 03;

    switch (COMBINE(caller,callee)) {

        case COMBINE(ARG,FARG):
	    return (FRET0_RET0);
        case COMBINE(FARG,ARG):
	    return (RET0_FRET0);
        case COMBINE(ARG,FARGU):
	    return (FRET0_RET01);
        case COMBINE(FARGU,ARG):
	    return (RET01_FRET0);

        case COMBINE(FARG,FARGU):
        case COMBINE(FARGU,FARG):
	    return (RELOC_ERROR);
    }

    /* no relocation */
    return (0);
} /* end get_rtn_reloc */

void get_stub_info(caller_reloc, callee_reloc, arg_reloc_size, rtn_reloc_size)
int caller_reloc, callee_reloc, *arg_reloc_size, *rtn_reloc_size;
{
    int reloc_array[5], i;

    *arg_reloc_size = 0;
    get_arg_reloc_array(caller_reloc, callee_reloc, reloc_array);
    for (i = 0; i < 4; i++) {
	if (reloc_array[i] == 0)
	    break;
	switch (reloc_array[i]) {
	    case ARG0_FARG0:
	    case ARG1_FARG1:
	    case ARG2_FARG2:
	    case ARG3_FARG3:
	    case FARG0_ARG0:
	    case FARG1_ARG1:
	    case FARG2_ARG2:
	    case FARG3_ARG3:
		*arg_reloc_size += 2 * WORDSIZE;
		break;
	    case ARG01_FARG1:
	    case ARG23_FARG3:
	    case FARG1_ARG01:
	    case FARG3_ARG23:
		*arg_reloc_size += 3 * WORDSIZE;
		break;
	}
    }

    switch (get_rtn_reloc(caller_reloc, callee_reloc)) {
        case RET0_FRET0:
        case FRET0_RET0:
	    *rtn_reloc_size = 2 * WORDSIZE;
	    break;
        case RET01_FRET0:
        case FRET0_RET01:
	    *rtn_reloc_size = 3 * WORDSIZE;
	    break;
        default:
	    *rtn_reloc_size = 0;
	    break;
    }
} /* end get_stub_info */

int all_gen_regs(bits)
int    bits;
{
    int old_bits[5], i;

    /* grab argument and return location bits */
    old_bits[0] = (bits >> 8) & 03;
    old_bits[1] = (bits >> 6) & 03;
    old_bits[2] = (bits >> 4) & 03;
    old_bits[3] = (bits >> 2) & 03;
    old_bits[4] = (bits     ) & 03;

    /* rebuild relocation bits with ARG replacing all FARG, FARGU */
    bits = 0;
    for (i = 0; i <= 4; i++) {
	bits <<= 2;
	if (old_bits[i] != NO_CHECK)
	    bits |= ARG;
    }

    return (bits);
} /* end all_gen_regs */
