/*
 *  HP 9000 Series 800 Linker, Copyright Hewlett-Packard Co. 1985-1999  
 *  Symbol Table Data Structures
 *
 */

/* Internal symbol types */

#define ST_STUB_RELOC		32
#define ST_STUB_IMPORT		33
#define ST_STUB_ENTRY		34
#define ST_STUB_PRI_PROG	35
#define ST_STUB_SEC_PROG	36
#define ST_FDP_COUNT            37

#define	UNIVHASHSIZE	10007	/* or some other larger prime number */ 
#define SHLIB_EXPORT_HASH_SIZE 1103 /* or some other larger prime number */
#define HIDE_LIST_HASH_SIZE 1103 /* or some other larger prime number */
#define	EXPORT_LIST_HASH_SIZE	199	/* or some other larger prime number */
#define	LOCALHASHSIZE	2003	/* or some other larger prime number */
#define	UNSATHASHSIZE	2003	/* or some other larger prime number */
#define	SECHASHSIZE	199	/* or some other larger prime number */
#define FDPHASHSIZE     199     /* or some other larger prime number */

#define CLEAR_SYM_XL	 0x03  	/* to clear bits 30, 31 (XL) in symbol value */

/* In shared libraries and programs linked to shared libraries		*/
/* a plabel is a two-word entry. The second-to-last bit specifies what	*/ 
/* type of plabel this is (if set, then we have a two-word plabel).	*/

#define XRT_PLABEL_BITS  0x01   /* set bit 31 to signal a XRT plabel         */
#define HPUX_PLABEL_BITS 0x02   /* set bit 30 to signal a HPUX plabel        */

struct symnode {
    struct symnode *next;
    struct symnode *same;
    char *name;
    unsigned int hashval;
    int index;
    int len;
    unsigned char type;
    unsigned int reserved:18;
    /* "soft" unsat also exported by a shlib */
    unsigned int exported_by_shlib:1; 
    unsigned int shlib_storage:1;     /*is this a "soft" storage request?*/
    unsigned int secondary_def:1;
    unsigned int resolved:1;         /* is this resolved to a secondary def? */
    unsigned int mq:1;
    unsigned int checked:1;
};

struct symbol_misc_record {
    int out_remap;              /* final index in output file */
    int related_stub;           /* used for related stub chain */
    int subsp;	                /* subspace index */
    struct symnode *back_ptr;	/* pointer to associated symnode */
                                /* used in extern import stubs */
    struct stub_record *last_lbstub;   /* used for checking if a lb stub */
				        /* may be reused */
    struct stub_record *import_stub;   /* used for sharing import stubs */
    int shlib_import_indx;	/* This symbols index into the shared library
				   import table */
    int *mapped_to_a;           /* Array of a all symbol indices mapped to
				   this record using symbol_resolve */
    int mapped_to_sz;           /* Size of mapped_to_a */
    int mapped_to_cnt;          /* Number of indices in mapped_to_a */
#ifdef TSD /* TSD*/
    unsigned int tls:1; 
    unsigned int reserved:3;
#else
    unsigned int reserved:4;
#endif /* TSD */
    unsigned int shared_global:1; /* 1 if data sym exported from shlib */
    unsigned int sort_short:1;    /* 1 if 2-inst sequence used for shared sym*/
    unsigned int addr_taken:1;	/* is this a code symbol or related stub which
				   has had its address taken (plabel fixup)? */
    /* Set if we resolve a sym to one with ext recs */
    unsigned int has_ext_recs:1;
    /* More than one sym ind mapped to same memory */
    unsigned int mapped_to:1;	
    unsigned int checked:1;	/* toggle for searches of full symtable */
    /* Set this if we reference this milli ext sym */
    unsigned int referenced:1;  
    /* 1 if symbol referenced through code plabel */
    unsigned int code_plabel:1; 
    /* 1 if shared lib export should be hidden */
    unsigned int hide_export:1; 
    /* 1 if import sym on a data plabel fix */
    unsigned int import_data_plabel:1; 
    /* bytes of insts elim before sym */
    unsigned int new_sym_value_delta:18;
    /* index of the symbol in the linkmap's object file table */
    unsigned int objfile_index;
};

struct fru_list {    
  int  index;
  struct fru_list *next;
};
struct fru_list *fru_list;

struct symbol_record {
    struct symbol_dictionary_record dict;
    struct symbol_misc_record misc;
};

/* for debug purposes, make sure we exercise several blocks */
#define RELINK_BLK 10

struct relink_list {
    int sym_indices[RELINK_BLK];
    int new_indices[RELINK_BLK];
    struct relink_list *next;
    int num_used;
};

struct relink_indices {
    int old_sym;
    int new_sym;
};

/* Globals */

extern struct symbol_record **_sym_record;
extern struct symnode  *unsat_hash_table[UNSATHASHSIZE];
extern struct symnode *univ_hash_table[UNIVHASHSIZE];
extern struct symnode *sec_hash_table[SECHASHSIZE];

/* HP-UX shared library "soft" unsat table */
extern struct symnode *shlib_unsat_hash_table[UNSATHASHSIZE];

#define LOCALHASH 1

extern int             sym_dict_size;
extern int             cur_sym_index_bias;   /* symbol bias for a som       */
extern int 	       input_symbols_bias;   /* bias of last input sym read */
extern int             node_max;
extern int             node_segs;
extern int             node_segs_max;
extern int             entry_symbol_index;
extern int             num_storage_requests;
extern int 	       hidden_shlib_exports;

# if 0
#pragma NO_SIDE_EFFECTS symbol_info, symbol_type, symbol_value, univ_find
#pragma NO_SIDE_EFFECTS unsat_find, local_find, sec_find, shlib_unsat_find
#pragma NO_SIDE_EFFECTS type_compatible, symbol_type_match 
#pragma NO_SIDE_EFFECTS symnode_match, symnode_same
# endif

#define NUM_TYPES 18
extern Boolean type_match_table[NUM_TYPES][NUM_TYPES];

#define symbol_type_match(a,b) (type_match_table[(a)][(b)])

extern Boolean	       assign_xrt_offsets();
extern void            hide_symbols();
extern void            forget_unsats();
extern void	       sym_initialize();
extern void	       symbols_add();
extern void	       symbol_add();
extern int             symbol_allocate();
extern int             univ_find();
extern void	       unsat_resolve();
extern void	       unsat_add();
extern void	       storage_create();
extern void	       symbol_resolve();
extern int             symbol_value();
extern int             symbol_type();
extern int             symbol_info();
extern void            symbols_read();
extern Boolean	       unsat_print_list();
extern void   	       unsat_resolve_special();
extern struct symnode  *get_node();
extern void	       shlib_unsat_add();
extern void	       cleanup_shlib_unsat_tbl();
#ifdef TSD /* TSD */
extern void            set_tsd_addr();
extern void            tsd_mismatch_check();
#endif /* TSD */

/* Access to the symbol dictionary is through the following macros */

#define BAD_SYM (-1)

#ifdef DEBUG
#define Sym_Chk(i)   (((i) >= 0 && (i) <= sym_dict_size) ? (i) : (abort(), 0) )
#else
#define Sym_Chk(i)    (i)
#endif /* DEBUG */

#define Sym_Seg(i)	((i) >> log_sym_dict_max)
#define Sym_Off(i)	((i) & mask_sym_dict_max)

#define Sym_Dict(i)	_sym_record[Sym_Chk(i)]->dict
#define Sym_Misc(i)	_sym_record[Sym_Chk(i)]->misc
#define Sym_Scope(i)		Sym_Dict(i).symbol_scope
#define Sym_Info(i)             Sym_Dict(i).symbol_info
#define Sym_Type(i)		Sym_Dict(i).symbol_type
#define Sym_Value(i)		Sym_Dict(i).symbol_value
#define Sym_Name(i)	        Sym_Dict(i).name.n_name
#define Sym_Must_Qual(i)	Sym_Dict(i).must_qualify
#define Sym_Common(i)		Sym_Dict(i).is_common
#define Sym_Qual_Name(i)	(i == BAD_SYM ? NULL : Sym_Dict(i).q_nptr)
#define Sym_Remap(i)		(i)  /* make no-op;remap is now a ptr move */
#define Sym_Out_Remap(i)	Sym_Misc(i).out_remap
#define Sym_Related_Stub(i)	Sym_Misc(i).related_stub
#define Sym_Subsp(i)		Sym_Misc(i).subsp
#define Sym_Back_Ptr(i)		Sym_Misc(i).back_ptr
#define Sym_Last_Lbstub(i)	Sym_Misc(i).last_lbstub
#define Sym_Import_Stub(i)	Sym_Misc(i).import_stub
#define Sym_ShlImp_Indx(i)	Sym_Misc(i).shlib_import_indx
#define Sym_ShlHideExp(i)       Sym_Misc(i).hide_export
#define Sym_addr_taken(i)	Sym_Misc(i).addr_taken
#define Sym_Mapped_To_Cnt(i)    Sym_Misc(i).mapped_to_cnt
#define Sym_Mapped_To(i, j)     Sym_Misc(i).mapped_to_a[j]


#ifdef TSD /* TSD */
#define Sym_TLS(i)		Sym_Misc(i).tls
#endif /* TSD */

#define Sym_SharedGlobal(i)     Sym_Misc(i).shared_global
#define Sym_Sort_Short(i)      Sym_Misc(i).sort_short

#define OPTIONAL_PROC(index)  ((Sym_Dict(index).symbol_type==ST_STUB) && \
			       (Sym_Dict(index).symbol_scope==SS_UNSAT))

#ifndef DEBUG
#define Sym_Remap_Type(index) (Sym_Dict(Sym_Remap(index)).symbol_type)
#define Sym_Remap_Info(index) (Sym_Dict(Sym_Remap(index)).symbol_info)
#endif /* !DEBUG */

extern struct symbol_record *free_syms;

#ifdef TSD /* TSD */
extern int tbss_input_index;
#endif /* TSD */

/* recycle a sym_record struct onto the free list */
#define Free_Sym_Record(_sym_ptr) \
	do { if ((! _sym_ptr->misc.mapped_to) && \
		 (_sym_ptr->misc.mapped_to_cnt == 0)) { \
		_sym_ptr->misc.back_ptr = (struct symnode *) free_syms; \
		if (_sym_ptr->misc.mapped_to_sz) \
		    free(_sym_ptr->misc.mapped_to_a); \
		free_syms = _sym_ptr; } } while (0)

/* make all future references to the symbol for "from_indx" get "to_indx" */
#define Remap_Sym_Records(delete_indx, to_indx) \
         remap_sym_records(delete_indx, to_indx)

/* FUNCTION PROTOTYPES */

extern void saved_export_add(const char *name,
			     unsigned char type,
			     int size,
#ifdef TSD /* TSD */
			     unsigned int is_TLS,
#endif /* TSD */
			     char *filename);

extern Boolean saved_export_match(struct symnode *symbol,
				  int *type,
				  int *size,
#ifdef TSD /* TSD */
			          unsigned int *is_TLS,
#endif /* TSD */
				  char **filename);

extern void check_trace_list (char *symbol_name,
		              int symbol_type,
		              int symbol_scope,
		              char *filename);

extern int univ_replace(int old_index,
			char *name,
			int mq,
			char *qname,
			unsigned int hashval,
			int new_index,
			int type);

extern void excl_export_list_add(char *sym_name);
extern Boolean on_excl_export_list(char *sym_name);

/* New fields in symbol dictionary */
#define Sym_has_long_return(i)	Sym_Dict(i).has_long_return
#define Sym_no_relocation(i)	Sym_Dict(i).no_relocation
