/*
 *  HP 9000 Series 800 Linker, Copyright Hewlett-Packard Co. 1985-1999  
 *  Utility Routines
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  $Header: /home/cvs/cvsroot/linker/util.c,v 1.1.1.1 1999/10/18 19:53:04 pschwan Exp $
 */

#include <stdio.h>
#include <ctype.h>
#include <locale.h>
#include <setjmp.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>

#include "filehdr.h"
#include "spacehdr.h"
#include "scnhdr.h"
#include "initptr.h"
#include "compunit.h"
#include "reloc.h"
#include "syms.h"

#include "std.h"
#include "ldlimits.h"
#include "ldnls.h"
#include "driver.h"
#include "errors.h"
#include "fixups.h"
#include "linker.h"
#include "nl_types.h"
#include "subspaces.h"
#include "symbols.h"
#include "stubs.h"
#include "util.h"
#include "ld_strings.h"
#include <assert.h>

#ifdef ESOM
#include "cnx_aout.h"
#endif /* ESOM */

#define INT_MAX     2147483647

#define ERR_BUFLEN         2048

#define NEW_STUFF

#define IS_MSG_FILE_OPEN	(msg_fd >= 0)

#define CATREAD(msg_fd, 						\
		setnum, 						\
		errnum, 						\
		buf, 							\
		ERR_BUFLEN, 						\
		arg1, 							\
		arg2, 							\
		arg3, 							\
		arg4)							\
	    ld_catread(msg_fd, 						\
		       setnum, 						\
		       errnum, 						\
		       buf, 						\
		       ERR_BUFLEN, 					\
		       arg1, 						\
		       arg2, 						\
		       arg3, 						\
		       arg4)

/* Locals */

static nl_catd msg_fd = (nl_catd)-1;

static int oldfildes = -1;
static int oldfilofs = -1;

void clear_oldfilofs() {
    oldfildes = -1;
    oldfilofs = -1;
}



static int cur_out_fd = -1;
static int cur_out_ofs = -1;
int fdump_autoalign = FALSE;
int fatal_ffetch = TRUE;

int ffetch(fildes,filofs,dest,size,cnt)
int fildes;
int filofs, size, cnt;
char *dest;
{
    int len;
    int bytes = size * cnt;

    /* cannot interleave reads and writes with the same file because of */
    /* the new buffered output scheme. */
    if (fildes == cur_out_fd) {
	flush_fdump_buffer();
    }

    if (filofs != -1) {
	if (lseek(fildes,filofs,0) == -1) {
	    if (fatal_ffetch)
		system_error(CANT_SEEK_IN, cur_name , 0);
	    else {
		fatal_ffetch = TRUE;
		return -1;
	    }
	}
    }
    len = read(fildes, dest, bytes);

    if (fatal_ffetch) {
	if (len == -1)
	    system_error(FF_CANT_READ, cur_name, 0);
	else if (len != bytes)
	    external_error(CANT_READ_FL, cur_name , 0);
    }
    else {
	fatal_ffetch = TRUE;
	if (len != bytes) return -1;
    }

    oldfildes=fildes;
    oldfilofs=filofs+bytes;
    return 0;
} /* end ffetch */



/*************************************************************
** FUNCTION:	ld_catread
**
** DESCRIPTION: Replacement for catread on HP-UX.  At 10.0, catread was
**		removed from libc.  This routine retrieves the message
**		with catgets then uses sprintf to place the characters
**		in the string.  The caller must ensure that msg_buf is
**		long enough.
**
** NOTES: This version of catread requires that the !# parameters from the
**	  original err.src be translated to %$#s (# is 1..5).  The Makefile
**	  generates err_hpux.src from err.src.
*************************************************************/

int ld_catread(nl_catd fd,
	       int set_num, 
	       int msg_num, 
	       char *msg_buf, 
	       int buflen,
	       char *arg1,
	       char *arg2,
	       char *arg3,
	       char *arg4)
{
    char	*message;
    char	msg_buf2[ERR_BUFLEN];
    int		msg_len;
    Boolean	is_more_args;


    message = catgets(fd, set_num, msg_num, "");
    if (message[0] == '\0') {
	strcpy(msg_buf, "");
	return(-1);
    }
    sprintf(msg_buf, message, arg1, arg2, arg3, arg4);
    msg_len = strlen(msg_buf);
    assert(msg_len < buflen);
    return(msg_len);
} /* ld_catread */


#define OUTPUT_BUFFER_SIZE          131072
static char output_buffer[OUTPUT_BUFFER_SIZE];
static int output_buffer_count = 0;
static int buffer_start_ofs = -1;

void flush_fdump_buffer(void) {
    int len;

    /* No point in writing it if it's empty... */
    if (output_buffer_count > 0) {
        
        len = write(cur_out_fd, output_buffer, output_buffer_count);
        if (len == -1) {
            if ((unsigned int)buffer_start_ofs + output_buffer_count 
                > INT_MAX) {
                
                system_error(MAX_FSIZE_EXCEEDED, 
                             ltoa(INT_MAX), output_name, 0);
            } else {
                system_error(FDMP_CANT_WRT, output_name, 0);
            }
        } else if (len != output_buffer_count) {
            len += write(cur_out_fd, output_buffer + len, 
                         output_buffer_count - len);
            if (len == -1) {
                system_error(FDMP_CANT_WRT, output_name, 0);
            } else if (len != output_buffer_count) {
                external_error(FDMP_CANT_WRT, output_name, 0);
            }
        }
    }

    output_buffer_count = 0;
    buffer_start_ofs = -1;
    cur_out_fd = -1;
    cur_out_ofs = -1;
}

void fdump(int fildes, int filofs, char *src, int size, int cnt)
{
    int len;
    int bytes = size * cnt;

    if (fdump_autoalign &&
        cur_out_fd == fildes &&
        cur_out_ofs + 4 == filofs) {
        
        memset(output_buffer + output_buffer_count, 0, 4);
        output_buffer_count += 4;
        cur_out_ofs += 4;
    }

    if (cur_out_ofs != filofs || cur_out_fd != fildes || 
        (output_buffer_count + bytes) > OUTPUT_BUFFER_SIZE) {

        /* if the file or offset changed, or if the buffer is full */
        /* we have to flush te buffer */
        flush_fdump_buffer();
        
        /* buffer has been flushed */
        /* now, if the file or offset have changed, we have to lseek */
        if (cur_out_ofs != filofs || cur_out_fd != fildes) {
            
            if (lseek(fildes, filofs, 0) == -1) {
                if ((unsigned int) filofs > INT_MAX) {
                    system_error(MAX_FSIZE_EXCEEDED, ltoa(INT_MAX),
                                 output_name, 0);
                } else {
                    system_error(CANT_SEEK_IN, output_name, 0);
                }
            }
            cur_out_ofs = filofs;
            cur_out_fd = fildes;
        }
    
        output_buffer_count = 0;
        buffer_start_ofs = filofs;
    } 

    if (bytes > OUTPUT_BUFFER_SIZE) {
        /* The buffer should have been flushed prior to this clause */
        assert(output_buffer_count == 0);
        
        /* if the output region is bigger than the buffer, */
        /* write it out directly */
        len = write(fildes, src, bytes);
        if (len == -1) {
            if ((unsigned int)filofs + bytes > INT_MAX) {
                system_error(MAX_FSIZE_EXCEEDED, 
                             ltoa(INT_MAX), output_name, 0);
            } else {
                system_error(FDMP_CANT_WRT, output_name, 0);
            }
        } else if (len != bytes) {
            len += write(fildes, src + len, bytes - len);
            if (len == -1) {
                system_error(FDMP_CANT_WRT, output_name, 0);
            } else if (len != bytes) {
                external_error(FDMP_CANT_WRT, output_name, 0);
            }
        }

        /* move the buffer past this big chunk */
        buffer_start_ofs = filofs + bytes;
    } else {

        /* copy the source to the buffer */
        memcpy(output_buffer + output_buffer_count, src, bytes);
        output_buffer_count += bytes;

    }
    cur_out_ofs += bytes;
}
/************************* end fdump *****************************/


#ifdef INSTRUMENT_MALLOC
#define FN_LEN 40
struct site_info {
       int *tot_size_p;
       int *count_p;
       char filename[FN_LEN];
       int lineno;
       char mal_type;
};

static struct site_info site_array[1000];
static instrument_mal_index=0;

record_site(tot_size_p,count_p,filenm,lineno,type)
  int *tot_size_p,count_p;
  char *filenm;
  int lineno;
  char type;
{
  site_array[instrument_mal_index].tot_size_p=tot_size_p;
  site_array[instrument_mal_index].count_p=count_p;
  site_array[instrument_mal_index].lineno=lineno;
  if (MB_CUR_MAX == 1)
      (void) strncpy(site_array[instrument_mal_index].filename,filenm,FN_LEN);
  else
      (void) mb_strncpy(site_array[instrument_mal_index].filename,
			filenm,
			FN_LEN);
  site_array[instrument_mal_index].mal_type=type;
  instrument_mal_index++;
} /* end record_site */

dump_sites()
{
  int i;
  int mem_total;

  mem_total=0;
  for(i=0;i<instrument_mal_index;i++) {
   if (site_array[i].mal_type=='M') {
    if (MB_CUR_MAX == 1) 
	fprintf(stderr,
		ld_gets(1, 
			1224, 
		"Type: %c  File: %-20s  Line: %4d  Total: %8d  Count: %4d\n"),
		site_array[i].mal_type,
		site_array[i].filename,
		site_array[i].lineno,
		*(site_array[i].tot_size_p),
		*(site_array[i].count_p));
    else
	fprintf(stderr,
		ld_gets(1, 
			1225, 
		"Type: %c  File: %s  Line: %4d  Total: %8d  Count: %4d\n"),
		site_array[i].mal_type,
		pad_string(-1, 20, 0, site_array[i].filename),
		site_array[i].lineno,
		*(site_array[i].tot_size_p),
		*(site_array[i].count_p));

    mem_total += *(site_array[i].tot_size_p);
   }
  }
  fprintf(stderr,ld_gets(1, "Total memory: %d\n", mem_total));

  mem_total=0;
  for(i=0;i<instrument_mal_index;i++) {
   if (site_array[i].mal_type=='C') {
    if (MB_CUR_MAX == 1)
	fprintf(stderr,
		ld_gets(1, 
			1226, 
			"Type: %c  File: %-20s  Line: %4d  Total: %8d"
			    "  Count: %4d\n"),
		site_array[i].mal_type,
		site_array[i].filename,
		site_array[i].lineno,
		*(site_array[i].tot_size_p),
		*(site_array[i].count_p));
    else
	fprintf(stderr,
		ld_gets(1, 
			1227, 
			"Type: %c  File: %s  Line: %4d  Total: %8d"
			    "  Count: %4d\n"),
		site_array[i].mal_type,
		pad_string(-1, 20, 0, site_array[i].filename),
		site_array[i].lineno,
		*(site_array[i].tot_size_p),
		*(site_array[i].count_p));
    mem_total += *(site_array[i].tot_size_p);
   }
  }
  fprintf(stderr,"Total memory: %d\n", mem_total);

  mem_total=0;
  for(i=0;i<instrument_mal_index;i++) {
   if (site_array[i].mal_type=='R') {
    if (MB_CUR_MAX == 1) 
	    fprintf(stderr,
		    ld_gets(1, 
			    1228, 
			    "Type: %c  File: %-20s  Line: %4d  Total: %8d"
				"  Count: %4d\n"),
		    site_array[i].mal_type,
		    site_array[i].filename,
		    site_array[i].lineno,
		    *(site_array[i].tot_size_p),
		    *(site_array[i].count_p));
	else
	    fprintf(stderr,
		    ld_gets(1, 
			    1229, 
			    "Type: %c  File: %s  Line: %4d  Total: %8d"
				"  Count: %4d\n"),
		    site_array[i].mal_type,
		    pad_string(-1, 20, 0, site_array[i].filename),
		    site_array[i].lineno,
		    *(site_array[i].tot_size_p),
		    *(site_array[i].count_p));
    mem_total += *(site_array[i].tot_size_p);
   }
  }
  fprintf(stderr,ld_gets(1, 1236, "Total memory: %d\n", mem_total));

  mem_total=0;
  for(i=0;i<instrument_mal_index;i++) {
      if (site_array[i].mal_type=='F') {
	  if (MB_CUR_MAX == 1)
	      fprintf(stderr,
		      ld_gets(1, 
			      1230, 
			      "Type: %c  File: %-20s  Line: %4d  Total:"
				  " %8d  Count: %4d\n"),
		      site_array[i].mal_type,
		      site_array[i].filename,
		      site_array[i].lineno,
		      *(site_array[i].tot_size_p),
		      *(site_array[i].count_p));
	   else
	      fprintf(stderr,
		      ld_gets(1, 
			      1231, 
			      "Type: %c  File: %s  Line: %4d  Total: %8d"
				  "  Count: %4d\n"),
		      site_array[i].mal_type,
		      pad_string(-1, 20, 0, site_array[i].filename),
		      site_array[i].lineno,
		      *(site_array[i].tot_size_p),
		      *(site_array[i].count_p));
      mem_total += *(site_array[i].tot_size_p);
      }
  }
} /* end dump_sites */

#endif /* INSTRUMENT_MALLOC */

#ifdef DEBUG
#ifdef INSTRUMENT_MALLOC
void iefree(ptr,filenm,lineno)
void *ptr;
char *filenm;
int lineno;
#else
void efree(void *ptr)
#endif /* INSTRUMENT_MALLOC */
{
#ifdef INSTRUMENT_MALLOC2
    fprintf(stderr,
	    ld_gets(1, 1237, "efree called from %s at %d\nPointer is %d\n"),
	    filenm,
	    lineno,
	    (int) ptr);
#endif /* INSTRUMENT_MALLOC */
    if (ptr == NULL) {
	printf(ld_gets(1, 1238, "ERROR, attempt to free NULL ptr\n"));
	return;
	}
    free(ptr);
    }
#endif /* DEBUG */

#ifdef INSTRUMENT_MALLOC
char *iemalloc(size,filenm,lineno)
int size; char *filenm; int lineno;
#else
char *emalloc(size)
int size;
#endif /* INSTRUMENT_MALLOC */
{
    char *s;

#ifdef INSTRUMENT_MALLOC2
    fprintf(stderr,
	    ld_gets(1, 1239, "emalloc called from %s at %d\nSize is %d\n"),
	    filenm,
	    lineno,size);
#endif /* INSTRUMENT_MALLOC */

    s = malloc(size);
    if ((s == 0) && (size != 0))
	external_error(OUT_OF_MEM , 0);

#ifdef DEBUG
    /*
    ** Write non-zero garbage on allocated space to help catch uninit 
    ** errors. 
    */
    {
	int i;  /* loop counter */
	for (i = 0; i < size; i++)
	    s[i] = (char) ( (i & 1) ? 0xff : 0x80 );
    }
#endif /* DEBUG */

    return (s);
}

#ifdef INSTRUMENT_MALLOC
char *iecalloc(cnt,size,filenm,lineno)
int size,cnt; char *filenm; int lineno;
#else
char *ecalloc(cnt,size)
int size,cnt;
#endif /* INSTRUMENT_MALLOC */
{
    char *s;

#ifdef INSTRUMENT_MALLOC2
    fprintf(stderr,
	    ld_gets(1, 
		    1239, 
		    "ecalloc called from %s at %d\nSize and cnt are %d, %d\n"),
	    filenm,
	    lineno,
	    size,
	    cnt);
#endif /* INSTRUMENT_MALLOC */

    s = calloc(cnt,size);
    if (s == 0)
	external_error(OUT_OF_MEM , 0);
    return (s);
}

#ifdef INSTRUMENT_MALLOC
char *ierealloc(ptr, newsize, filenm, lineno)
char *ptr;
int newsize;
char *filenm;
int lineno;
#else
char *erealloc(ptr, newsize)
char *ptr;
int newsize;
#endif /* INSTRUMENT_MALLOC */

   /* 
   ** Enhanced  to call malloc if NULL, since that
   ** code keeps getting spread all over the linker. 
   */
{
    char *s;

#ifdef INSTRUMENT_MALLOC2
  fprintf(stderr,
	  ld_gets(1, 
		  1240, 
	  "ecalloc called from %s at %d\nPtr and newsize are %d, %d\n"),
          filenm,
	  lineno,
	  (int)ptr,
	  newsize);
#endif /* INSTRUMENT_MALLOC */

    if (ptr == NULL) {
        s = emalloc(newsize);
    }
    else
    	s = realloc(ptr, newsize);
    if (s == 0)
	external_error(OUT_OF_MEM, 0);
    return (s);
}

FILE *efopen (char *filename, char *permissions, int error_num)
	/* permissions: e.g., "r", "w+" */
	/* error_num: number of system error to issue if open fails */
{
    FILE *f = fopen(filename, permissions);

    if (f == NULL)
	system_error(error_num, filename, 0);
    return(f);
} /* end efopen */

/*
**	stdoutfopen().  Used to "open" stdout for writing if the filename
**	is "-".  Otherwise call efopen(). 
*/

FILE *stdoutfopen (char *filename, char *permissions, int error_num)
{
    assert (strchr (permissions, 'w') != NULL);   /* Must be writing */

    if (strcmp (filename, "-") == 0)
	return stdout;
    else
	return efopen (filename, permissions, error_num);
} /* end stdoutfopen */

int open_catalog()
{
    char *s;
    static int done = 0;

    if (IS_MSG_FILE_OPEN)
	return (TRUE);


    /* Look for environment variable for name of msg catalog */
    if ((s = getenv("ST_LINKCAT")) != NULL) {
	    if ((msg_fd = catopen(s, NL_CAT_LOCALE)) >= 0) {
		    return (TRUE);
	    }
    }

    /* Let catopen find the catalog via $NLSPATH and $LANG */
    if ((msg_fd = catopen("ld", NL_CAT_LOCALE)) >= 0) {
	return (TRUE);
    }

    /* Try again with $LANG set to "C" */
    putenv("LANG=C");
    if ((msg_fd = catopen("ld", NL_CAT_LOCALE)) >= 0) {
	return (TRUE);
    }

    /* Last try: let open find the catalog in default place */
    if ((msg_fd = (nl_catd)open(DEF_LINKCAT, 0)) >= 0) {
	return (TRUE);
    }

    if (!done) {
	fprintf(stderr, "%s: can't open message catalog\n", progname);
	done = 1;
    }
    return (FALSE);
} /* end open_catalog */

/*VARARGS*/
void user_error(errnum, arg1, arg2, arg3, arg4)
int errnum;
char *arg1, *arg2, *arg3, *arg4;
{
    int setnum = 1;
    char buf[ERR_BUFLEN];

    if (!open_catalog() ||
    	CATREAD (msg_fd, 
		 setnum, 
		 errnum, 
		 buf, 
		 ERR_BUFLEN,
    		 arg1, 
		 arg2, 
		 arg3, 
		 arg4) < 0)
    	sprintf(buf, "error %d, parm \"%s\"", errnum, arg1);
    if (progname != 0)
        fprintf (stderr, "%s: ", progname);
    fprintf (stderr, "%s\n", buf);
    fflush(stderr);

    if (verbose & V_STATS)
        print_total_sizes();
    longjmp(drive, 1);
} /* end user_error */

/**
 **   Print system error.
 **/

void
print_system_error(name_p)
   char	*name_p;
{
   if (errno == EOVERFLOW) {
      /*  Possible large file error */

      fprintf(stderr, ld_gets(1, LARGE_FILE_ERROR,
          "%s: large files are not supported\n"), progname);
   }
   else {
      perror(name_p);
   }
}

/*VARARGS*/
void system_error(errnum, arg1, arg2, arg3, arg4)
int errnum;
char *arg1, *arg2, *arg3, *arg4;
{
    char buf[ERR_BUFLEN];
    int setnum = 1;
    int tmp_errno;

    tmp_errno = errno;  /* save errno in case we bomb in open_catalog */
    if (!open_catalog() ||
	CATREAD (msg_fd, 
		 setnum, 
		 errnum,
		 buf, 
		 ERR_BUFLEN,
		 arg1, 
		 arg2, 
		 arg3, 
		 arg4) < 0)
	sprintf(buf, "error %d, parm \"%s\"", errnum, arg1);
    if (progname != 0)
        fprintf (stderr, "%s: ", progname);
    fprintf (stderr, "%s\n", buf);
    fflush(stderr);
    errno = tmp_errno; /* restore errno */
    print_system_error(progname);
    if (verbose & V_STATS)
        print_total_sizes();
    longjmp(drive, 1);
} /* end system_error */

/*VARARGS*/
void internal_error(errnum, arg1, arg2, arg3, arg4)
int errnum;
char *arg1, *arg2, *arg3, *arg4;
{
    int setnum = 1;
    char buf[ERR_BUFLEN];

    if (!open_catalog() ||
    	CATREAD (msg_fd, 
		 setnum, 
		 errnum, 
		 buf, 
		 ERR_BUFLEN,
    		 arg1, 
		 arg2, 
		 arg3, 
		 arg4) < 0)
    	sprintf(buf, "Internal Error %d, parm \"%s\"", errnum, arg1);
    if (progname != 0)
        fprintf (stderr, "%s: ", progname);
    fprintf (stderr, "%s\n", buf);
    fflush(stderr);
    if (verbose & V_STATS)
        print_total_sizes();
    longjmp(drive, 1);
} /* end internal_error */

void external_error_hex(errnum, arg1, arg2)
int errnum;
int arg1;
char *arg2;
{
    char buf[12];

    sprintf(buf, "0x%x", arg1);
    external_error(errnum, buf, arg2, 0);
} /* end external_error_hex */

void external_error_n(errnum, arg1)
int errnum;
int arg1;
{
    char buf[10];

    sprintf(buf, "%d", arg1);
    external_error(errnum, buf, 0);
} /* end external_error_n */

void external_error_sn(errnum, arg1, arg2)
int errnum;
char *arg1;
int arg2;
{
    char buf[10];

    sprintf(buf, "%d", arg2);
    external_error(errnum, arg1, buf, 0);
} /* end external_error_sn */

/*VARARGS*/
void external_error(errnum, arg1, arg2, arg3, arg4)
int errnum;
char *arg1, *arg2, *arg3, *arg4;
{
    int setnum = 1;
    char buf[ERR_BUFLEN];

    if (!open_catalog() ||
 	CATREAD (msg_fd, 
		 setnum, 
		 errnum, 
		 buf, 
		 ERR_BUFLEN,
 		 arg1, 
		 arg2, 
		 arg3, 
		 arg4) < 0)
 	sprintf(buf, "error %d, parm \"%s\"", errnum, arg1);
    if (progname != 0)
        fprintf (stderr, "%s: ", progname);
    fprintf (stderr, "%s\n", buf);
    fflush(stderr);
    if (verbose & V_STATS)
        print_total_sizes();
    longjmp(drive, 1);
} /* end external_error */

/*VARARGS*/
void info_message(errnum, arg1, arg2, arg3, arg4)
int errnum;
char *arg1, *arg2, *arg3, *arg4;
{
    int setnum = 1;
    char buf[ERR_BUFLEN];

    if (!open_catalog() ||
	CATREAD (msg_fd, 
		 setnum, 
		 errnum, 
		 buf, 
		 ERR_BUFLEN,
		 arg1, 
		 arg2, 
		 arg3, 
		 arg4) < 0)
	sprintf(buf, "info message %d, parm \"%s\"", errnum, arg1);
    fprintf(stdout, "%s\n", buf);
    fflush(stdout);
} /* end info_message */

void warning_n(errnum, arg1)
int errnum, arg1;
{
    char buf[10];

    sprintf(buf, "%d", arg1);
    warning(errnum, buf, 0);
}

/*VARARGS*/
void warning(errnum, arg1, arg2, arg3, arg4)
int errnum;
char *arg1, *arg2, *arg3, *arg4;
{
    int setnum = 1;
    char buf[ERR_BUFLEN];

    if (!open_catalog() ||
	CATREAD (msg_fd, setnum, errnum, buf, ERR_BUFLEN,
		 arg1, arg2, arg3, arg4) < 0)
	sprintf(buf, "warning %d, parm \"%s\"", errnum, arg1);
    if (progname != 0)
        fprintf (stderr, "%s: ", progname);
    fprintf (stderr, "%s\n", buf);
    fflush(stderr);
} /* end warning */

void warning_continue_n(errnum, arg1)
int errnum;
int arg1;
{
    char buf[10];

    sprintf(buf, "%d", arg1);
    warning_continue(errnum, buf, 0);
} /* end warning_continue_n */

/*VARARGS*/
void warning_continue(errnum, arg1, arg2, arg3, arg4)
int errnum;
char *arg1, *arg2, *arg3, *arg4;
{
    int setnum = 1;
    char buf[ERR_BUFLEN];

    if (!open_catalog() ||
	CATREAD (msg_fd, 
		 setnum, 
		 errnum, 
		 buf, 
		 ERR_BUFLEN,
		 arg1, 
		 arg2, 
		 arg3, 
		 arg4) < 0)
	sprintf(buf, "warning %d, parm \"%s\"", errnum, arg1);
    fprintf (stderr, "   %s\n", buf);
    fflush(stderr);
} /* end warning_continue */

unsigned int checksum(header, length)
unsigned int *header;
int length;
/*
** This procedure will compute the checksum of a header record.  The header
** is treated as an array of words of the specified length.  The last word
** of the header will not be included in the computation of the checksum.
** The checksum value will be the function return value.
*/
{
    unsigned int i;
    unsigned int cksum;

    cksum = 0;
    for (i = 1;  i <= (length/4)-1; i++) {
	cksum = cksum ^ *header++;
    }

    return (cksum);

}   /* End checksum */


#ifdef DEBUG
unsigned int round_Check(number, base, result)
unsigned int number;
unsigned int base;
unsigned int result;
/* 
** This procedure rounds the number up to the next multiple of the base
** checks this against result and aborts if they are different. 
** This routine is only called in the debug linker since it is 
** rather costly and is only used to make sure the less general algorithm
** used to generate result is sufficient.
*/
{
   if ( (((number + base -1) / base) * base) != result)
	abort();
   return(result);
}
#endif /* DEBUG */

void print_total_sizes()
{
    int i, size;
    char msg_buf1[128];
    char msg_buf2[128];

    extern int cur_space_total;
    extern int abs_fixup_total;
    extern int new_subsp_dict_size;
    extern int init_array_size;
    extern int out_symbol_total;
    extern int lib_area_max;
    extern int aux_area_count;
    extern int aux_area_size;
    extern int compiler_dict_total;

    extern void print_size();

    printf(ld_gets(1, 1241, "\n                 *** STATISTICS ***\n\n"));
    strcpy(msg_buf1, ld_gets(1, 1233, "Count"));
    strcpy(msg_buf2, ld_gets(1, 1234, "Size"));
    if (MB_CUR_MAX == 1)
	printf("%-30s %10s %10s\n\n", 
	       ld_gets(1, 1232, "Table"),
	       msg_buf1,
	       msg_buf2);
    else {
	    strcpy(msg_buf1, pad_string(0, 10, 0, msg_buf1));
	    strcpy(msg_buf2, pad_string(0, 10, 0, msg_buf2));
	    printf("%s %s %s\n\n", 
		   pad_string(-1, 30, 0, ld_gets(1, 1232, "Table")),
		   msg_buf1,
		   msg_buf2);
    }
    print_size(ld_gets(1, 1242, "Auxiliary Headers"), 
	       aux_area_count, 
	       aux_area_size);
    print_size(ld_gets(1, 1243, "Space Dictionary"), 
	       cur_space_total,
    	       cur_space_total * sizeof(struct space_dictionary_record));
    print_size(ld_gets(1, 1244, "Init Pointers"), 
	       init_array_size,
	       init_array_size * sizeof(struct init_pointer_record));
    print_size(ld_gets(1, 1245, "Subspace Dictionary (in)"), 
	       subsp_dict_size,
		 subsp_dict_size * sizeof(struct subspace_dictionary_record) 
	       +
		 subsp_dict_size * sizeof(struct subsp_misc_record));
    print_size(ld_gets(1, 1246, "Subspace Dictionary (out)"), 
	       new_subsp_dict_size,
	       new_subsp_dict_size * 
	       sizeof(struct subspace_dictionary_record));
    print_size(ld_gets(1, 1247, "Space Strings (out)"), 
	       1, 
	       sizeof_string_table(&space_strings));
    print_size(ld_gets(1, 1248, "Symbol Dictionary (in)"), 
	       sym_dict_size,
		 sym_dict_size * sizeof(struct symbol_dictionary_record) 
	       +
		 sym_dict_size * sizeof(struct symbol_misc_record));
    print_size(ld_gets(1, 1249, "Symbol Dictionary (out)"), 
	       out_symbol_total,
	       out_symbol_total * sizeof(struct symbol_dictionary_record));
    print_size(ld_gets(1, 1250, "Symbol Strings (out)"), 
	       1, 
	       sizeof_string_table(&sym_strings));

    /* NEED TO PRINT SIZE OF FIXUPS COMING IN */

    if (!relocatable)
        print_size(ld_gets(1, 1251, "Fixups (out)"), 
		   abs_fixup_total,
		   abs_fixup_total * sizeof(struct fixup_request_record));
    print_size(ld_gets(1, 1252, "Stubs"), 
	       stubs_size,
	       stubs_size * sizeof(struct stub_record));
    print_size(ld_gets(1, 1253, "Compilation Units"), 
	       compiler_dict_total,
	       compiler_dict_total * sizeof(struct compilation_unit));
    print_size(ld_gets(1, 1254, "LST Area"), 1, lib_area_max);

    /* calculate data size */
    size = 0;
    for (i = 0; i < subsp_dict_size; i++)
	size = size + Subsp_Dict(i).initialization_length;
    print_size(ld_gets(1, 1255, "Total Data"), subsp_dict_size, size);

} /* end print_total_sizes */

void print_size(name, count, size)
char *name;
int count, size;
{
    char msg_buf[INIT_BUF_SIZE + 1];
    /* name may be localized. */
    if (MB_CUR_MAX == 1)
	printf("%-30s %10d %10d\n", name, count, size);
    else {
	/* Name may already be in the pad_striing static buffer */
	(void) mb_strncpy(msg_buf, name, INIT_BUF_SIZE);
	    printf("%s %10d %10d\n", 
		   pad_string(-1, 30, 0, msg_buf), 
		   count, 
		   size);
    }
} /* end print_size */

/*
 * prefix() returns TRUE if s1 is a prefix of s2
 */

Boolean prefix(s1, s2)
register unsigned char *s1, *s2;
{
    while (*s1) {
	if (*s1++ != *s2++)
            return (FALSE);
    }
    return (TRUE);
} /* end prefix */

cleanup(status)
int status;
{
    if (save_data)
        unlink(data_file);
    if (status && (!keep_aout)) 
        unlink(output_name);
    if (save_fixups)
        unlink(fixup_file);
    if (fdp_delete_link_order && fdp_link_order_file_name)
        unlink(fdp_link_order_file_name);
    /* Remove temporary isom files, if appropriate */
    if (ld_after_be_process && !keep_compiled_isoms)
	cleanup_compiled_isom_files();
} /* end cleanup */

/*************************************************************
** FUNCTION:	ld_gets
**
** DESCRIPTION:	Linker substitute for catgets.  The message file may not
**		be open yet, so we call open_catalog if it isn't open
**		then use catgets to get the message.  Except for not
**		having the catalog descriptor as the first argument, this
**		routine is equivalent to catgets(3c).
**
** Note:	If compiled with DEBUG_LD_GETS, code is executed which 
**		prints an error message if the message retreived from the
**		catalog does not match the default.
**
**
*************************************************************/

char *ld_gets(int set_num, int msg_num, const char *default_msg)
{
    char *	message;

    if (! IS_MSG_FILE_OPEN)
	if (!open_catalog())
	    return((char *) default_msg);
    return(catgets(msg_fd, set_num, msg_num, default_msg));
} /* end ld_gets */

#ifdef ESOM
int
get_memory_type(subsp_name, is_private)
char *subsp_name;
int is_private;
{
    static struct {
	char *name;
	int  type;
    } memory_type[] = {
	{"$SEMA_DATA$", CNX_INIT_SEMAPH },
	{"$NPDATA$", CNX_INIT_NODE },
	{"$NPDATA2$", CNX_INIT_NODE },
	{"$NSDATA$", CNX_INIT_NEAR },
	{"$NSDATA2$", CNX_INIT_NEAR },
	{"$FSDATA$", CNX_INIT_FAR },
	{"$FSDATA2$", CNX_INIT_FAR },
	{"$SEMA_BSS$", CNX_INIT_SEMAPH },
	{"$NPBSS$", CNX_INIT_NODE },
	{"$NSBSS$", CNX_INIT_NEAR },
	{"$FSBSS$", CNX_INIT_FAR },
	{ 0, 0 }
    };
    int i;
    
    if ( !is_private )
	return CNX_INIT_TEXT;
    
    for ( i = 0; memory_type[i].name != NULL; i++ ) {
	if ( strcmp(subsp_name, memory_type[i].name) == 0 )
	    return memory_type[i].type;
    }
    
    return CNX_INIT_PRIVATE;
}
#endif /* ESOM */
