#include "lib/headers.h"

#define print1(str, num) \
	print(str); \
	hex((unsigned long)num, buf); \
	print(buf); \
	print("\n")

long sig_delivered = 0;

void signal_handler(int signal) {
	char buf[256];
	print1("Signal handler called with signal ", signal);
	sig_delivered++;
}

unsigned long code = 42;

int main(void) {
	int fd;
	char buf[256];
	char *maddr, *remapaddr;
	const char *text = "this is some text to put in the file\n\0";
	const unsigned long len = 4096*10; /* 100 pages */
	int i;
	int loops = 10;

	hex((unsigned long)buf, buf);
	print("Buffer is at ");
	print(buf);
	print("\n");

	fd = open("/tmp/tmp", O_CREAT| O_RDWR, 0644);

	print1("file opened, fd is ", fd);

	if(fd < 0) {
		print("failed to open\n");
		exit(1);
	}

	/* clear it for use */
	ftruncate(fd, len);

	maddr = mmap(NULL, len, PROT_READ | PROT_WRITE, MAP_SHARED, fd, 0);

	print1("File is mmapped at ", maddr);

	for(i = 0; i < strlen(text)+1; i++)
		maddr[i] = text[i];
		
	msync(maddr, len, MS_SYNC);

	remapaddr = mmap(NULL, len, PROT_READ, MAP_PRIVATE, fd, 0);

	print1("Remapped address is ", remapaddr);

	print("File contents are: ");
	print(remapaddr);
	

	close(fd);


	print("Testing signal delivery in non-syscall case\n");
	
	signal(SIGALRM, signal_handler);

	alarm(10);

	for(i = 0; i < loops; i++) {
		int delay = 10000000;

		print("hello world\n");
		while(delay--)
			;
	}
	if(sig_delivered == 0) {
		print("FAILED: signal not delivered\n");
		return 0;
	}
	sig_delivered = 0;

	print("Testing signal delivery in the syscall case\n");

	for (i = 0; i < loops; i++) {
		print("hello world\n");
		signal(SIGALRM, signal_handler);
		alarm(10);
		sleep(100);
	}
	if(sig_delivered == 0) {
		print("FAILED: signal not delivered\n");
		return 0;
	}
	print1("successful signal delivery; number = ", sig_delivered);
	
	print1("Program exiting with return code ", code);
	return code;
}
